/*
 ** Copyright 2011, The Android Open Source Project
 **
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 **
 **     http://www.apache.org/licenses/LICENSE-2.0
 **
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 */

// auto generated by generate_MessageFormatter_java.py"

package com.android.ide.eclipse.gldebugger;

import java.nio.ByteBuffer;

public class MessageFormatter {

    static String formatFloats(int count, final ByteBuffer data) {
        if (data.remaining() == 0)
            return "{}";
        data.order(GLFramesView.TARGET_BYTE_ORDER);
        String ret = "{";
        for (int i = 0; i < count; i++) {
            ret += Float.intBitsToFloat(data.getInt());
            if (i < count - 1)
                ret += ", ";
        }
        return ret + "}";
    }

    static String formatInts(int count, final ByteBuffer data) {
        if (data.remaining() == 0)
            return "{}";
        data.order(GLFramesView.TARGET_BYTE_ORDER);
        String ret = "{";
        for (int i = 0; i < count; i++) {
            ret += data.getInt();
            if (i < count - 1)
                ret += ", ";
        }
        return ret + "}";
    }

    static String formatUInts(int count, final ByteBuffer data) {
        if (data.remaining() == 0)
            return "{}";
        data.order(GLFramesView.TARGET_BYTE_ORDER);
        String ret = "{";
        for (int i = 0; i < count; i++) {
            long bits = data.getInt() & 0xffffffff;
            ret += bits;
            if (i < count - 1)
                ret += ", ";
        }
        return ret + "}";
    }

    static String formatMatrix(int columns, int count, final ByteBuffer data) {
        if (data.remaining() == 0)
            return "{}";
        data.order(GLFramesView.TARGET_BYTE_ORDER);
        String ret = "{";
        for (int i = 0; i < count; i++) {
            ret += Float.intBitsToFloat(data.getInt());
            if (i < count - 1)
                ret += ", ";
            if (i % columns == columns - 1)
                ret += "\n                                             ";
        }
        return ret + "}";
    }

    public static String format(final DebuggerMessage.Message msg,
                                final boolean code) {
        String str;
        switch (msg.getFunction()) {
            case glActiveTexture:
                str = String.format("%s(%s%s)",
                    (code ? "glActiveTexture" : "void")
                    , (code ? "/*texture*/ " : "texture=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glAttachShader:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glAttachShader" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg1());
                break;
            case glBindAttribLocation:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glBindAttribLocation" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg1()
                    , (code ? "/*name*/ " : "name=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glBindBuffer:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glBindBuffer" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*buffer*/ " : "buffer=")
                    , (code ? "buffer_" : "") + msg.getArg1());
                break;
            case glBindFramebuffer:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glBindFramebuffer" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*framebuffer*/ " : "framebuffer=")
                    , (code ? "framebuffer_" : "") + msg.getArg1());
                break;
            case glBindRenderbuffer:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glBindRenderbuffer" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*renderbuffer*/ " : "renderbuffer=")
                    , (code ? "renderbuffer_" : "") + msg.getArg1());
                break;
            case glBindTexture:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glBindTexture" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*texture*/ " : "texture=")
                    , (code ? "texture_" : "") + msg.getArg1());
                break;
            case glBlendColor:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glBlendColor" : "void")
                    , (code ? "/*red*/ " : "red=")
                    , Float.intBitsToFloat(msg.getArg0())
                    , (code ? "/*green*/ " : "green=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*blue*/ " : "blue=")
                    , Float.intBitsToFloat(msg.getArg2())
                    , (code ? "/*alpha*/ " : "alpha=")
                    , Float.intBitsToFloat(msg.getArg3()));
                break;
            case glBlendEquation:
                str = String.format("%s(%s%s)",
                    (code ? "glBlendEquation" : "void")
                    , (code ? "/*mode*/ " : "mode=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glBlendEquationSeparate:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glBlendEquationSeparate" : "void")
                    , (code ? "/*modeRGB*/ " : "modeRGB=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*modeAlpha*/ " : "modeAlpha=")
                    , GLEnum.valueOf(msg.getArg1()));
                break;
            case glBlendFunc:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glBlendFunc" : "void")
                    , (code ? "/*sfactor*/ " : "sfactor=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*dfactor*/ " : "dfactor=")
                    , GLEnum.valueOf(msg.getArg1()));
                break;
            case glBlendFuncSeparate:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glBlendFuncSeparate" : "void")
                    , (code ? "/*srcRGB*/ " : "srcRGB=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*dstRGB*/ " : "dstRGB=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*srcAlpha*/ " : "srcAlpha=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*dstAlpha*/ " : "dstAlpha=")
                    , GLEnum.valueOf(msg.getArg3()));
                break;
            case glBufferData:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glBufferData" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*size*/ " : "size=")
                    , msg.getArg1()
                    , (code ? "/*data*/ " : "data=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2()))
                    , (code ? "/*usage*/ " : "usage=")
                    , GLEnum.valueOf(msg.getArg3()));
                break;
            case glBufferSubData:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glBufferSubData" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*offset*/ " : "offset=")
                    , msg.getArg1()
                    , (code ? "/*size*/ " : "size=")
                    , msg.getArg2()
                    , (code ? "/*data*/ " : "data=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3())));
                break;
            case glCheckFramebufferStatus:
                str = String.format("%s(%s%s)",
                    (code ? "glCheckFramebufferStatus" : GLEnum.valueOf(msg.getRet()))
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glClear:
                str = String.format("%s(%s%s)",
                    (code ? "glClear" : "void")
                    , (code ? "/*mask*/ " : "mask=")
                    , msg.getArg0());
                break;
            case glClearColor:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glClearColor" : "void")
                    , (code ? "/*red*/ " : "red=")
                    , Float.intBitsToFloat(msg.getArg0())
                    , (code ? "/*green*/ " : "green=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*blue*/ " : "blue=")
                    , Float.intBitsToFloat(msg.getArg2())
                    , (code ? "/*alpha*/ " : "alpha=")
                    , Float.intBitsToFloat(msg.getArg3()));
                break;
            case glClearDepthf:
                str = String.format("%s(%s%s)",
                    (code ? "glClearDepthf" : "void")
                    , (code ? "/*depth*/ " : "depth=")
                    , Float.intBitsToFloat(msg.getArg0()));
                break;
            case glClearStencil:
                str = String.format("%s(%s%s)",
                    (code ? "glClearStencil" : "void")
                    , (code ? "/*s*/ " : "s=")
                    , msg.getArg0());
                break;
            case glColorMask:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glColorMask" : "void")
                    , (code ? "/*red*/ " : "red=")
                    , msg.getArg0()
                    , (code ? "/*green*/ " : "green=")
                    , msg.getArg1()
                    , (code ? "/*blue*/ " : "blue=")
                    , msg.getArg2()
                    , (code ? "/*alpha*/ " : "alpha=")
                    , msg.getArg3());
                break;
            case glCompileShader:
                str = String.format("%s(%s%s)",
                    (code ? "glCompileShader" : "void")
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg0());
                break;
            case glCompressedTexImage2D:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glCompressedTexImage2D" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*level*/ " : "level=")
                    , msg.getArg1()
                    , (code ? "/*internalformat*/ " : "internalformat=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg3()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg4()
                    , (code ? "/*border*/ " : "border=")
                    , msg.getArg5()
                    , (code ? "/*imageSize*/ " : "imageSize=")
                    , msg.getArg6()
                    , (code ? "/*data*/ " : "data=")
                    , (code ? "arg7" : "0x" + Integer.toHexString(msg.getArg7())));
                break;
            case glCompressedTexSubImage2D:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glCompressedTexSubImage2D" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*level*/ " : "level=")
                    , msg.getArg1()
                    , (code ? "/*xoffset*/ " : "xoffset=")
                    , msg.getArg2()
                    , (code ? "/*yoffset*/ " : "yoffset=")
                    , msg.getArg3()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg4()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg5()
                    , (code ? "/*format*/ " : "format=")
                    , GLEnum.valueOf(msg.getArg6())
                    , (code ? "/*imageSize*/ " : "imageSize=")
                    , msg.getArg7()
                    , (code ? "/*data*/ " : "data=")
                    , (code ? "arg8" : "0x" + Integer.toHexString(msg.getArg8())));
                break;
            case glCopyTexImage2D:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glCopyTexImage2D" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*level*/ " : "level=")
                    , msg.getArg1()
                    , (code ? "/*internalformat*/ " : "internalformat=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg3()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg4()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg5()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg6()
                    , (code ? "/*border*/ " : "border=")
                    , msg.getArg7());
                break;
            case glCopyTexSubImage2D:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glCopyTexSubImage2D" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*level*/ " : "level=")
                    , msg.getArg1()
                    , (code ? "/*xoffset*/ " : "xoffset=")
                    , msg.getArg2()
                    , (code ? "/*yoffset*/ " : "yoffset=")
                    , msg.getArg3()
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg4()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg5()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg6()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg7());
                break;
            case glCreateProgram:
                str = String.format("%s()",
                    (code ? "glCreateProgram" : msg.getRet())
);
                break;
            case glCreateShader:
                str = String.format("%s(%s%s)",
                    (code ? "glCreateShader" : msg.getRet())
                    , (code ? "/*type*/ " : "type=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glCullFace:
                str = String.format("%s(%s%s)",
                    (code ? "glCullFace" : "void")
                    , (code ? "/*mode*/ " : "mode=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glDeleteBuffers:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glDeleteBuffers" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*buffers*/ " : "buffers=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glDeleteFramebuffers:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glDeleteFramebuffers" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*framebuffers*/ " : "framebuffers=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glDeleteProgram:
                str = String.format("%s(%s%s)",
                    (code ? "glDeleteProgram" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0());
                break;
            case glDeleteRenderbuffers:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glDeleteRenderbuffers" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*renderbuffers*/ " : "renderbuffers=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glDeleteShader:
                str = String.format("%s(%s%s)",
                    (code ? "glDeleteShader" : "void")
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg0());
                break;
            case glDeleteTextures:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glDeleteTextures" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*textures*/ " : "textures=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glDepthFunc:
                str = String.format("%s(%s%s)",
                    (code ? "glDepthFunc" : "void")
                    , (code ? "/*func*/ " : "func=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glDepthMask:
                str = String.format("%s(%s%s)",
                    (code ? "glDepthMask" : "void")
                    , (code ? "/*flag*/ " : "flag=")
                    , msg.getArg0());
                break;
            case glDepthRangef:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glDepthRangef" : "void")
                    , (code ? "/*zNear*/ " : "zNear=")
                    , Float.intBitsToFloat(msg.getArg0())
                    , (code ? "/*zFar*/ " : "zFar=")
                    , Float.intBitsToFloat(msg.getArg1()));
                break;
            case glDetachShader:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glDetachShader" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg1());
                break;
            case glDisable:
                str = String.format("%s(%s%s)",
                    (code ? "glDisable" : "void")
                    , (code ? "/*cap*/ " : "cap=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glDisableVertexAttribArray:
                str = String.format("%s(%s%s)",
                    (code ? "glDisableVertexAttribArray" : "void")
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg0());
                break;
            case glDrawArrays:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glDrawArrays" : "void")
                    , (code ? "/*mode*/ " : "mode=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*first*/ " : "first=")
                    , msg.getArg1()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg2());
                break;
            case glDrawElements:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glDrawElements" : "void")
                    , (code ? "/*mode*/ " : "mode=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*type*/ " : "type=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*indices*/ " : "indices=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3())));
                break;
            case glEnable:
                str = String.format("%s(%s%s)",
                    (code ? "glEnable" : "void")
                    , (code ? "/*cap*/ " : "cap=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glEnableVertexAttribArray:
                str = String.format("%s(%s%s)",
                    (code ? "glEnableVertexAttribArray" : "void")
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg0());
                break;
            case glFinish:
                str = String.format("%s()",
                    (code ? "glFinish" : "void")
);
                break;
            case glFlush:
                str = String.format("%s()",
                    (code ? "glFlush" : "void")
);
                break;
            case glFramebufferRenderbuffer:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glFramebufferRenderbuffer" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*attachment*/ " : "attachment=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*renderbuffertarget*/ " : "renderbuffertarget=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*renderbuffer*/ " : "renderbuffer=")
                    , (code ? "renderbuffer_" : "") + msg.getArg3());
                break;
            case glFramebufferTexture2D:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glFramebufferTexture2D" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*attachment*/ " : "attachment=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*textarget*/ " : "textarget=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*texture*/ " : "texture=")
                    , (code ? "texture_" : "") + msg.getArg3()
                    , (code ? "/*level*/ " : "level=")
                    , msg.getArg4());
                break;
            case glFrontFace:
                str = String.format("%s(%s%s)",
                    (code ? "glFrontFace" : "void")
                    , (code ? "/*mode*/ " : "mode=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glGenBuffers:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGenBuffers" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*buffers*/ " : "buffers=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glGenerateMipmap:
                str = String.format("%s(%s%s)",
                    (code ? "glGenerateMipmap" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glGenFramebuffers:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGenFramebuffers" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*framebuffers*/ " : "framebuffers=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glGenRenderbuffers:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGenRenderbuffers" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*renderbuffers*/ " : "renderbuffers=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glGenTextures:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGenTextures" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*textures*/ " : "textures=")
                    , (code ? "(GLuint [])" : "") +  formatUInts(1 * msg.getArg0(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glGetActiveAttrib:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetActiveAttrib" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg1()
                    , (code ? "/*bufsize*/ " : "bufsize=")
                    , msg.getArg2()
                    , (code ? "/*length*/ " : "length=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3()))
                    , (code ? "/*size*/ " : "size=")
                    , (code ? "arg4" : "0x" + Integer.toHexString(msg.getArg4()))
                    , (code ? "/*type*/ " : "type=")
                    , (code ? "arg5" : "0x" + Integer.toHexString(msg.getArg5()))
                    , (code ? "/*name*/ " : "name=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glGetActiveUniform:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetActiveUniform" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg1()
                    , (code ? "/*bufsize*/ " : "bufsize=")
                    , msg.getArg2()
                    , (code ? "/*length*/ " : "length=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3()))
                    , (code ? "/*size*/ " : "size=")
                    , (code ? "arg4" : "0x" + Integer.toHexString(msg.getArg4()))
                    , (code ? "/*type*/ " : "type=")
                    , (code ? "arg5" : "0x" + Integer.toHexString(msg.getArg5()))
                    , (code ? "/*name*/ " : "name=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glGetAttachedShaders:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetAttachedShaders" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*maxcount*/ " : "maxcount=")
                    , msg.getArg1()
                    , (code ? "/*count*/ " : "count=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2()))
                    , (code ? "/*shaders*/ " : "shaders=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3())));
                break;
            case glGetAttribLocation:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGetAttribLocation" : msg.getRet())
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*name*/ " : "name=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glGetBooleanv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGetBooleanv" : "void")
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg1" : "0x" + Integer.toHexString(msg.getArg1())));
                break;
            case glGetBufferParameteriv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetBufferParameteriv" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetError:
                str = String.format("%s()",
                    (code ? "glGetError" : GLEnum.valueOf(msg.getRet()))
);
                break;
            case glGetFloatv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGetFloatv" : "void")
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg1" : "0x" + Integer.toHexString(msg.getArg1())));
                break;
            case glGetFramebufferAttachmentParameteriv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetFramebufferAttachmentParameteriv" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*attachment*/ " : "attachment=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3())));
                break;
            case glGetIntegerv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGetIntegerv" : "void")
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg1" : "0x" + Integer.toHexString(msg.getArg1())));
                break;
            case glGetProgramiv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetProgramiv" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "(GLint [])" : "") + formatInts(1, msg.getData().asReadOnlyByteBuffer()));
                break;
            case glGetProgramInfoLog:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetProgramInfoLog" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*bufsize*/ " : "bufsize=")
                    , msg.getArg1()
                    , (code ? "/*length*/ " : "length=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2()))
                    , (code ? "/*infolog*/ " : "infolog=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glGetRenderbufferParameteriv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetRenderbufferParameteriv" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetShaderiv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetShaderiv" : "void")
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg0()
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "(GLint [])" : "") + formatInts(1, msg.getData().asReadOnlyByteBuffer()));
                break;
            case glGetShaderInfoLog:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetShaderInfoLog" : "void")
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg0()
                    , (code ? "/*bufsize*/ " : "bufsize=")
                    , msg.getArg1()
                    , (code ? "/*length*/ " : "length=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2()))
                    , (code ? "/*infolog*/ " : "infolog=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glGetShaderPrecisionFormat:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetShaderPrecisionFormat" : "void")
                    , (code ? "/*shadertype*/ " : "shadertype=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*precisiontype*/ " : "precisiontype=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*range*/ " : "range=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2()))
                    , (code ? "/*precision*/ " : "precision=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3())));
                break;
            case glGetShaderSource:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glGetShaderSource" : "void")
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg0()
                    , (code ? "/*bufsize*/ " : "bufsize=")
                    , msg.getArg1()
                    , (code ? "/*length*/ " : "length=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2()))
                    , (code ? "/*source*/ " : "source=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glGetString:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s)",
                    (code ? "glGetString" : "0x" + Integer.toHexString(msg.getRet()))
                    , (code ? "/*name*/ " : "name=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glGetTexParameterfv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetTexParameterfv" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetTexParameteriv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetTexParameteriv" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetUniformfv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetUniformfv" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg1()
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetUniformiv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetUniformiv" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg1()
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetUniformLocation:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glGetUniformLocation" : msg.getRet())
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0()
                    , (code ? "/*name*/ " : "name=")
                    , (code ? "\"" : "") + msg.getData().toStringUtf8() + (code ? "\"" : ""));
                break;
            case glGetVertexAttribfv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetVertexAttribfv" : "void")
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg0()
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetVertexAttribiv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetVertexAttribiv" : "void")
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg0()
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glGetVertexAttribPointerv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glGetVertexAttribPointerv" : "void")
                    , (code ? "/*index*/ " : "index=")
                    , msg.getArg0()
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*pointer*/ " : "pointer=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glHint:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glHint" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*mode*/ " : "mode=")
                    , GLEnum.valueOf(msg.getArg1()));
                break;
            case glIsBuffer:
                str = String.format("%s(%s%s)",
                    (code ? "glIsBuffer" : msg.getRet())
                    , (code ? "/*buffer*/ " : "buffer=")
                    , (code ? "buffer_" : "") + msg.getArg0());
                break;
            case glIsEnabled:
                str = String.format("%s(%s%s)",
                    (code ? "glIsEnabled" : msg.getRet())
                    , (code ? "/*cap*/ " : "cap=")
                    , GLEnum.valueOf(msg.getArg0()));
                break;
            case glIsFramebuffer:
                str = String.format("%s(%s%s)",
                    (code ? "glIsFramebuffer" : msg.getRet())
                    , (code ? "/*framebuffer*/ " : "framebuffer=")
                    , (code ? "framebuffer_" : "") + msg.getArg0());
                break;
            case glIsProgram:
                str = String.format("%s(%s%s)",
                    (code ? "glIsProgram" : msg.getRet())
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0());
                break;
            case glIsRenderbuffer:
                str = String.format("%s(%s%s)",
                    (code ? "glIsRenderbuffer" : msg.getRet())
                    , (code ? "/*renderbuffer*/ " : "renderbuffer=")
                    , (code ? "renderbuffer_" : "") + msg.getArg0());
                break;
            case glIsShader:
                str = String.format("%s(%s%s)",
                    (code ? "glIsShader" : msg.getRet())
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg0());
                break;
            case glIsTexture:
                str = String.format("%s(%s%s)",
                    (code ? "glIsTexture" : msg.getRet())
                    , (code ? "/*texture*/ " : "texture=")
                    , (code ? "texture_" : "") + msg.getArg0());
                break;
            case glLineWidth:
                str = String.format("%s(%s%s)",
                    (code ? "glLineWidth" : "void")
                    , (code ? "/*width*/ " : "width=")
                    , Float.intBitsToFloat(msg.getArg0()));
                break;
            case glLinkProgram:
                str = String.format("%s(%s%s)",
                    (code ? "glLinkProgram" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0());
                break;
            case glPixelStorei:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glPixelStorei" : "void")
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*param*/ " : "param=")
                    , msg.getArg1());
                break;
            case glPolygonOffset:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glPolygonOffset" : "void")
                    , (code ? "/*factor*/ " : "factor=")
                    , Float.intBitsToFloat(msg.getArg0())
                    , (code ? "/*units*/ " : "units=")
                    , Float.intBitsToFloat(msg.getArg1()));
                break;
            case glReadPixels:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glReadPixels" : "void")
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg0()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg1()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg2()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg3()
                    , (code ? "/*format*/ " : "format=")
                    , GLEnum.valueOf(msg.getArg4())
                    , (code ? "/*type*/ " : "type=")
                    , GLEnum.valueOf(msg.getArg5())
                    , (code ? "/*pixels*/ " : "pixels=")
                    , (code ? "arg6" : "0x" + Integer.toHexString(msg.getArg6())));
                break;
            case glReleaseShaderCompiler:
                str = String.format("%s()",
                    (code ? "glReleaseShaderCompiler" : "void")
);
                break;
            case glRenderbufferStorage:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glRenderbufferStorage" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*internalformat*/ " : "internalformat=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg2()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg3());
                break;
            case glSampleCoverage:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glSampleCoverage" : "void")
                    , (code ? "/*value*/ " : "value=")
                    , Float.intBitsToFloat(msg.getArg0())
                    , (code ? "/*invert*/ " : "invert=")
                    , msg.getArg1());
                break;
            case glScissor:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glScissor" : "void")
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg0()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg1()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg2()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg3());
                break;
            case glShaderBinary:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glShaderBinary" : "void")
                    , (code ? "/*n*/ " : "n=")
                    , msg.getArg0()
                    , (code ? "/*shaders*/ " : "shaders=")
                    , (code ? "arg1" : "0x" + Integer.toHexString(msg.getArg1()))
                    , (code ? "/*binaryformat*/ " : "binaryformat=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*binary*/ " : "binary=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3()))
                    , (code ? "/*length*/ " : "length=")
                    , msg.getArg4());
                break;
            case glShaderSource:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glShaderSource" : "void")
                    , (code ? "/*shader*/ " : "shader=")
                    , (code ? "shader_" : "") + msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*string*/ " : "string=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2()))
                    , (code ? "/*length*/ " : "length=")
                    , (code ? "arg3" : "0x" + Integer.toHexString(msg.getArg3())));
                break;
            case glStencilFunc:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glStencilFunc" : "void")
                    , (code ? "/*func*/ " : "func=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*ref*/ " : "ref=")
                    , msg.getArg1()
                    , (code ? "/*mask*/ " : "mask=")
                    , msg.getArg2());
                break;
            case glStencilFuncSeparate:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glStencilFuncSeparate" : "void")
                    , (code ? "/*face*/ " : "face=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*func*/ " : "func=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*ref*/ " : "ref=")
                    , msg.getArg2()
                    , (code ? "/*mask*/ " : "mask=")
                    , msg.getArg3());
                break;
            case glStencilMask:
                str = String.format("%s(%s%s)",
                    (code ? "glStencilMask" : "void")
                    , (code ? "/*mask*/ " : "mask=")
                    , msg.getArg0());
                break;
            case glStencilMaskSeparate:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glStencilMaskSeparate" : "void")
                    , (code ? "/*face*/ " : "face=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*mask*/ " : "mask=")
                    , msg.getArg1());
                break;
            case glStencilOp:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glStencilOp" : "void")
                    , (code ? "/*fail*/ " : "fail=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*zfail*/ " : "zfail=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*zpass*/ " : "zpass=")
                    , GLEnum.valueOf(msg.getArg2()));
                break;
            case glStencilOpSeparate:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glStencilOpSeparate" : "void")
                    , (code ? "/*face*/ " : "face=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*fail*/ " : "fail=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*zfail*/ " : "zfail=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*zpass*/ " : "zpass=")
                    , GLEnum.valueOf(msg.getArg3()));
                break;
            case glTexImage2D:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glTexImage2D" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*level*/ " : "level=")
                    , msg.getArg1()
                    , (code ? "/*internalformat*/ " : "internalformat=")
                    , msg.getArg2()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg3()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg4()
                    , (code ? "/*border*/ " : "border=")
                    , msg.getArg5()
                    , (code ? "/*format*/ " : "format=")
                    , GLEnum.valueOf(msg.getArg6())
                    , (code ? "/*type*/ " : "type=")
                    , GLEnum.valueOf(msg.getArg7())
                    , (code ? "/*pixels*/ " : "pixels=")
                    , (code ? "arg8" : "0x" + Integer.toHexString(msg.getArg8())));
                break;
            case glTexParameterf:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glTexParameterf" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*param*/ " : "param=")
                    , Float.intBitsToFloat(msg.getArg2()));
                break;
            case glTexParameterfv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glTexParameterfv" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glTexParameteri:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glTexParameteri" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*param*/ " : "param=")
                    , msg.getArg2());
                break;
            case glTexParameteriv:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glTexParameteriv" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*pname*/ " : "pname=")
                    , GLEnum.valueOf(msg.getArg1())
                    , (code ? "/*params*/ " : "params=")
                    , (code ? "arg2" : "0x" + Integer.toHexString(msg.getArg2())));
                break;
            case glTexSubImage2D:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glTexSubImage2D" : "void")
                    , (code ? "/*target*/ " : "target=")
                    , GLEnum.valueOf(msg.getArg0())
                    , (code ? "/*level*/ " : "level=")
                    , msg.getArg1()
                    , (code ? "/*xoffset*/ " : "xoffset=")
                    , msg.getArg2()
                    , (code ? "/*yoffset*/ " : "yoffset=")
                    , msg.getArg3()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg4()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg5()
                    , (code ? "/*format*/ " : "format=")
                    , GLEnum.valueOf(msg.getArg6())
                    , (code ? "/*type*/ " : "type=")
                    , GLEnum.valueOf(msg.getArg7())
                    , (code ? "/*pixels*/ " : "pixels=")
                    , (code ? "arg8" : "0x" + Integer.toHexString(msg.getArg8())));
                break;
            case glUniform1f:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glUniform1f" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1()));
                break;
            case glUniform1fv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform1fv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLfloat [])" : "") +  formatFloats(1 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniform1i:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glUniform1i" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg1());
                break;
            case glUniform1iv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform1iv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLint [])" : "") +  formatInts(1 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniform2f:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform2f" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*y*/ " : "y=")
                    , Float.intBitsToFloat(msg.getArg2()));
                break;
            case glUniform2fv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform2fv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLfloat [])" : "") +  formatFloats(2 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniform2i:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform2i" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg1()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg2());
                break;
            case glUniform2iv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform2iv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLint [])" : "") +  formatInts(2 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniform3f:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glUniform3f" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*y*/ " : "y=")
                    , Float.intBitsToFloat(msg.getArg2())
                    , (code ? "/*z*/ " : "z=")
                    , Float.intBitsToFloat(msg.getArg3()));
                break;
            case glUniform3fv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform3fv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLfloat [])" : "") +  formatFloats(3 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniform3i:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glUniform3i" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg1()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg2()
                    , (code ? "/*z*/ " : "z=")
                    , msg.getArg3());
                break;
            case glUniform3iv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform3iv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLint [])" : "") +  formatInts(3 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniform4f:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glUniform4f" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*y*/ " : "y=")
                    , Float.intBitsToFloat(msg.getArg2())
                    , (code ? "/*z*/ " : "z=")
                    , Float.intBitsToFloat(msg.getArg3())
                    , (code ? "/*w*/ " : "w=")
                    , Float.intBitsToFloat(msg.getArg4()));
                break;
            case glUniform4fv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform4fv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLfloat [])" : "") +  formatFloats(4 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniform4i:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glUniform4i" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg1()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg2()
                    , (code ? "/*z*/ " : "z=")
                    , msg.getArg3()
                    , (code ? "/*w*/ " : "w=")
                    , msg.getArg4());
                break;
            case glUniform4iv:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glUniform4iv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*v*/ " : "v=")
                    , (code ? "(GLint [])" : "") +  formatInts(4 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniformMatrix2fv:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glUniformMatrix2fv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*transpose*/ " : "transpose=")
                    , msg.getArg2()
                    , (code ? "/*value*/ " : "value=")
                    , (code ? "(GLfloat [])" : "") + formatMatrix(2, 4 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniformMatrix3fv:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glUniformMatrix3fv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*transpose*/ " : "transpose=")
                    , msg.getArg2()
                    , (code ? "/*value*/ " : "value=")
                    , (code ? "(GLfloat [])" : "") + formatMatrix(3, 9 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUniformMatrix4fv:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glUniformMatrix4fv" : "void")
                    , (code ? "/*location*/ " : "location=")
                    , msg.getArg0()
                    , (code ? "/*count*/ " : "count=")
                    , msg.getArg1()
                    , (code ? "/*transpose*/ " : "transpose=")
                    , msg.getArg2()
                    , (code ? "/*value*/ " : "value=")
                    , (code ? "(GLfloat [])" : "") + formatMatrix(4, 16 * msg.getArg1(), msg.getData().asReadOnlyByteBuffer()));
                break;
            case glUseProgram:
                str = String.format("%s(%s%s)",
                    (code ? "glUseProgram" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0());
                break;
            case glValidateProgram:
                str = String.format("%s(%s%s)",
                    (code ? "glValidateProgram" : "void")
                    , (code ? "/*program*/ " : "program=")
                    , (code ? "program_" : "") + msg.getArg0());
                break;
            case glVertexAttrib1f:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glVertexAttrib1f" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1()));
                break;
            case glVertexAttrib1fv:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glVertexAttrib1fv" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*values*/ " : "values=")
                    , (code ? "(GLfloat [])" : "") + formatFloats(1, msg.getData().asReadOnlyByteBuffer()));
                break;
            case glVertexAttrib2f:
                str = String.format("%s(%s%s, %s%s, %s%s)",
                    (code ? "glVertexAttrib2f" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*y*/ " : "y=")
                    , Float.intBitsToFloat(msg.getArg2()));
                break;
            case glVertexAttrib2fv:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glVertexAttrib2fv" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*values*/ " : "values=")
                    , (code ? "(GLfloat [])" : "") + formatFloats(2, msg.getData().asReadOnlyByteBuffer()));
                break;
            case glVertexAttrib3f:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glVertexAttrib3f" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*y*/ " : "y=")
                    , Float.intBitsToFloat(msg.getArg2())
                    , (code ? "/*z*/ " : "z=")
                    , Float.intBitsToFloat(msg.getArg3()));
                break;
            case glVertexAttrib3fv:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glVertexAttrib3fv" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*values*/ " : "values=")
                    , (code ? "(GLfloat [])" : "") + formatFloats(3, msg.getData().asReadOnlyByteBuffer()));
                break;
            case glVertexAttrib4f:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glVertexAttrib4f" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*x*/ " : "x=")
                    , Float.intBitsToFloat(msg.getArg1())
                    , (code ? "/*y*/ " : "y=")
                    , Float.intBitsToFloat(msg.getArg2())
                    , (code ? "/*z*/ " : "z=")
                    , Float.intBitsToFloat(msg.getArg3())
                    , (code ? "/*w*/ " : "w=")
                    , Float.intBitsToFloat(msg.getArg4()));
                break;
            case glVertexAttrib4fv:
                str = String.format("%s(%s%s, %s%s)",
                    (code ? "glVertexAttrib4fv" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*values*/ " : "values=")
                    , (code ? "(GLfloat [])" : "") + formatFloats(4, msg.getData().asReadOnlyByteBuffer()));
                break;
            case glVertexAttribPointer:
                // FIXME: this function uses pointers, debugger may send data in msg.data
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s, %s%s, %s%s)",
                    (code ? "glVertexAttribPointer" : "void")
                    , (code ? "/*indx*/ " : "indx=")
                    , msg.getArg0()
                    , (code ? "/*size*/ " : "size=")
                    , msg.getArg1()
                    , (code ? "/*type*/ " : "type=")
                    , GLEnum.valueOf(msg.getArg2())
                    , (code ? "/*normalized*/ " : "normalized=")
                    , msg.getArg3()
                    , (code ? "/*stride*/ " : "stride=")
                    , msg.getArg4()
                    , (code ? "/*ptr*/ " : "ptr=")
                    , (code ? "arg5" : "0x" + Integer.toHexString(msg.getArg5())));
                break;
            case glViewport:
                str = String.format("%s(%s%s, %s%s, %s%s, %s%s)",
                    (code ? "glViewport" : "void")
                    , (code ? "/*x*/ " : "x=")
                    , msg.getArg0()
                    , (code ? "/*y*/ " : "y=")
                    , msg.getArg1()
                    , (code ? "/*width*/ " : "width=")
                    , msg.getArg2()
                    , (code ? "/*height*/ " : "height=")
                    , msg.getArg3());
                break;
            default:
                str = msg.toString();
        }
        return str;
    }
}
