/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Eclipse Public License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.eclipse.org/org/documents/epl-v10.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.ide.eclipse.adt.internal.refactorings.extractstring;

import org.eclipse.text.edits.TextEditGroup;

/**
 * A {@link TextEditGroup} that we want to enable or disable by default.
 * This is used to propose a change that may not compile, so we'll create
 * a change that is disabled.
 * <p/>
 * Disabling the change is done by the refactoring class when processing
 * the text edit groups generated by the Java AST visitor.
 */
class EnabledTextEditGroup extends TextEditGroup {
    private final boolean mEnabled;

    public EnabledTextEditGroup(String name, boolean enabled) {
        super(name);
        mEnabled = enabled;
    }

    public boolean isEnabled() {
        return mEnabled;
    }
}
