/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Eclipse Public License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.eclipse.org/org/documents/epl-v10.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.ide.eclipse.adt.internal.editors.manifest.descriptors;

import com.android.ide.eclipse.adt.editors.layout.gscripts.IAttributeInfo;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.model.UiManifestPkgAttrNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;

/**
 * Describes a package XML attribute. It is displayed by a {@link UiManifestPkgAttrNode}.
 * @deprecated Does not seem used anymore. Cleanup later.
 */
public class ManifestPkgAttrDescriptor extends TextAttributeDescriptor {

    public ManifestPkgAttrDescriptor(String xmlLocalName, String uiName, String nsUri,
            String tooltip, IAttributeInfo attrInfo) {
        super(xmlLocalName, uiName, nsUri, tooltip, attrInfo);
    }

    /**
     * @return A new {@link UiManifestPkgAttrNode} linked to this descriptor.
     */
    @Override
    public UiAttributeNode createUiNode(UiElementNode uiParent) {
        return new UiManifestPkgAttrNode(this, uiParent);
    }
}
