/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.api.IResourceValue;
import com.android.resources.ResourceType;

public class ResourceValue
extends ResourceReference
implements IResourceValue {
    private final ResourceType mType;
    private String mValue = null;

    public ResourceValue(ResourceType type, String name, boolean isFramework) {
        super(name, isFramework);
        this.mType = type;
    }

    public ResourceValue(ResourceType type, String name, String value, boolean isFramework) {
        super(name, isFramework);
        this.mType = type;
        this.mValue = value;
    }

    public ResourceType getResourceType() {
        return this.mType;
    }

    @Deprecated
    public String getType() {
        return this.mType.getName();
    }

    public final String getValue() {
        return this.mValue;
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public void replaceWith(ResourceValue value) {
        this.mValue = value.mValue;
    }

    public String toString() {
        return "ResourceValue [" + this.mType + "/" + this.getName() + " = " + this.mValue + " (framework:" + this.isFramework() + ")]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mType == null ? 0 : this.mType.hashCode());
        result = 31 * result + (this.mValue == null ? 0 : this.mValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceValue other = (ResourceValue)obj;
        if (this.mType == null ? other.mType != null : !this.mType.equals((Object)other.mType)) {
            return false;
        }
        return !(this.mValue == null ? other.mValue != null : !this.mValue.equals(other.mValue));
    }
}

