/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;

public class ScrollBarDrawData
extends RangeDrawData {
    public int thumb;
    public int increment;
    public int pageIncrement;

    public ScrollBarDrawData() {
        this.state = new int[6];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            RECT rECT = new RECT();
            if ((this.style & 0x200) != 0) {
                int n = OS.GetThemeSysSize(l, 2);
                rECT.left = rectangle.x;
                rECT.right = rECT.left + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + n;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.bottom = rectangle.y + rectangle.height;
                rECT.top = rECT.bottom - n;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                int n2 = rectangle.height - 2 * n;
                int n3 = Math.max(n / 2, n2 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n4 = rectangle.y + n + Math.max(0, n2 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.top = rectangle.y + n;
                rECT.bottom = n4;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rECT.top + n3;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(l, gC.handle, 9, nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rectangle.y + rectangle.height - n;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            } else {
                int n = OS.GetThemeSysSize(l, 2);
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + rectangle.height;
                rECT.left = rectangle.x;
                rECT.right = rECT.left + n;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.right = rectangle.x + rectangle.width;
                rECT.left = rECT.right - n;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                int n5 = rectangle.width - 2 * n;
                int n6 = Math.max(n / 2, n5 * this.thumb / (this.maximum - this.minimum));
                int n7 = rectangle.x + n + Math.max(0, n5 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.left = rectangle.x + n;
                rECT.right = n7;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rECT.left + n6;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(l, gC.handle, 8, nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rectangle.x + rectangle.width - n;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            }
            OS.CloseThemeData(l);
        }
    }

    char[] getClassId() {
        return SCROLLBAR;
    }

    int[] getPartId(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.state[n];
        switch (n) {
            case 1: {
                n2 = 1;
                if ((this.style & 0x200) != 0) {
                    n3 = 1;
                    if ((n4 & 0x40) != 0) {
                        n3 = 2;
                    }
                    if ((n4 & 8) != 0) {
                        n3 = 3;
                    }
                    if ((n4 & 0x20) == 0) break;
                    n3 = 4;
                    break;
                }
                n3 = 9;
                if ((n4 & 0x40) != 0) {
                    n3 = 10;
                }
                if ((n4 & 8) != 0) {
                    n3 = 11;
                }
                if ((n4 & 0x20) == 0) break;
                n3 = 12;
                break;
            }
            case 2: {
                n2 = 1;
                if ((this.style & 0x200) != 0) {
                    n3 = 5;
                    if ((n4 & 0x40) != 0) {
                        n3 = 6;
                    }
                    if ((n4 & 8) != 0) {
                        n3 = 7;
                    }
                    if ((n4 & 0x20) == 0) break;
                    n3 = 8;
                    break;
                }
                n3 = 13;
                if ((n4 & 0x40) != 0) {
                    n3 = 14;
                }
                if ((n4 & 8) != 0) {
                    n3 = 15;
                }
                if ((n4 & 0x20) == 0) break;
                n3 = 16;
                break;
            }
            case 0: 
            case 5: {
                if ((this.style & 0x200) != 0) {
                    n2 = 3;
                    break;
                }
                n2 = 2;
                break;
            }
            case 3: {
                if ((this.style & 0x200) != 0) {
                    n2 = 7;
                    break;
                }
                n2 = 5;
                break;
            }
            case 4: {
                n2 = (this.style & 0x200) != 0 ? 6 : 4;
            }
        }
        if (n != 2 && n != 1) {
            n3 = 1;
            if ((n4 & 0x40) != 0) {
                n3 = 2;
            }
            if ((n4 & 8) != 0) {
                n3 = 3;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 4;
            }
        }
        return new int[]{n2, n3};
    }

    Rectangle getBounds(int n, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n2 = OS.GetThemeSysSize(l, 2);
                int n3 = rectangle.height - 2 * n2;
                int n4 = Math.max(n2 / 2, n3 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n5 = rectangle.y + n2 + Math.max(0, n3 * this.selection / Math.max(1, this.maximum - this.minimum));
                switch (n) {
                    case 2: {
                        return new Rectangle(rectangle.x, rectangle.y + rectangle.height - n2, rectangle.width, n2);
                    }
                    case 1: {
                        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, n2);
                    }
                    case 3: {
                        return new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, n5 - rectangle.y - n2);
                    }
                    case 5: {
                        return new Rectangle(rectangle.x, n5, rectangle.width, n4);
                    }
                    case 4: {
                        return new Rectangle(rectangle.x, n5 + n4, rectangle.width, rectangle.y + rectangle.height - n2 - n5 - n4);
                    }
                }
            }
            OS.CloseThemeData(l);
        }
        return super.getBounds(n, rectangle);
    }

    int getSelection(Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n = OS.GetThemeSysSize(l, 2);
                int n2 = rectangle.height - 2 * n;
                int n3 = rectangle.y + n + Math.max(0, n2 * this.selection / Math.max(1, this.maximum - this.minimum));
                int n4 = ((n3 += point.y) - rectangle.y - n) * (this.maximum - this.minimum) / n2;
                return Math.max(0, Math.min(n4, this.maximum - this.thumb));
            }
            OS.CloseThemeData(l);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6) return -1;
        if (!OS.IsAppThemed()) {
            return -1;
        }
        long l = OS.OpenThemeData(0L, this.getClassId());
        int n = 0;
        RECT rECT = new RECT();
        POINT pOINT = new POINT();
        pOINT.x = point.x;
        pOINT.y = point.y;
        short[] sArray = new short[1];
        try {
            block28: {
                block29: {
                    int[] nArray;
                    int n2;
                    block33: {
                        block27: {
                            int n3;
                            block32: {
                                block25: {
                                    block31: {
                                        block23: {
                                            block30: {
                                                block21: {
                                                    block19: {
                                                        int[] nArray2;
                                                        int n4;
                                                        block26: {
                                                            int n5;
                                                            block24: {
                                                                block22: {
                                                                    block20: {
                                                                        if ((this.style & 0x200) == 0) break block19;
                                                                        n4 = OS.GetThemeSysSize(l, 2);
                                                                        rECT.left = rectangle.x;
                                                                        rECT.right = rECT.left + rectangle.width;
                                                                        rECT.top = rectangle.y;
                                                                        rECT.bottom = rECT.top + n4;
                                                                        nArray2 = this.getPartId(1);
                                                                        OS.HitTestThemeBackground(l, n, nArray2[0], nArray2[1], 0, rECT, 0L, pOINT, sArray);
                                                                        if (sArray[0] == 0) break block20;
                                                                        break block21;
                                                                    }
                                                                    rECT.bottom = rectangle.y + rectangle.height;
                                                                    rECT.top = rECT.bottom - n4;
                                                                    nArray2 = this.getPartId(2);
                                                                    OS.HitTestThemeBackground(l, n, nArray2[0], nArray2[1], 0, rECT, 0L, pOINT, sArray);
                                                                    if (sArray[0] == 0) break block22;
                                                                    break block23;
                                                                }
                                                                int n6 = rectangle.height - 2 * n4;
                                                                n5 = Math.max(n4 / 2, n6 * this.thumb / Math.max(1, this.maximum - this.minimum));
                                                                int n7 = rectangle.y + n4 + Math.max(0, n6 * this.selection / Math.max(1, this.maximum - this.minimum));
                                                                rECT.top = rectangle.y + n4;
                                                                rECT.bottom = n7;
                                                                nArray2 = this.getPartId(5);
                                                                OS.HitTestThemeBackground(l, n, nArray2[0], nArray2[1], 0, rECT, 0L, pOINT, sArray);
                                                                if (sArray[0] == 0) break block24;
                                                                break block25;
                                                            }
                                                            rECT.top = rECT.bottom;
                                                            rECT.bottom = rECT.top + n5;
                                                            nArray2 = this.getPartId(3);
                                                            OS.HitTestThemeBackground(l, n, nArray2[0], nArray2[1], 0, rECT, 0L, pOINT, sArray);
                                                            if (sArray[0] == 0) break block26;
                                                            break block27;
                                                        }
                                                        rECT.top = rECT.bottom;
                                                        rECT.bottom = rectangle.y + rectangle.height - n4;
                                                        nArray2 = this.getPartId(4);
                                                        OS.HitTestThemeBackground(l, n, nArray2[0], nArray2[1], 0, rECT, 0L, pOINT, sArray);
                                                        if (sArray[0] == 0) break block28;
                                                        break block29;
                                                    }
                                                    n2 = OS.GetThemeSysSize(l, 2);
                                                    rECT.top = rectangle.y;
                                                    rECT.bottom = rECT.top + rectangle.height;
                                                    rECT.left = rectangle.x;
                                                    rECT.right = rECT.left + n2;
                                                    nArray = this.getPartId(1);
                                                    OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                                    if (sArray[0] == 0) break block30;
                                                }
                                                Object var15_13 = null;
                                                OS.CloseThemeData(l);
                                                return 1;
                                            }
                                            rECT.right = rectangle.x + rectangle.width;
                                            rECT.left = rECT.right - n2;
                                            nArray = this.getPartId(2);
                                            OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                            if (sArray[0] == 0) break block31;
                                        }
                                        Object var15_14 = null;
                                        OS.CloseThemeData(l);
                                        return 2;
                                    }
                                    int n8 = rectangle.width - 2 * n2;
                                    n3 = Math.max(n2 / 2, n8 * this.thumb / (this.maximum - this.minimum));
                                    int n9 = rectangle.x + n2 + Math.max(0, n8 * this.selection / Math.max(1, this.maximum - this.minimum));
                                    rECT.left = rectangle.x + n2;
                                    rECT.right = n9;
                                    nArray = this.getPartId(3);
                                    OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                                    if (sArray[0] == 0) break block32;
                                }
                                Object var15_15 = null;
                                OS.CloseThemeData(l);
                                return 3;
                            }
                            rECT.left = rECT.right;
                            rECT.right = rECT.left + n3;
                            nArray = this.getPartId(5);
                            OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                            if (sArray[0] == 0) break block33;
                        }
                        Object var15_16 = null;
                        OS.CloseThemeData(l);
                        return 5;
                    }
                    rECT.left = rECT.right;
                    rECT.right = rectangle.x + rectangle.width - n2;
                    nArray = this.getPartId(4);
                    OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                    if (sArray[0] == 0) break block28;
                }
                Object var15_17 = null;
                OS.CloseThemeData(l);
                return 4;
            }
            Object var15_19 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            OS.CloseThemeData(l);
            throw throwable;
        }
        OS.CloseThemeData(l);
        return -1;
    }
}

