/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.ScrollBar;

class StyledTextRenderer {
    Device device;
    StyledText styledText;
    StyledTextContent content;
    Font regularFont;
    Font boldFont;
    Font italicFont;
    Font boldItalicFont;
    int tabWidth;
    int ascent;
    int descent;
    int averageCharWidth;
    int topIndex = -1;
    TextLayout[] layouts;
    int lineCount;
    int[] lineWidth;
    int[] lineHeight;
    LineInfo[] lines;
    int maxWidth;
    int maxWidthLineIndex;
    boolean idleRunning;
    Bullet[] bullets;
    int[] bulletsIndices;
    int[] redrawLines;
    int[] ranges;
    int styleCount;
    StyleRange[] styles;
    StyleRange[] stylesSet;
    int stylesSetCount = 0;
    boolean hasLinks;
    boolean fixedPitch;
    static final int BULLET_MARGIN = 8;
    static final boolean COMPACT_STYLES = true;
    static final boolean MERGE_STYLES = true;
    static final int GROW = 32;
    static final int IDLE_TIME = 50;
    static final int CACHE_SIZE = 128;
    static final int BACKGROUND = 1;
    static final int ALIGNMENT = 2;
    static final int INDENT = 4;
    static final int JUSTIFY = 8;
    static final int SEGMENTS = 32;

    StyledTextRenderer(Device device, StyledText styledText) {
        this.device = device;
        this.styledText = styledText;
    }

    int addMerge(int[] nArray, StyleRange[] styleRangeArray, int n, int n2, int n3) {
        int n4;
        int n5 = this.styleCount << 1;
        StyleRange styleRange = null;
        int n6 = 0;
        int n7 = 0;
        if (n3 < n5) {
            styleRange = this.styles[n3 >> 1];
            n6 = this.ranges[n3];
            n7 = this.ranges[n3 + 1];
        }
        if (n5 + (n4 = n - (n3 - n2)) >= this.ranges.length) {
            int[] nArray2 = new int[this.ranges.length + n4 + 64];
            System.arraycopy(this.ranges, 0, nArray2, 0, n2);
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + (n4 >> 1) + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n2 >> 1);
            if (n5 > n3) {
                System.arraycopy(this.ranges, n3, nArray2, n2 + n, n5 - n3);
                System.arraycopy(this.styles, n3 >> 1, styleRangeArray2, n2 + n >> 1, this.styleCount - (n3 >> 1));
            }
            this.ranges = nArray2;
            this.styles = styleRangeArray2;
        } else if (n5 > n3) {
            System.arraycopy(this.ranges, n3, this.ranges, n2 + n, n5 - n3);
            System.arraycopy(this.styles, n3 >> 1, this.styles, n2 + n >> 1, this.styleCount - (n3 >> 1));
        }
        int n8 = n2;
        int n9 = 0;
        while (n9 < n) {
            if (n8 > 0 && this.ranges[n8 - 2] + this.ranges[n8 - 1] == nArray[n9] && styleRangeArray[n9 >> 1].similarTo(this.styles[n8 - 2 >> 1])) {
                int n10 = n8 - 1;
                this.ranges[n10] = this.ranges[n10] + nArray[n9 + 1];
            } else {
                this.styles[n8 >> 1] = styleRangeArray[n9 >> 1];
                this.ranges[n8++] = nArray[n9];
                this.ranges[n8++] = nArray[n9 + 1];
            }
            n9 += 2;
        }
        if (styleRange != null && this.ranges[n8 - 2] + this.ranges[n8 - 1] == n6 && styleRange.similarTo(this.styles[n8 - 2 >> 1])) {
            int n11 = n8 - 1;
            this.ranges[n11] = this.ranges[n11] + n7;
            n3 += 2;
            n += 2;
        }
        if (n5 > n3) {
            System.arraycopy(this.ranges, n2 + n, this.ranges, n8, n5 - n3);
            System.arraycopy(this.styles, n2 + n >> 1, this.styles, n8 >> 1, this.styleCount - (n3 >> 1));
        }
        n4 = n8 - n2 - (n3 - n2);
        this.styleCount += n4 >> 1;
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    int addMerge(StyleRange[] var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = var2_2 - (var4_4 - var3_3);
        var6_6 = null;
        if (var4_4 < this.styleCount) {
            var6_6 = this.styles[var4_4];
        }
        if (this.styleCount + var5_5 >= this.styles.length) {
            var7_7 = new StyleRange[this.styles.length + var5_5 + 32];
            System.arraycopy(this.styles, 0, var7_7, 0, var3_3);
            if (this.styleCount > var4_4) {
                System.arraycopy(this.styles, var4_4, var7_7, var3_3 + var2_2, this.styleCount - var4_4);
            }
            this.styles = var7_7;
        } else if (this.styleCount > var4_4) {
            System.arraycopy(this.styles, var4_4, this.styles, var3_3 + var2_2, this.styleCount - var4_4);
        }
        var7_8 = var3_3;
        var8_9 = 0;
        while (var8_9 < var2_2) {
            var9_11 = var1_1[var8_9];
            if (var7_8 <= 0) ** GOTO lbl-1000
            var10_12 = this.styles[var7_8 - 1];
            if (var10_12.start + var10_12.length == var9_11.start && var9_11.similarTo(var10_12)) {
                var10_12.length += var9_11.length;
            } else lbl-1000:
            // 2 sources

            {
                this.styles[var7_8++] = var9_11;
            }
            ++var8_9;
        }
        var8_10 = this.styles[var7_8 - 1];
        if (var6_6 != null && var8_10.start + var8_10.length == var6_6.start && var6_6.similarTo(var8_10)) {
            var8_10.length += var6_6.length;
            ++var4_4;
            ++var2_2;
        }
        if (this.styleCount > var4_4) {
            System.arraycopy(this.styles, var3_3 + var2_2, this.styles, var7_8, this.styleCount - var4_4);
        }
        var5_5 = var7_8 - var3_3 - (var4_4 - var3_3);
        this.styleCount += var5_5;
        return var5_5;
    }

    void calculate(int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n3 > this.lineWidth.length) {
            return;
        }
        int n4 = this.styledText.leftMargin + this.styledText.rightMargin + this.styledText.getCaretWidth();
        int n5 = n;
        while (n5 < n3) {
            if (this.lineWidth[n5] == -1 || this.lineHeight[n5] == -1) {
                TextLayout textLayout = this.getTextLayout(n5);
                Rectangle rectangle = textLayout.getBounds();
                this.lineWidth[n5] = rectangle.width + n4;
                this.lineHeight[n5] = rectangle.height;
                this.disposeTextLayout(textLayout);
            }
            if (this.lineWidth[n5] > this.maxWidth) {
                this.maxWidth = this.lineWidth[n5];
                this.maxWidthLineIndex = n5;
            }
            ++n5;
        }
    }

    void calculateClientArea() {
        int n = this.styledText.getTopIndex();
        int n2 = this.content.getLineCount();
        int n3 = this.styledText.getClientArea().height;
        int n4 = 0;
        while (n3 > n4 && n2 > n) {
            this.calculate(n, 1);
            n4 += this.lineHeight[n++];
        }
    }

    void calculateIdle() {
        if (this.idleRunning) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (StyledTextRenderer.this.styledText == null) {
                    return;
                }
                long l = System.currentTimeMillis();
                int n = 0;
                while (n < StyledTextRenderer.this.lineCount) {
                    if (StyledTextRenderer.this.lineHeight[n] == -1 || StyledTextRenderer.this.lineWidth[n] == -1) {
                        StyledTextRenderer.this.calculate(n, 1);
                        if (System.currentTimeMillis() - l > 50L) break;
                    }
                    ++n;
                }
                if (n < StyledTextRenderer.this.lineCount) {
                    Display display = StyledTextRenderer.this.styledText.getDisplay();
                    display.asyncExec(this);
                } else {
                    StyledTextRenderer.this.idleRunning = false;
                    StyledTextRenderer.this.styledText.setScrollBars(true);
                    ScrollBar scrollBar = StyledTextRenderer.this.styledText.getVerticalBar();
                    if (scrollBar != null) {
                        scrollBar.setSelection(StyledTextRenderer.this.styledText.getVerticalScrollOffset());
                    }
                }
            }
        };
        Display display = this.styledText.getDisplay();
        display.asyncExec(runnable);
        this.idleRunning = true;
    }

    void clearLineBackground(int n, int n2) {
        if (this.lines == null) {
            return;
        }
        int n3 = n;
        while (n3 < n + n2) {
            LineInfo lineInfo = this.lines[n3];
            if (lineInfo != null) {
                lineInfo.flags &= 0xFFFFFFFE;
                lineInfo.background = null;
                if (lineInfo.flags == 0) {
                    this.lines[n3] = null;
                }
            }
            ++n3;
        }
    }

    void clearLineStyle(int n, int n2) {
        if (this.lines == null) {
            return;
        }
        int n3 = n;
        while (n3 < n + n2) {
            LineInfo lineInfo = this.lines[n3];
            if (lineInfo != null) {
                lineInfo.flags &= 0xFFFFFFF1;
                if (lineInfo.flags == 0) {
                    this.lines[n3] = null;
                }
            }
            ++n3;
        }
    }

    void copyInto(StyledTextRenderer styledTextRenderer) {
        int n;
        Object[] objectArray;
        if (this.ranges != null) {
            styledTextRenderer.ranges = new int[this.styleCount << 1];
            objectArray = styledTextRenderer.ranges;
            System.arraycopy(this.ranges, 0, objectArray, 0, objectArray.length);
        }
        if (this.styles != null) {
            styledTextRenderer.styles = new StyleRange[this.styleCount];
            objectArray = styledTextRenderer.styles;
            n = 0;
            while (n < objectArray.length) {
                objectArray[n] = (int)((StyleRange)this.styles[n].clone());
                ++n;
            }
            styledTextRenderer.styleCount = this.styleCount;
        }
        if (this.lines != null) {
            styledTextRenderer.lines = new LineInfo[this.lineCount];
            objectArray = styledTextRenderer.lines;
            n = 0;
            while (n < objectArray.length) {
                objectArray[n] = (int)new LineInfo(this.lines[n]);
                ++n;
            }
            styledTextRenderer.lineCount = this.lineCount;
        }
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
        this.reset();
        this.content = null;
        this.device = null;
        this.styledText = null;
    }

    void disposeTextLayout(TextLayout textLayout) {
        if (this.layouts != null) {
            int n = 0;
            while (n < this.layouts.length) {
                if (this.layouts[n] == textLayout) {
                    return;
                }
                ++n;
            }
        }
        textLayout.dispose();
    }

    void drawBullet(Bullet bullet, GC gC, int n, int n2, int n3, int n4, int n5) {
        StyleRange styleRange = bullet.style;
        GlyphMetrics glyphMetrics = styleRange.metrics;
        Color color = styleRange.foreground;
        if (color != null) {
            gC.setForeground(color);
        }
        if ((bullet.type & 1) != 0 && StyledText.IS_MOTIF) {
            int n6 = Math.max(4, (n4 + n5) / 4);
            if ((n6 & 1) == 0) {
                ++n6;
            }
            if (color == null) {
                Display display = this.styledText.getDisplay();
                color = display.getSystemColor(2);
            }
            gC.setBackground(color);
            int n7 = n + Math.max(0, glyphMetrics.width - n6 - 8);
            gC.fillArc(n7, n2 + n6, n6 + 1, n6 + 1, 0, 360);
            return;
        }
        Font font = styleRange.font;
        if (font != null) {
            gC.setFont(font);
        }
        String string = "";
        int n8 = bullet.type & 0xF;
        switch (n8) {
            case 1: {
                string = "\u2022";
                break;
            }
            case 2: {
                string = String.valueOf(n3);
                break;
            }
            case 4: {
                string = String.valueOf((char)(n3 % 26 + 97));
                break;
            }
            case 8: {
                string = String.valueOf((char)(n3 % 26 + 65));
            }
        }
        if ((bullet.type & 0x10) != 0) {
            string = String.valueOf(string) + bullet.text;
        }
        Display display = this.styledText.getDisplay();
        TextLayout textLayout = new TextLayout(display);
        textLayout.setText(string);
        textLayout.setAscent(n4);
        textLayout.setDescent(n5);
        styleRange = (StyleRange)styleRange.clone();
        styleRange.metrics = null;
        if (styleRange.font == null) {
            styleRange.font = this.getFont(styleRange.fontStyle);
        }
        textLayout.setStyle(styleRange, 0, string.length());
        int n9 = n + Math.max(0, glyphMetrics.width - textLayout.getBounds().width - 8);
        textLayout.draw(gC, n9, n2);
        textLayout.dispose();
    }

    int drawLine(int n, int n2, int n3, GC gC, Color color, Color color2) {
        int n4;
        Object object;
        Object object2;
        int n5;
        TextLayout textLayout = this.getTextLayout(n);
        String string = this.content.getLine(n);
        int n6 = this.content.getOffsetAtLine(n);
        int n7 = string.length();
        Point point = this.styledText.getSelection();
        int n8 = point.x - n6;
        int n9 = point.y - n6;
        if (this.styledText.getBlockSelection()) {
            n9 = 0;
            n8 = 0;
        }
        Rectangle rectangle = this.styledText.getClientArea();
        Color color3 = this.getLineBackground(n, null);
        StyledTextEvent styledTextEvent = this.styledText.getLineBackgroundData(n6, string);
        if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
            color3 = styledTextEvent.lineBackground;
        }
        int n10 = textLayout.getBounds().height;
        if (color3 != null) {
            gC.setBackground(color3);
            gC.fillRectangle(rectangle.x, n3, rectangle.width, n10);
        } else {
            gC.setBackground(color);
            this.styledText.drawBackground(gC, rectangle.x, n3, rectangle.width, n10);
        }
        gC.setForeground(color2);
        if (n8 == n9 || n9 <= 0 && n8 > n7 - 1) {
            textLayout.draw(gC, n2, n3);
        } else {
            int n11 = Math.max(0, n8);
            n5 = Math.min(n7, n9);
            object2 = this.styledText.getSelectionForeground();
            object = this.styledText.getSelectionBackground();
            n4 = (this.styledText.getStyle() & 0x10000) != 0 ? 65536 : 131072;
            if (n8 <= n7 && n7 < n9) {
                n4 |= 0x100000;
            }
            textLayout.draw(gC, n2, n3, n11, n5 - 1, (Color)object2, (Color)object, n4);
        }
        Bullet bullet = null;
        n5 = -1;
        if (this.bullets != null) {
            if (this.bulletsIndices != null) {
                int n12 = n - this.topIndex;
                if (n12 >= 0 && n12 < 128) {
                    bullet = this.bullets[n12];
                    n5 = this.bulletsIndices[n12];
                }
            } else {
                int n13 = 0;
                while (n13 < this.bullets.length) {
                    bullet = this.bullets[n13];
                    n5 = bullet.indexOf(n);
                    if (n5 != -1) break;
                    ++n13;
                }
            }
        }
        if (n5 != -1 && bullet != null) {
            object2 = textLayout.getLineMetrics(0);
            int n14 = ((FontMetrics)object2).getAscent() + ((FontMetrics)object2).getLeading();
            if (bullet.type == 32) {
                bullet.style.start = n6;
                this.styledText.paintObject(gC, n2, n3, n14, ((FontMetrics)object2).getDescent(), bullet.style, bullet, n5);
            } else {
                this.drawBullet(bullet, gC, n2, n3, n5, n14, ((FontMetrics)object2).getDescent());
            }
        }
        object2 = textLayout.getStyles();
        object = null;
        n4 = 0;
        while (n4 < ((Object)object2).length) {
            if (((TextStyle)object2[n4]).metrics != null) {
                if (object == null) {
                    object = textLayout.getRanges();
                }
                Object object3 = object[n4 << 1];
                reference var24_28 = object[(n4 << 1) + 1] - object3;
                Point point2 = textLayout.getLocation((int)object3, false);
                FontMetrics fontMetrics = textLayout.getLineMetrics(textLayout.getLineIndex((int)object3));
                StyleRange styleRange = (StyleRange)((StyleRange)object2[n4]).clone();
                styleRange.start = (int)(object3 + n6);
                styleRange.length = (int)var24_28;
                int n15 = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.styledText.paintObject(gC, point2.x + n2, point2.y + n3, n15, fontMetrics.getDescent(), styleRange, null, 0);
            }
            ++n4;
        }
        this.disposeTextLayout(textLayout);
        return n10;
    }

    int getBaseline() {
        return this.ascent;
    }

    Font getFont(int n) {
        switch (n) {
            case 1: {
                if (this.boldFont != null) {
                    return this.boldFont;
                }
                this.boldFont = new Font(this.device, this.getFontData(n));
                return this.boldFont;
            }
            case 2: {
                if (this.italicFont != null) {
                    return this.italicFont;
                }
                this.italicFont = new Font(this.device, this.getFontData(n));
                return this.italicFont;
            }
            case 3: {
                if (this.boldItalicFont != null) {
                    return this.boldItalicFont;
                }
                this.boldItalicFont = new Font(this.device, this.getFontData(n));
                return this.boldItalicFont;
            }
        }
        return this.regularFont;
    }

    FontData[] getFontData(int n) {
        FontData[] fontDataArray = this.regularFont.getFontData();
        int n2 = 0;
        while (n2 < fontDataArray.length) {
            fontDataArray[n2].setStyle(n);
            ++n2;
        }
        return fontDataArray;
    }

    int getHeight() {
        int n = this.getLineHeight();
        if (this.styledText.isFixedLineHeight()) {
            return this.lineCount * n + this.styledText.topMargin + this.styledText.bottomMargin;
        }
        int n2 = 0;
        int n3 = this.styledText.getWrapWidth();
        int n4 = 0;
        while (n4 < this.lineCount) {
            int n5 = this.lineHeight[n4];
            if (n5 == -1) {
                if (n3 > 0) {
                    int n6 = this.content.getLine(n4).length();
                    n5 = (n6 * this.averageCharWidth / n3 + 1) * n;
                } else {
                    n5 = n;
                }
            }
            n2 += n5;
            ++n4;
        }
        return n2 + this.styledText.topMargin + this.styledText.bottomMargin;
    }

    boolean hasLink(int n) {
        String string;
        if (n == -1) {
            return false;
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        StyledTextEvent styledTextEvent = this.styledText.getLineStyleData(n3, string = this.content.getLine(n2));
        if (styledTextEvent != null) {
            StyleRange[] styleRangeArray = styledTextEvent.styles;
            if (styleRangeArray != null) {
                int[] nArray = styledTextEvent.ranges;
                if (nArray != null) {
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        if (nArray[n4] <= n && n < nArray[n4] + nArray[n4 + 1] && styleRangeArray[n4 >> 1].underline && styleRangeArray[n4 >> 1].underlineStyle == 4) {
                            return true;
                        }
                        n4 += 2;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < styleRangeArray.length) {
                        if (styleRangeArray[n5].start <= n && n < styleRangeArray[n5].start + styleRangeArray[n5].length && styleRangeArray[n5 >> 1].underline && styleRangeArray[n5 >> 1].underlineStyle == 4) {
                            return true;
                        }
                        ++n5;
                    }
                }
            }
        } else if (this.ranges != null) {
            int n6 = this.styleCount << 1;
            int n7 = this.getRangeIndex(n, -1, n6);
            if (n7 >= n6) {
                return false;
            }
            int n8 = this.ranges[n7];
            int n9 = this.ranges[n7 + 1];
            StyleRange styleRange = this.styles[n7 >> 1];
            if (n8 <= n && n < n8 + n9 && styleRange.underline && styleRange.underlineStyle == 4) {
                return true;
            }
        }
        return false;
    }

    int getLineAlignment(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 2) != 0) {
            return lineInfo.alignment;
        }
        return n2;
    }

    Color getLineBackground(int n, Color color) {
        if (this.lines == null) {
            return color;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 1) != 0) {
            return lineInfo.background;
        }
        return color;
    }

    Bullet getLineBullet(int n, Bullet bullet) {
        if (this.bullets == null) {
            return bullet;
        }
        if (this.bulletsIndices != null) {
            return bullet;
        }
        int n2 = 0;
        while (n2 < this.bullets.length) {
            Bullet bullet2 = this.bullets[n2];
            if (bullet2.indexOf(n) != -1) {
                return bullet2;
            }
            ++n2;
        }
        return bullet;
    }

    int getLineHeight() {
        return this.ascent + this.descent;
    }

    int getLineHeight(int n) {
        if (this.lineHeight[n] == -1) {
            this.calculate(n, 1);
        }
        return this.lineHeight[n];
    }

    int getLineIndent(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 4) != 0) {
            return lineInfo.indent;
        }
        return n2;
    }

    boolean getLineJustify(int n, boolean bl) {
        if (this.lines == null) {
            return bl;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 8) != 0) {
            return lineInfo.justify;
        }
        return bl;
    }

    int[] getLineSegments(int n, int[] nArray) {
        if (this.lines == null) {
            return nArray;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 0x20) != 0) {
            return lineInfo.segments;
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    int getRangeIndex(int var1_1, int var2_2, int var3_3) {
        block5: {
            if (this.styleCount == 0) {
                return 0;
            }
            if (this.ranges == null) ** GOTO lbl19
            while (var3_3 - var2_2 > 2) {
                var4_4 = (var3_3 + var2_2) / 2 / 2 * 2;
                var5_6 = this.ranges[var4_4] + this.ranges[var4_4 + 1];
                if (var5_6 > var1_1) {
                    var3_3 = var4_4;
                    continue;
                }
                var2_2 = var4_4;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                var4_5 = (var3_3 + var2_2) / 2;
                var5_7 = this.styles[var4_5].start + this.styles[var4_5].length;
                if (var5_7 > var1_1) {
                    var3_3 = var4_5;
                    continue;
                }
                var2_2 = var4_5;
lbl19:
                // 3 sources

                ** while (var3_3 - var2_2 > 1)
            }
        }
        return var3_3;
    }

    int[] getRanges(int n, int n2) {
        int[] nArray;
        if (n2 == 0) {
            return null;
        }
        int n3 = n + n2 - 1;
        if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 >= n4) {
                return null;
            }
            if (this.ranges[n5] > n3) {
                return null;
            }
            int n6 = Math.min(n4 - 2, this.getRangeIndex(n3, n5 - 1, n4));
            if (this.ranges[n6] > n3) {
                n6 = Math.max(n5, n6 - 2);
            }
            nArray = new int[n6 - n5 + 2];
            System.arraycopy(this.ranges, n5, nArray, 0, nArray.length);
        } else {
            int n7 = this.getRangeIndex(n, -1, this.styleCount);
            if (n7 >= this.styleCount) {
                return null;
            }
            if (this.styles[n7].start > n3) {
                return null;
            }
            int n8 = Math.min(this.styleCount - 1, this.getRangeIndex(n3, n7 - 1, this.styleCount));
            if (this.styles[n8].start > n3) {
                n8 = Math.max(n7, n8 - 1);
            }
            nArray = new int[n8 - n7 + 1 << 1];
            int n9 = n7;
            int n10 = 0;
            while (n9 <= n8) {
                StyleRange styleRange = this.styles[n9];
                nArray[n10] = styleRange.start;
                nArray[n10 + 1] = styleRange.length;
                ++n9;
                n10 += 2;
            }
        }
        if (n > nArray[0]) {
            nArray[1] = nArray[0] + nArray[1] - n;
            nArray[0] = n;
        }
        if (n3 < nArray[nArray.length - 2] + nArray[nArray.length - 1] - 1) {
            nArray[nArray.length - 1] = n3 - nArray[nArray.length - 2] + 1;
        }
        return nArray;
    }

    StyleRange[] getStyleRanges(int n, int n2, boolean bl) {
        StyleRange[] styleRangeArray;
        int n3;
        if (n2 == 0) {
            return null;
        }
        int n4 = n + n2 - 1;
        if (this.ranges != null) {
            n3 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n3);
            if (n5 >= n3) {
                return null;
            }
            if (this.ranges[n5] > n4) {
                return null;
            }
            int n6 = Math.min(n3 - 2, this.getRangeIndex(n4, n5 - 1, n3));
            if (this.ranges[n6] > n4) {
                n6 = Math.max(n5, n6 - 2);
            }
            styleRangeArray = new StyleRange[(n6 - n5 >> 1) + 1];
            if (bl) {
                int n7 = n5;
                int n8 = 0;
                while (n7 <= n6) {
                    styleRangeArray[n8] = (StyleRange)this.styles[n7 >> 1].clone();
                    styleRangeArray[n8].start = this.ranges[n7];
                    styleRangeArray[n8].length = this.ranges[n7 + 1];
                    n7 += 2;
                    ++n8;
                }
            } else {
                System.arraycopy(this.styles, n5 >> 1, styleRangeArray, 0, styleRangeArray.length);
            }
        } else {
            n3 = this.getRangeIndex(n, -1, this.styleCount);
            if (n3 >= this.styleCount) {
                return null;
            }
            if (this.styles[n3].start > n4) {
                return null;
            }
            int n9 = Math.min(this.styleCount - 1, this.getRangeIndex(n4, n3 - 1, this.styleCount));
            if (this.styles[n9].start > n4) {
                n9 = Math.max(n3, n9 - 1);
            }
            styleRangeArray = new StyleRange[n9 - n3 + 1];
            System.arraycopy(this.styles, n3, styleRangeArray, 0, styleRangeArray.length);
        }
        if (bl || this.ranges == null) {
            StyleRange styleRange = styleRangeArray[0];
            if (n > styleRange.start) {
                styleRangeArray[0] = styleRange = (StyleRange)styleRange.clone();
                styleRange.length = styleRange.start + styleRange.length - n;
                styleRange.start = n;
            }
            styleRange = styleRangeArray[styleRangeArray.length - 1];
            if (n4 < styleRange.start + styleRange.length - 1) {
                styleRangeArray[styleRangeArray.length - 1] = styleRange = (StyleRange)styleRange.clone();
                styleRange.length = n4 - styleRange.start + 1;
            }
        }
        return styleRangeArray;
    }

    StyleRange getStyleRange(StyleRange styleRange) {
        if (styleRange.underline && styleRange.underlineStyle == 4) {
            this.hasLinks = true;
        }
        if (styleRange.start == 0 && styleRange.length == 0 && styleRange.fontStyle == 0) {
            return styleRange;
        }
        StyleRange styleRange2 = (StyleRange)styleRange.clone();
        styleRange2.length = 0;
        styleRange2.start = 0;
        styleRange2.fontStyle = 0;
        if (styleRange2.font == null) {
            styleRange2.font = this.getFont(styleRange.fontStyle);
        }
        return styleRange2;
    }

    TextLayout getTextLayout(int n) {
        return this.getTextLayout(n, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
    }

    TextLayout getTextLayout(int n, int n2, int n3, int n4) {
        int n5;
        IME iME;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        TextLayout textLayout = null;
        if (this.styledText != null) {
            int n11;
            int n12;
            int n13 = n12 = this.styledText.topIndex > 0 ? this.styledText.topIndex - 1 : 0;
            if (this.layouts == null || n12 != this.topIndex) {
                int n14;
                TextLayout[] textLayoutArray = new TextLayout[128];
                if (this.layouts != null) {
                    n14 = 0;
                    while (n14 < this.layouts.length) {
                        if (this.layouts[n14] != null) {
                            n10 = n14 + this.topIndex - n12;
                            if (n10 >= 0 && n10 < textLayoutArray.length) {
                                textLayoutArray[n10] = this.layouts[n14];
                            } else {
                                this.layouts[n14].dispose();
                            }
                        }
                        ++n14;
                    }
                }
                if (this.bullets != null && this.bulletsIndices != null && n12 != this.topIndex) {
                    n14 = n12 - this.topIndex;
                    if (n14 > 0) {
                        if (n14 < this.bullets.length) {
                            System.arraycopy(this.bullets, n14, this.bullets, 0, this.bullets.length - n14);
                            System.arraycopy(this.bulletsIndices, n14, this.bulletsIndices, 0, this.bulletsIndices.length - n14);
                        }
                        n9 = n10 = Math.max(0, this.bullets.length - n14);
                        while (n9 < this.bullets.length) {
                            this.bullets[n9] = null;
                            ++n9;
                        }
                    } else {
                        if (-n14 < this.bullets.length) {
                            System.arraycopy(this.bullets, 0, this.bullets, -n14, this.bullets.length + n14);
                            System.arraycopy(this.bulletsIndices, 0, this.bulletsIndices, -n14, this.bulletsIndices.length + n14);
                        }
                        n10 = Math.min(this.bullets.length, -n14);
                        n9 = 0;
                        while (n9 < n10) {
                            this.bullets[n9] = null;
                            ++n9;
                        }
                    }
                }
                this.topIndex = n12;
                this.layouts = textLayoutArray;
            }
            if (this.layouts != null && (n11 = n - n12) >= 0 && n11 < this.layouts.length) {
                textLayout = this.layouts[n11];
                if (textLayout != null) {
                    if (this.lineWidth[n] != -1) {
                        return textLayout;
                    }
                } else {
                    textLayout = this.layouts[n11] = new TextLayout(this.device);
                }
            }
        }
        if (textLayout == null) {
            textLayout = new TextLayout(this.device);
        }
        String string = this.content.getLine(n);
        int n15 = this.content.getOffsetAtLine(n);
        int[] nArray = null;
        n10 = 0;
        n9 = 16384;
        boolean bl = false;
        Bullet bullet = null;
        int[] nArray2 = null;
        StyleRange[] styleRangeArray = null;
        int n16 = 0;
        int n17 = 0;
        StyledTextEvent styledTextEvent = null;
        if (this.styledText != null) {
            styledTextEvent = this.styledText.getLineStyleData(n15, string);
            nArray = this.styledText.getBidiSegments(n15, string);
            n10 = this.styledText.indent;
            n9 = this.styledText.alignment;
            bl = this.styledText.justify;
        }
        if (styledTextEvent != null) {
            int n18;
            n10 = styledTextEvent.indent;
            n9 = styledTextEvent.alignment;
            bl = styledTextEvent.justify;
            bullet = styledTextEvent.bullet;
            nArray2 = styledTextEvent.ranges;
            styleRangeArray = styledTextEvent.styles;
            if (styleRangeArray != null) {
                n17 = styleRangeArray.length;
                if (this.styledText.isFixedLineHeight()) {
                    n18 = 0;
                    while (n18 < n17) {
                        if (styleRangeArray[n18].isVariableHeight()) {
                            this.styledText.verticalScrollOffset = -1;
                            this.styledText.setVariableLineHeight();
                            this.styledText.redraw();
                            break;
                        }
                        ++n18;
                    }
                }
            }
            if (this.bullets == null || this.bulletsIndices == null) {
                this.bullets = new Bullet[128];
                this.bulletsIndices = new int[128];
            }
            if ((n18 = n - this.topIndex) >= 0 && n18 < 128) {
                this.bullets[n18] = bullet;
                this.bulletsIndices[n18] = styledTextEvent.bulletIndex;
            }
        } else {
            LineInfo lineInfo;
            if (this.lines != null && (lineInfo = this.lines[n]) != null) {
                if ((lineInfo.flags & 4) != 0) {
                    n10 = lineInfo.indent;
                }
                if ((lineInfo.flags & 2) != 0) {
                    n9 = lineInfo.alignment;
                }
                if ((lineInfo.flags & 8) != 0) {
                    bl = lineInfo.justify;
                }
                if ((lineInfo.flags & 0x20) != 0) {
                    nArray = lineInfo.segments;
                }
            }
            if (this.bulletsIndices != null) {
                this.bullets = null;
                this.bulletsIndices = null;
            }
            if (this.bullets != null) {
                int n19 = 0;
                while (n19 < this.bullets.length) {
                    if (this.bullets[n19].indexOf(n) != -1) {
                        bullet = this.bullets[n19];
                        break;
                    }
                    ++n19;
                }
            }
            nArray2 = this.ranges;
            styleRangeArray = this.styles;
            n17 = this.styleCount;
            n16 = nArray2 != null ? this.getRangeIndex(n15, -1, n17 << 1) : this.getRangeIndex(n15, -1, n17);
        }
        if (bullet != null) {
            StyleRange styleRange = bullet.style;
            GlyphMetrics glyphMetrics = styleRange.metrics;
            n10 += glyphMetrics.width;
        }
        textLayout.setFont(this.regularFont);
        textLayout.setAscent(this.ascent);
        textLayout.setDescent(this.descent);
        textLayout.setText(string);
        textLayout.setOrientation(n2);
        textLayout.setSegments(nArray);
        textLayout.setWidth(n3);
        textLayout.setSpacing(n4);
        textLayout.setTabs(new int[]{this.tabWidth});
        textLayout.setIndent(n10);
        textLayout.setAlignment(n9);
        textLayout.setJustify(bl);
        int n20 = 0;
        int n21 = string.length();
        if (styleRangeArray != null) {
            int n22;
            if (nArray2 != null) {
                n22 = n17 << 1;
                n8 = n16;
                while (n8 < n22) {
                    if (n15 > nArray2[n8]) {
                        n7 = 0;
                        n6 = Math.min(n21, nArray2[n8 + 1] - n15 + nArray2[n8]);
                    } else {
                        n7 = nArray2[n8] - n15;
                        n6 = Math.min(n21, n7 + nArray2[n8 + 1]);
                    }
                    if (n7 < n21) {
                        if (n20 < n7) {
                            textLayout.setStyle(null, n20, n7 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n8 >> 1]), n7, n6);
                        n20 = Math.max(n20, n6);
                        n8 += 2;
                        continue;
                    }
                    break;
                }
            } else {
                n22 = n16;
                while (n22 < n17) {
                    if (n15 > styleRangeArray[n22].start) {
                        n8 = 0;
                        n7 = Math.min(n21, styleRangeArray[n22].length - n15 + styleRangeArray[n22].start);
                    } else {
                        n8 = styleRangeArray[n22].start - n15;
                        n7 = Math.min(n21, n8 + styleRangeArray[n22].length);
                    }
                    if (n8 < n21) {
                        if (n20 < n8) {
                            textLayout.setStyle(null, n20, n8 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n22]), n8, n7);
                        n20 = Math.max(n20, n7);
                        ++n22;
                        continue;
                    }
                    break;
                }
            }
        }
        if (n20 < n21) {
            textLayout.setStyle(null, n20, n21);
        }
        if (this.styledText != null && this.styledText.ime != null && (n8 = (iME = this.styledText.ime).getCompositionOffset()) != -1) {
            n7 = iME.getCommitCount();
            n6 = iME.getText().length();
            if (n6 != n7 && (n5 = this.content.getLineAtOffset(n8)) == n) {
                TextStyle textStyle;
                int n23;
                int n24;
                int[] nArray3 = iME.getRanges();
                TextStyle[] textStyleArray = iME.getStyles();
                if (nArray3.length > 0) {
                    n24 = 0;
                    while (n24 < textStyleArray.length) {
                        n23 = nArray3[n24 * 2] - n15;
                        int n25 = nArray3[n24 * 2 + 1] - n15;
                        textStyle = textStyleArray[n24];
                        int n26 = n23;
                        while (n26 <= n25) {
                            TextStyle textStyle2 = textLayout.getStyle(n26);
                            if (textStyle2 == null && n26 > 0) {
                                textStyle2 = textLayout.getStyle(n26 - 1);
                            }
                            if (textStyle2 == null && n26 + 1 < n21) {
                                textStyle2 = textLayout.getStyle(n26 + 1);
                            }
                            if (textStyle2 == null) {
                                textLayout.setStyle(textStyle, n26, n26);
                            } else {
                                TextStyle textStyle3 = new TextStyle(textStyle);
                                if (textStyle3.font == null) {
                                    textStyle3.font = textStyle2.font;
                                }
                                if (textStyle3.foreground == null) {
                                    textStyle3.foreground = textStyle2.foreground;
                                }
                                if (textStyle3.background == null) {
                                    textStyle3.background = textStyle2.background;
                                }
                                textLayout.setStyle(textStyle3, n26, n26);
                            }
                            ++n26;
                        }
                        ++n24;
                    }
                } else {
                    n24 = n8 - n15;
                    n23 = n24 + n6 - 1;
                    TextStyle textStyle4 = textLayout.getStyle(n24);
                    if (textStyle4 == null) {
                        if (n24 > 0) {
                            textStyle4 = textLayout.getStyle(n24 - 1);
                        }
                        if (textStyle4 == null && n23 + 1 < n21) {
                            textStyle4 = textLayout.getStyle(n23 + 1);
                        }
                        if (textStyle4 != null) {
                            textStyle = new TextStyle();
                            textStyle.font = textStyle4.font;
                            textStyle.foreground = textStyle4.foreground;
                            textStyle.background = textStyle4.background;
                            textLayout.setStyle(textStyle, n24, n23);
                        }
                    }
                }
            }
        }
        if (this.styledText != null && this.styledText.isFixedLineHeight()) {
            int n27 = -1;
            n8 = textLayout.getLineCount();
            n7 = this.getLineHeight();
            n6 = 0;
            while (n6 < n8) {
                n5 = textLayout.getLineBounds((int)n6).height;
                if (n5 > n7) {
                    n7 = n5;
                    n27 = n6;
                }
                ++n6;
            }
            if (n27 != -1) {
                FontMetrics fontMetrics = textLayout.getLineMetrics(n27);
                this.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.descent = fontMetrics.getDescent();
                if (this.layouts != null) {
                    n5 = 0;
                    while (n5 < this.layouts.length) {
                        if (this.layouts[n5] != null && this.layouts[n5] != textLayout) {
                            this.layouts[n5].setAscent(this.ascent);
                            this.layouts[n5].setDescent(this.descent);
                        }
                        ++n5;
                    }
                }
                if (this.styledText.verticalScrollOffset != 0) {
                    n5 = this.styledText.topIndex;
                    int n28 = this.styledText.topIndexY;
                    int n29 = this.getLineHeight();
                    this.styledText.verticalScrollOffset = n28 >= 0 ? (n5 - 1) * n29 + n29 - n28 : n5 * n29 - n28;
                }
                this.styledText.calculateScrollBars();
                if (this.styledText.isBidiCaret()) {
                    this.styledText.createCaretBitmaps();
                }
                this.styledText.caretDirection = 0;
                this.styledText.setCaretLocation();
                this.styledText.redraw();
            }
        }
        return textLayout;
    }

    int getWidth() {
        return this.maxWidth;
    }

    void reset() {
        if (this.layouts != null) {
            int n = 0;
            while (n < this.layouts.length) {
                TextLayout textLayout = this.layouts[n];
                if (textLayout != null) {
                    textLayout.dispose();
                }
                ++n;
            }
            this.layouts = null;
        }
        this.topIndex = -1;
        this.lineCount = 0;
        this.styleCount = 0;
        this.stylesSetCount = 0;
        this.ranges = null;
        this.styles = null;
        this.stylesSet = null;
        this.lines = null;
        this.lineWidth = null;
        this.lineHeight = null;
        this.bullets = null;
        this.bulletsIndices = null;
        this.redrawLines = null;
        this.hasLinks = false;
    }

    void reset(int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n3 > this.lineWidth.length) {
            return;
        }
        int n4 = n;
        while (n4 < n3) {
            this.lineWidth[n4] = -1;
            this.lineHeight[n4] = -1;
            ++n4;
        }
        if (n <= this.maxWidthLineIndex && this.maxWidthLineIndex < n3) {
            this.maxWidth = 0;
            this.maxWidthLineIndex = -1;
            if (n2 != this.lineCount) {
                n4 = 0;
                while (n4 < this.lineCount) {
                    if (this.lineWidth[n4] > this.maxWidth) {
                        this.maxWidth = this.lineWidth[n4];
                        this.maxWidthLineIndex = n4;
                    }
                    ++n4;
                }
            }
        }
    }

    void setContent(StyledTextContent styledTextContent) {
        this.reset();
        this.content = styledTextContent;
        this.lineCount = styledTextContent.getLineCount();
        this.lineWidth = new int[this.lineCount];
        this.lineHeight = new int[this.lineCount];
        this.reset(0, this.lineCount);
    }

    void setFont(Font font, int n) {
        Object object;
        TextLayout textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        if (font != null) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
            if (this.boldItalicFont != null) {
                this.boldItalicFont.dispose();
            }
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
            this.regularFont = font;
            textLayout.setText("    ");
            textLayout.setFont(font);
            textLayout.setStyle(new TextStyle(this.getFont(0), null, null), 0, 0);
            textLayout.setStyle(new TextStyle(this.getFont(1), null, null), 1, 1);
            textLayout.setStyle(new TextStyle(this.getFont(2), null, null), 2, 2);
            textLayout.setStyle(new TextStyle(this.getFont(3), null, null), 3, 3);
            object = textLayout.getLineMetrics(0);
            this.ascent = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading();
            this.descent = ((FontMetrics)object).getDescent();
            this.boldFont.dispose();
            this.italicFont.dispose();
            this.boldItalicFont.dispose();
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
        }
        textLayout.dispose();
        textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        object = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            ((StringBuffer)object).append(' ');
            ++n2;
        }
        textLayout.setText(((StringBuffer)object).toString());
        this.tabWidth = textLayout.getBounds().width;
        textLayout.dispose();
        if (this.styledText != null) {
            GC gC = new GC(this.styledText);
            this.averageCharWidth = gC.getFontMetrics().getAverageCharWidth();
            this.fixedPitch = gC.stringExtent((String)"l").x == gC.stringExtent((String)"W").x;
            gC.dispose();
        }
    }

    void setLineAlignment(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n4 = n;
        while (n4 < n + n2) {
            if (this.lines[n4] == null) {
                this.lines[n4] = new LineInfo();
            }
            this.lines[n4].flags |= 2;
            this.lines[n4].alignment = n3;
            ++n4;
        }
    }

    void setLineBackground(int n, int n2, Color color) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n3 = n;
        while (n3 < n + n2) {
            if (this.lines[n3] == null) {
                this.lines[n3] = new LineInfo();
            }
            this.lines[n3].flags |= 1;
            this.lines[n3].background = color;
            ++n3;
        }
    }

    void setLineBullet(int n, int n2, Bullet bullet) {
        if (this.bulletsIndices != null) {
            this.bulletsIndices = null;
            this.bullets = null;
        }
        if (this.bullets == null) {
            if (bullet == null) {
                return;
            }
            this.bullets = new Bullet[1];
            this.bullets[0] = bullet;
        }
        int n3 = 0;
        while (n3 < this.bullets.length) {
            if (bullet == this.bullets[n3]) break;
            ++n3;
        }
        if (bullet != null) {
            if (n3 == this.bullets.length) {
                Bullet[] bulletArray = new Bullet[this.bullets.length + 1];
                System.arraycopy(this.bullets, 0, bulletArray, 0, this.bullets.length);
                bulletArray[n3] = bullet;
                this.bullets = bulletArray;
            }
            bullet.addIndices(n, n2);
        } else {
            this.updateBullets(n, n2, 0, false);
            this.styledText.redrawLinesBullet(this.redrawLines);
            this.redrawLines = null;
        }
    }

    void setLineIndent(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n4 = n;
        while (n4 < n + n2) {
            if (this.lines[n4] == null) {
                this.lines[n4] = new LineInfo();
            }
            this.lines[n4].flags |= 4;
            this.lines[n4].indent = n3;
            ++n4;
        }
    }

    void setLineJustify(int n, int n2, boolean bl) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n3 = n;
        while (n3 < n + n2) {
            if (this.lines[n3] == null) {
                this.lines[n3] = new LineInfo();
            }
            this.lines[n3].flags |= 8;
            this.lines[n3].justify = bl;
            ++n3;
        }
    }

    void setLineSegments(int n, int n2, int[] nArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n3 = n;
        while (n3 < n + n2) {
            if (this.lines[n3] == null) {
                this.lines[n3] = new LineInfo();
            }
            this.lines[n3].flags |= 0x20;
            this.lines[n3].segments = nArray;
            ++n3;
        }
    }

    void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        Object[] objectArray;
        int n;
        int n2;
        int n3;
        if (styleRangeArray == null) {
            this.styleCount = 0;
            this.stylesSetCount = 0;
            this.ranges = null;
            this.styles = null;
            this.stylesSet = null;
            this.hasLinks = false;
            return;
        }
        if (nArray == null) {
            nArray = new int[styleRangeArray.length << 1];
            StyleRange[] styleRangeArray2 = new StyleRange[styleRangeArray.length];
            if (this.stylesSet == null) {
                this.stylesSet = new StyleRange[4];
            }
            n3 = 0;
            n2 = 0;
            while (n3 < styleRangeArray.length) {
                StyleRange styleRange = styleRangeArray[n3];
                nArray[n2++] = styleRange.start;
                nArray[n2++] = styleRange.length;
                n = 0;
                while (n < this.stylesSetCount) {
                    if (this.stylesSet[n].similarTo(styleRange)) break;
                    ++n;
                }
                if (n == this.stylesSetCount) {
                    if (this.stylesSetCount == this.stylesSet.length) {
                        objectArray = new StyleRange[this.stylesSetCount + 4];
                        System.arraycopy(this.stylesSet, 0, objectArray, 0, this.stylesSetCount);
                        this.stylesSet = (StyleRange[])objectArray;
                    }
                    this.stylesSet[this.stylesSetCount++] = styleRange;
                }
                styleRangeArray2[n3] = this.stylesSet[n];
                ++n3;
            }
            styleRangeArray = styleRangeArray2;
        }
        if (this.styleCount == 0) {
            if (nArray != null) {
                this.ranges = new int[nArray.length];
                System.arraycopy(nArray, 0, this.ranges, 0, this.ranges.length);
            }
            this.styles = new StyleRange[styleRangeArray.length];
            System.arraycopy(styleRangeArray, 0, this.styles, 0, this.styles.length);
            this.styleCount = styleRangeArray.length;
            return;
        }
        if (nArray != null && this.ranges == null) {
            this.ranges = new int[this.styles.length << 1];
            int n4 = 0;
            n3 = 0;
            while (n4 < this.styleCount) {
                this.ranges[n3++] = this.styles[n4].start;
                this.ranges[n3++] = this.styles[n4].length;
                ++n4;
            }
        }
        if (nArray == null && this.ranges != null) {
            nArray = new int[styleRangeArray.length << 1];
            int n5 = 0;
            n3 = 0;
            while (n5 < styleRangeArray.length) {
                nArray[n3++] = styleRangeArray[n5].start;
                nArray[n3++] = styleRangeArray[n5].length;
                ++n5;
            }
        }
        if (this.ranges != null) {
            n3 = nArray[0];
            int n6 = this.styleCount << 1;
            n2 = this.getRangeIndex(n3, -1, n6);
            int n7 = n = n2 == n6 ? 1 : 0;
            if (n == 0) {
                int n8 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
                int n9 = this.getRangeIndex(n8, n2 - 1, n6);
                int n10 = n = n2 == n9 && this.ranges[n2] >= n8 ? 1 : 0;
            }
            if (n != 0) {
                this.addMerge(nArray, styleRangeArray, nArray.length, n2, n2);
                return;
            }
            int n11 = n2;
            objectArray = new int[6];
            StyleRange[] styleRangeArray3 = new StyleRange[3];
            int n12 = 0;
            while (n12 < nArray.length) {
                int n13 = nArray[n12];
                int n14 = n13 + nArray[n12 + 1];
                if (n13 != n14) {
                    int n15 = 0;
                    int n16 = 0;
                    while (n11 < n6) {
                        if (n13 >= this.ranges[n2] + this.ranges[n2 + 1]) {
                            n2 += 2;
                        }
                        if (this.ranges[n11] + this.ranges[n11 + 1] > n14) break;
                        n11 += 2;
                    }
                    if (this.ranges[n2] < n13 && n13 < this.ranges[n2] + this.ranges[n2 + 1]) {
                        styleRangeArray3[n16 >> 1] = this.styles[n2 >> 1];
                        objectArray[n16] = this.ranges[n2];
                        objectArray[n16 + 1] = n13 - this.ranges[n2];
                        n16 += 2;
                    }
                    styleRangeArray3[n16 >> 1] = styleRangeArray[n12 >> 1];
                    objectArray[n16] = n13;
                    objectArray[n16 + 1] = nArray[n12 + 1];
                    n16 += 2;
                    if (n11 < n6 && this.ranges[n11] < n14 && n14 < this.ranges[n11] + this.ranges[n11 + 1]) {
                        styleRangeArray3[n16 >> 1] = this.styles[n11 >> 1];
                        objectArray[n16] = n14;
                        objectArray[n16 + 1] = this.ranges[n11] + this.ranges[n11 + 1] - n14;
                        n16 += 2;
                        n15 = 2;
                    }
                    int n17 = this.addMerge((int[])objectArray, styleRangeArray3, n16, n2, n11 + n15);
                    n6 += n17;
                    n2 = n11 += n17;
                }
                n12 += 2;
            }
        } else {
            boolean bl;
            int n18 = styleRangeArray[0].start;
            n3 = this.getRangeIndex(n18, -1, this.styleCount);
            boolean bl2 = bl = n3 == this.styleCount;
            if (!bl) {
                n = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
                n2 = this.getRangeIndex(n, n3 - 1, this.styleCount);
                boolean bl3 = bl = n3 == n2 && this.styles[n3].start >= n;
            }
            if (bl) {
                this.addMerge(styleRangeArray, styleRangeArray.length, n3, n3);
                return;
            }
            n2 = n3;
            StyleRange[] styleRangeArray4 = new StyleRange[3];
            int n19 = 0;
            while (n19 < styleRangeArray.length) {
                StyleRange styleRange = styleRangeArray[n19];
                int n20 = styleRange.start;
                int n21 = n20 + styleRange.length;
                if (n20 != n21) {
                    int n22 = 0;
                    int n23 = 0;
                    while (n2 < this.styleCount) {
                        if (n20 >= this.styles[n3].start + this.styles[n3].length) {
                            ++n3;
                        }
                        if (this.styles[n2].start + this.styles[n2].length > n21) break;
                        ++n2;
                    }
                    StyleRange styleRange2 = this.styles[n3];
                    if (styleRange2.start < n20 && n20 < styleRange2.start + styleRange2.length) {
                        int n24 = n23++;
                        StyleRange styleRange3 = (StyleRange)styleRange2.clone();
                        styleRangeArray4[n24] = styleRange3;
                        styleRange2 = styleRange3;
                        styleRange2.length = n20 - styleRange2.start;
                    }
                    styleRangeArray4[n23++] = styleRange;
                    if (n2 < this.styleCount) {
                        styleRange2 = this.styles[n2];
                        if (styleRange2.start < n21 && n21 < styleRange2.start + styleRange2.length) {
                            int n25 = n23++;
                            StyleRange styleRange4 = (StyleRange)styleRange2.clone();
                            styleRangeArray4[n25] = styleRange4;
                            styleRange2 = styleRange4;
                            styleRange2.length += styleRange2.start - n21;
                            styleRange2.start = n21;
                            n22 = 1;
                        }
                    }
                    int n26 = this.addMerge(styleRangeArray4, n23, n3, n2 + n22);
                    n3 = n2 += n26;
                }
                ++n19;
            }
        }
    }

    void textChanging(TextChangingEvent textChangingEvent) {
        int n = textChangingEvent.start;
        int n2 = textChangingEvent.newCharCount;
        int n3 = textChangingEvent.replaceCharCount;
        int n4 = textChangingEvent.newLineCount;
        int n5 = textChangingEvent.replaceLineCount;
        this.updateRanges(n, n3, n2);
        int n6 = this.content.getLineAtOffset(n);
        if (n3 == this.content.getCharCount()) {
            this.lines = null;
        }
        if (n5 == this.lineCount) {
            this.lineCount = n4;
            this.lineWidth = new int[this.lineCount];
            this.lineHeight = new int[this.lineCount];
            this.reset(0, this.lineCount);
        } else {
            int n7;
            Object[] objectArray;
            int n8 = n4 - n5;
            if (this.lineCount + n8 > this.lineWidth.length) {
                objectArray = new int[this.lineCount + n8 + 32];
                System.arraycopy(this.lineWidth, 0, objectArray, 0, this.lineCount);
                this.lineWidth = objectArray;
                int[] nArray = new int[this.lineCount + n8 + 32];
                System.arraycopy(this.lineHeight, 0, nArray, 0, this.lineCount);
                this.lineHeight = nArray;
            }
            if (this.lines != null && this.lineCount + n8 > this.lines.length) {
                objectArray = new LineInfo[this.lineCount + n8 + 32];
                System.arraycopy(this.lines, 0, objectArray, 0, this.lineCount);
                this.lines = (LineInfo[])objectArray;
            }
            int n9 = n6 + n5 + 1;
            int n10 = n6 + n4 + 1;
            System.arraycopy(this.lineWidth, n9, this.lineWidth, n10, this.lineCount - n9);
            System.arraycopy(this.lineHeight, n9, this.lineHeight, n10, this.lineCount - n9);
            int n11 = n6;
            while (n11 < n10) {
                this.lineHeight[n11] = -1;
                this.lineWidth[n11] = -1;
                ++n11;
            }
            n11 = this.lineCount + n8;
            while (n11 < this.lineCount) {
                this.lineHeight[n11] = -1;
                this.lineWidth[n11] = -1;
                ++n11;
            }
            if (this.layouts != null) {
                n11 = n6 - this.topIndex;
                n7 = n11 + n5 + 1;
                int n12 = n11;
                while (n12 < n7) {
                    if (n12 >= 0 && n12 < this.layouts.length) {
                        if (this.layouts[n12] != null) {
                            this.layouts[n12].dispose();
                        }
                        this.layouts[n12] = null;
                        if (this.bullets != null && this.bulletsIndices != null) {
                            this.bullets[n12] = null;
                        }
                    }
                    ++n12;
                }
                if (n8 > 0) {
                    n12 = this.layouts.length - 1;
                    while (n12 >= n7) {
                        if (n12 >= 0 && n12 < this.layouts.length) {
                            n10 = n12 + n8;
                            if (n10 >= 0 && n10 < this.layouts.length) {
                                this.layouts[n10] = this.layouts[n12];
                                this.layouts[n12] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n10] = this.bullets[n12];
                                    this.bulletsIndices[n10] = this.bulletsIndices[n12];
                                    this.bullets[n12] = null;
                                }
                            } else {
                                if (this.layouts[n12] != null) {
                                    this.layouts[n12].dispose();
                                }
                                this.layouts[n12] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n12] = null;
                                }
                            }
                        }
                        --n12;
                    }
                } else if (n8 < 0) {
                    n12 = n7;
                    while (n12 < this.layouts.length) {
                        if (n12 >= 0 && n12 < this.layouts.length) {
                            n10 = n12 + n8;
                            if (n10 >= 0 && n10 < this.layouts.length) {
                                this.layouts[n10] = this.layouts[n12];
                                this.layouts[n12] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n10] = this.bullets[n12];
                                    this.bulletsIndices[n10] = this.bulletsIndices[n12];
                                    this.bullets[n12] = null;
                                }
                            } else {
                                if (this.layouts[n12] != null) {
                                    this.layouts[n12].dispose();
                                }
                                this.layouts[n12] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n12] = null;
                                }
                            }
                        }
                        ++n12;
                    }
                }
            }
            if (n5 != 0 || n4 != 0) {
                n11 = this.content.getOffsetAtLine(n6);
                if (n11 != n) {
                    ++n6;
                }
                this.updateBullets(n6, n5, n4, true);
                if (this.lines != null) {
                    n9 = n6 + n5;
                    n10 = n6 + n4;
                    System.arraycopy(this.lines, n9, this.lines, n10, this.lineCount - n9);
                    n7 = n6;
                    while (n7 < n10) {
                        this.lines[n7] = null;
                        ++n7;
                    }
                    n7 = this.lineCount + n8;
                    while (n7 < this.lineCount) {
                        this.lines[n7] = null;
                        ++n7;
                    }
                }
            }
            this.lineCount += n8;
            if (this.maxWidthLineIndex != -1 && n6 <= this.maxWidthLineIndex && this.maxWidthLineIndex <= n6 + n5) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                n11 = 0;
                while (n11 < this.lineCount) {
                    if (this.lineWidth[n11] > this.maxWidth) {
                        this.maxWidth = this.lineWidth[n11];
                        this.maxWidthLineIndex = n11;
                    }
                    ++n11;
                }
            }
        }
    }

    void updateBullets(int n, int n2, int n3, boolean bl) {
        if (this.bullets == null) {
            return;
        }
        if (this.bulletsIndices != null) {
            return;
        }
        int n4 = 0;
        while (n4 < this.bullets.length) {
            Bullet bullet = this.bullets[n4];
            int[] nArray = bullet.removeIndices(n, n2, n3, bl);
            if (nArray != null) {
                if (this.redrawLines == null) {
                    this.redrawLines = nArray;
                } else {
                    int[] nArray2 = new int[this.redrawLines.length + nArray.length];
                    System.arraycopy(this.redrawLines, 0, nArray2, 0, this.redrawLines.length);
                    System.arraycopy(nArray, 0, nArray2, this.redrawLines.length, nArray.length);
                    this.redrawLines = nArray2;
                }
            }
            ++n4;
        }
        n4 = 0;
        int n5 = 0;
        while (n5 < this.bullets.length) {
            if (this.bullets[n5].size() == 0) {
                ++n4;
            }
            ++n5;
        }
        if (n4 > 0) {
            if (n4 == this.bullets.length) {
                this.bullets = null;
            } else {
                Bullet[] bulletArray = new Bullet[this.bullets.length - n4];
                int n6 = 0;
                int n7 = 0;
                while (n6 < this.bullets.length) {
                    Bullet bullet = this.bullets[n6];
                    if (bullet.size() > 0) {
                        bulletArray[n7++] = bullet;
                    }
                    ++n6;
                }
                this.bullets = bulletArray;
            }
        }
    }

    void updateRanges(int n, int n2, int n3) {
        if (this.styleCount == 0 || n2 == 0 && n3 == 0) {
            return;
        }
        if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 == n4) {
                return;
            }
            int n6 = n + n2;
            int n7 = this.getRangeIndex(n6, n5 - 1, n4);
            int n8 = n3 - n2;
            if (n5 == n7 && this.ranges[n5] < n && n6 < this.ranges[n7] + this.ranges[n7 + 1]) {
                if (n3 == 0) {
                    int n9 = n5 + 1;
                    this.ranges[n9] = this.ranges[n9] - n2;
                    n7 += 2;
                } else {
                    if (n4 + 2 > this.ranges.length) {
                        int[] nArray = new int[this.ranges.length + 64];
                        System.arraycopy(this.ranges, 0, nArray, 0, n4);
                        this.ranges = nArray;
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.ranges, n5 + 2, this.ranges, n5 + 4, n4 - (n5 + 2));
                    System.arraycopy(this.styles, n5 + 2 >> 1, this.styles, n5 + 4 >> 1, this.styleCount - (n5 + 2 >> 1));
                    this.ranges[n5 + 3] = this.ranges[n5] + this.ranges[n5 + 1] - n6;
                    this.ranges[n5 + 2] = n + n3;
                    this.ranges[n5 + 1] = n - this.ranges[n5];
                    this.styles[(n5 >> 1) + 1] = this.styles[n5 >> 1];
                    n4 += 2;
                    ++this.styleCount;
                    n7 += 4;
                }
                if (n8 != 0) {
                    int n10 = n7;
                    while (n10 < n4) {
                        int n11 = n10;
                        this.ranges[n11] = this.ranges[n11] + n8;
                        n10 += 2;
                    }
                }
            } else {
                if (this.ranges[n5] < n && n < this.ranges[n5] + this.ranges[n5 + 1]) {
                    this.ranges[n5 + 1] = n - this.ranges[n5];
                    n5 += 2;
                }
                if (n7 < n4 && this.ranges[n7] < n6 && n6 < this.ranges[n7] + this.ranges[n7 + 1]) {
                    this.ranges[n7 + 1] = this.ranges[n7] + this.ranges[n7 + 1] - n6;
                    this.ranges[n7] = n6;
                }
                if (n8 != 0) {
                    int n12 = n7;
                    while (n12 < n4) {
                        int n13 = n12;
                        this.ranges[n13] = this.ranges[n13] + n8;
                        n12 += 2;
                    }
                }
                System.arraycopy(this.ranges, n7, this.ranges, n5, n4 - n7);
                System.arraycopy(this.styles, n7 >> 1, this.styles, n5 >> 1, this.styleCount - (n7 >> 1));
                this.styleCount -= n7 - n5 >> 1;
            }
        } else {
            int n14 = this.getRangeIndex(n, -1, this.styleCount);
            if (n14 == this.styleCount) {
                return;
            }
            int n15 = n + n2;
            int n16 = this.getRangeIndex(n15, n14 - 1, this.styleCount);
            int n17 = n3 - n2;
            if (n14 == n16 && this.styles[n14].start < n && n15 < this.styles[n16].start + this.styles[n16].length) {
                if (n3 == 0) {
                    this.styles[n14].length -= n2;
                    ++n16;
                } else {
                    if (this.styleCount + 1 > this.styles.length) {
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.styles, n14 + 1, this.styles, n14 + 2, this.styleCount - (n14 + 1));
                    this.styles[n14 + 1] = (StyleRange)this.styles[n14].clone();
                    this.styles[n14 + 1].length = this.styles[n14].start + this.styles[n14].length - n15;
                    this.styles[n14 + 1].start = n + n3;
                    this.styles[n14].length = n - this.styles[n14].start;
                    ++this.styleCount;
                    n16 += 2;
                }
                if (n17 != 0) {
                    int n18 = n16;
                    while (n18 < this.styleCount) {
                        this.styles[n18].start += n17;
                        ++n18;
                    }
                }
            } else {
                if (this.styles[n14].start < n && n < this.styles[n14].start + this.styles[n14].length) {
                    this.styles[n14].length = n - this.styles[n14].start;
                    ++n14;
                }
                if (n16 < this.styleCount && this.styles[n16].start < n15 && n15 < this.styles[n16].start + this.styles[n16].length) {
                    this.styles[n16].length = this.styles[n16].start + this.styles[n16].length - n15;
                    this.styles[n16].start = n15;
                }
                if (n17 != 0) {
                    int n19 = n16;
                    while (n19 < this.styleCount) {
                        this.styles[n19].start += n17;
                        ++n19;
                    }
                }
                System.arraycopy(this.styles, n16, this.styles, n14, this.styleCount - n16);
                this.styleCount -= n16 - n14;
            }
        }
    }

    static class LineInfo {
        int flags;
        Color background;
        int alignment;
        int indent;
        boolean justify;
        int[] segments;

        public LineInfo() {
        }

        public LineInfo(LineInfo lineInfo) {
            if (lineInfo != null) {
                this.flags = lineInfo.flags;
                this.background = lineInfo.background;
                this.alignment = lineInfo.alignment;
                this.indent = lineInfo.indent;
                this.justify = lineInfo.justify;
                this.segments = lineInfo.segments;
            }
        }
    }
}

