/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.openide.util.AWTBridge;
import org.netbeans.modules.openide.util.ActionsBridge;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CallbackSystemAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet<Class<? extends CallbackSystemAction>> notSurviving = new WeakSet(37);
    private static final WeakSet<Class<? extends CallbackSystemAction>> surviving = new WeakSet(37);
    private static final Object LISTENER = new Object();
    static final long serialVersionUID = -6305817805474624653L;
    private static final Logger err = Logger.getLogger("org.openide.util.actions.CallbackSystemAction");

    @Override
    protected void initialize() {
        super.initialize();
        this.updateEnabled();
        this.setSurviveFocusChange(false);
    }

    @Deprecated
    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    @Deprecated
    public void setActionPerformer(ActionPerformer actionPerformer) {
        this.putProperty(PROP_ACTION_PERFORMER, actionPerformer);
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnabled() {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            this.setEnabled(action.isEnabled());
            Object object = LISTENER;
            synchronized (object) {
                ActionDelegateListener actionDelegateListener = (ActionDelegateListener)this.getProperty(LISTENER);
                if (actionDelegateListener == null || actionDelegateListener.get() != this) {
                    actionDelegateListener = new ActionDelegateListener(this, action);
                    this.putProperty(LISTENER, actionDelegateListener);
                } else {
                    actionDelegateListener.attach(action);
                }
            }
        } else {
            if (this.getActionPerformer() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.clearListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListener() {
        Object object = LISTENER;
        synchronized (object) {
            ActionDelegateListener actionDelegateListener = (ActionDelegateListener)this.getProperty(LISTENER);
            if (actionDelegateListener != null) {
                actionDelegateListener.clear();
                this.putProperty(LISTENER, null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            if (action.isEnabled()) {
                action.actionPerformed(actionEvent);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        final ActionPerformer actionPerformer = this.getActionPerformer();
        if (actionPerformer != null) {
            ActionsBridge.doPerformAction(this, new ActionsBridge.ActionRunnable(actionEvent, this, this.asynchronous()){

                public void run() {
                    if (actionPerformer == CallbackSystemAction.this.getActionPerformer()) {
                        CallbackSystemAction.this.getActionPerformer().performAction(CallbackSystemAction.this);
                    }
                }
            });
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    @Deprecated
    public void performAction() {
        ActionPerformer actionPerformer = this.getActionPerformer();
        if (actionPerformer != null) {
            actionPerformer.performAction(this);
        }
    }

    public Object getActionMapKey() {
        return this.getClass().getName();
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    @Override
    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurviveFocusChange(boolean bl) {
        WeakSet<Class<? extends CallbackSystemAction>> weakSet = notSurviving;
        synchronized (weakSet) {
            if (bl) {
                notSurviving.remove(this.getClass());
                surviving.add(this.getClass());
            } else {
                notSurviving.add(this.getClass());
                surviving.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CallbackSystemAction> toInstances(Set<Class<? extends CallbackSystemAction>> set) {
        ArrayList<CallbackSystemAction> arrayList;
        WeakSet<Class<? extends CallbackSystemAction>> weakSet = notSurviving;
        synchronized (weakSet) {
            arrayList = new ArrayList<CallbackSystemAction>(set.size());
            for (Class<? extends CallbackSystemAction> clazz : set) {
                CallbackSystemAction callbackSystemAction = SystemAction.findObject(clazz, false);
                if (callbackSystemAction == null) continue;
                arrayList.add(callbackSystemAction);
            }
        }
        return arrayList;
    }

    private static void clearActionPerformers() {
        List<CallbackSystemAction> list = CallbackSystemAction.toInstances(notSurviving);
        for (CallbackSystemAction callbackSystemAction : list) {
            callbackSystemAction.setActionPerformer(null);
        }
        list = CallbackSystemAction.toInstances(surviving);
        for (CallbackSystemAction callbackSystemAction : list) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("updateEnabled: " + callbackSystemAction);
            }
            callbackSystemAction.updateEnabled();
        }
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PropertyChangeListener {
        private CallbackSystemAction delegate;
        private Lookup.Result<ActionMap> result;
        private boolean enabled;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private PropertyChangeListener weakL;
        private Reference<Action> lastRef;

        public DelegateAction(CallbackSystemAction callbackSystemAction, Lookup lookup) {
            this.delegate = callbackSystemAction;
            this.weakL = WeakListeners.propertyChange(this, null);
            this.enabled = callbackSystemAction.getActionPerformer() != null;
            this.result = lookup.lookup(new Lookup.Template<ActionMap>(ActionMap.class));
            this.result.addLookupListener(WeakListeners.create(LookupListener.class, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(final ActionEvent actionEvent) {
            final Action action = this.findAction();
            if (action != null) {
                ActionsBridge.ActionRunnable actionRunnable = new ActionsBridge.ActionRunnable(actionEvent, this.delegate, this.delegate.asynchronous()){

                    public void run() {
                        action.actionPerformed(actionEvent);
                    }
                };
                ActionsBridge.doPerformAction(this.delegate, actionRunnable);
            } else {
                Object object;
                Object object2 = actionEvent.getSource();
                if (object2 instanceof Component && SwingUtilities.getWindowAncestor((Component)object2) instanceof Dialog && !Boolean.TRUE.equals(object = this.delegate.getValue("OpenIDE-Transmodal-Action"))) {
                    return;
                }
                this.delegate.actionPerformed(actionEvent);
            }
        }

        public boolean isEnabled() {
            Action action;
            Action action2 = this.findAction();
            if (action2 == null) {
                action2 = this.delegate;
            }
            Action action3 = action = this.lastRef == null ? null : this.lastRef.get();
            if (action2 != action) {
                if (action != null) {
                    action.removePropertyChangeListener(this.weakL);
                }
                this.lastRef = new WeakReference<Action>(action2);
                action2.addPropertyChangeListener(this.weakL);
            }
            return action2.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public void putValue(String string, Object object) {
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public void setEnabled(boolean bl) {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            boolean bl = this.isEnabled();
            if (bl != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, bl);
                this.enabled = bl;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.resultChanged(null);
        }

        private Action findAction() {
            Set<ActionMap> set;
            Collection<ActionMap> collection = set = this.result != null ? this.result.allInstances() : Collections.emptySet();
            if (!set.isEmpty()) {
                Object object = this.delegate.getActionMapKey();
                for (ActionMap actionMap : set) {
                    Action action = actionMap.get(object);
                    if (action == null) continue;
                    return action;
                }
            }
            return null;
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverridden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return AWTBridge.getDefault().createMenuPresenter(this);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverridden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return AWTBridge.getDefault().createPopupPresenter(this);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverridden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return AWTBridge.getDefault().createToolbarPresenter(this);
        }

        private boolean isMethodOverridden(CallableSystemAction callableSystemAction, String string) {
            try {
                Method method = callableSystemAction.getClass().getMethod(string, new Class[0]);
                return method.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                throw new IllegalStateException("Error searching for method " + string + " in " + callableSystemAction);
            }
        }

        protected void finalize() {
            Action action;
            Action action2 = action = this.lastRef == null ? null : this.lastRef.get();
            if (action != null) {
                action.removePropertyChangeListener(this.weakL);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionDelegateListener
    extends WeakReference<CallbackSystemAction>
    implements PropertyChangeListener {
        private Reference<Action> delegate;

        public ActionDelegateListener(CallbackSystemAction callbackSystemAction, Action action) {
            super(callbackSystemAction);
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        @Override
        public void clear() {
            Action action;
            Reference<Action> reference = this.delegate;
            Action action2 = action = reference == null ? null : reference.get();
            if (action == null) {
                return;
            }
            this.delegate = null;
            action.removePropertyChangeListener(this);
        }

        public void attach(Action action) {
            Reference<Action> reference = this.delegate;
            if (reference != null && reference.get() == action) {
                return;
            }
            Action action2 = reference.get();
            if (action2 != null) {
                action2.removePropertyChangeListener(this);
            }
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = LISTENER;
            synchronized (object) {
                Reference<Action> reference = this.delegate;
                if (reference == null || reference.get() == null) {
                    return;
                }
            }
            object = (CallbackSystemAction)this.get();
            if (object != null) {
                ((CallbackSystemAction)object).updateEnabled();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakAction
    extends WeakReference<Action>
    implements Action {
        public WeakAction(Action action) {
            super(action);
        }

        public Action getDelegate() {
            return (Action)this.get();
        }

        @Override
        public Object getValue(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putValue(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEnabled(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GlobalManager
    implements LookupListener {
        private static GlobalManager instance;
        private Lookup.Result<ActionMap> result;
        private List<Reference<ActionMap>> actionMaps = new ArrayList<Reference<ActionMap>>(2);
        private final ActionMap survive = new ActionMap();

        private GlobalManager() {
            this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template<ActionMap>(ActionMap.class));
            this.result.addLookupListener(this);
            this.resultChanged(null);
        }

        public static synchronized GlobalManager getDefault() {
            if (instance != null) {
                return instance;
            }
            instance = new GlobalManager();
            return instance;
        }

        public Action findGlobalAction(Object object, boolean bl) {
            Reference<ActionMap> reference;
            ActionMap actionMap;
            Action action = null;
            Iterator<Reference<ActionMap>> iterator = this.actionMaps.iterator();
            while (iterator.hasNext() && (action = (actionMap = (reference = iterator.next()).get()) == null ? null : actionMap.get(object)) == null) {
            }
            if (bl) {
                if (action == null) {
                    action = this.survive.get(object);
                    if (action != null) {
                        action = ((WeakAction)action).getDelegate();
                    }
                    if (err.isLoggable(Level.FINE)) {
                        err.fine("No action for key: " + object + " using delegate: " + action);
                    }
                } else {
                    if (err.isLoggable(Level.FINE)) {
                        err.fine("New action for key: " + object + " put: " + action);
                    }
                    this.survive.put(object, new WeakAction(action));
                }
            }
            if (err.isLoggable(Level.FINE)) {
                err.fine("Action for key: " + object + " is: " + action);
            }
            return action;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Collection<ActionMap> collection = this.result.allInstances();
            if (err.isLoggable(Level.FINE)) {
                err.fine("changed maps : " + collection);
                err.fine("previous maps: " + this.actionMaps);
            }
            if (collection.size() == this.actionMaps.size()) {
                boolean bl = true;
                int n = 0;
                Iterator<ActionMap> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ActionMap actionMap = this.actionMaps.get(n).get();
                    if (actionMap == null || actionMap != iterator.next()) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    return;
                }
            }
            this.actionMaps.clear();
            for (ActionMap actionMap : collection) {
                this.actionMaps.add(new WeakReference<ActionMap>(actionMap));
            }
            if (err.isLoggable(Level.FINE)) {
                err.fine("clearActionPerformers");
            }
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    CallbackSystemAction.clearActionPerformers();
                }
            });
        }
    }
}

