/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.runner.Sorter;
import junit.runner.TestCollector;

public class TestSelector
extends JDialog {
    private JButton fCancel;
    private JButton fOk;
    private JList fList;
    private JScrollPane fScrolledList;
    private JLabel fDescription;
    private String fSelectedItem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestSelector(Frame frame, TestCollector testCollector) {
        super(frame, true);
        this.setSize(350, 300);
        this.setResizable(false);
        try {
            this.setLocationRelativeTo(frame);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            TestSelector.centerWindow(this);
        }
        this.setTitle("Test Selector");
        Vector vector = null;
        try {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            vector = this.createTestList(testCollector);
        }
        finally {
            frame.setCursor(Cursor.getDefaultCursor());
        }
        this.fList = new JList(vector);
        this.fList.setSelectionMode(0);
        this.fList.setCellRenderer(new TestCellRenderer());
        this.fScrolledList = new JScrollPane(this.fList);
        this.fCancel = new JButton("Cancel");
        this.fDescription = new JLabel("Select the Test class:");
        this.fOk = new JButton("OK");
        this.fOk.setEnabled(false);
        this.getRootPane().setDefaultButton(this.fOk);
        this.defineLayout();
        this.addListeners();
    }

    public static void centerWindow(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component.getToolkit().getScreenSize();
        component.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    private void addListeners() {
        this.fCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSelector.this.dispose();
            }
        });
        this.fOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestSelector.this.okSelected();
            }
        });
        this.fList.addMouseListener(new DoubleClickListener());
        this.fList.addKeyListener(new KeySelectListener());
        this.fList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TestSelector.this.checkEnableOK(listSelectionEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TestSelector.this.dispose();
            }
        });
    }

    private void defineLayout() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.getContentPane().add((Component)this.fDescription, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(8, 8, 8, 8);
        this.getContentPane().add((Component)this.fScrolledList, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fOk, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fCancel, gridBagConstraints4);
    }

    public void checkEnableOK(ListSelectionEvent listSelectionEvent) {
        this.fOk.setEnabled(this.fList.getSelectedIndex() != -1);
    }

    public void okSelected() {
        this.fSelectedItem = (String)this.fList.getSelectedValue();
        this.dispose();
    }

    public boolean isEmpty() {
        return this.fList.getModel().getSize() == 0;
    }

    public void keySelectTestClass(char c) {
        ListModel listModel = this.fList.getModel();
        if (!Character.isJavaIdentifierStart(c)) {
            return;
        }
        for (int i = 0; i < listModel.getSize(); ++i) {
            String string = (String)listModel.getElementAt(i);
            if (!TestCellRenderer.matchesKey(string, Character.toUpperCase(c))) continue;
            this.fList.setSelectedIndex(i);
            this.fList.ensureIndexIsVisible(i);
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public String getSelectedItem() {
        return this.fSelectedItem;
    }

    private Vector createTestList(TestCollector testCollector) {
        Enumeration enumeration = testCollector.collectTests();
        Vector<String> vector = new Vector<String>(200);
        Vector<String> vector2 = new Vector<String>(vector.size());
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
            vector2.addElement(TestCellRenderer.displayString(string));
        }
        if (vector.size() > 0) {
            Sorter.sortStrings(vector2, 0, vector2.size() - 1, new ParallelSwapper(vector));
        }
        return vector;
    }

    private class ParallelSwapper
    implements Sorter.Swapper {
        Vector fOther;

        ParallelSwapper(Vector vector) {
            this.fOther = vector;
        }

        public void swap(Vector vector, int n, int n2) {
            Object e = vector.elementAt(n);
            vector.setElementAt(vector.elementAt(n2), n);
            vector.setElementAt(e, n2);
            Object e2 = this.fOther.elementAt(n);
            this.fOther.setElementAt(this.fOther.elementAt(n2), n);
            this.fOther.setElementAt(e2, n2);
        }
    }

    protected class KeySelectListener
    extends KeyAdapter {
        protected KeySelectListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            TestSelector.this.keySelectTestClass(keyEvent.getKeyChar());
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        protected DoubleClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TestSelector.this.okSelected();
            }
        }
    }

    static class TestCellRenderer
    extends DefaultListCellRenderer {
        Icon fLeafIcon = UIManager.getIcon("Tree.leafIcon");
        Icon fSuiteIcon = UIManager.getIcon("Tree.closedIcon");

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = TestCellRenderer.displayString((String)object);
            if (string.startsWith("AllTests")) {
                this.setIcon(this.fSuiteIcon);
            } else {
                this.setIcon(this.fLeafIcon);
            }
            this.setText(string);
            return component;
        }

        public static String displayString(String string) {
            int n = string.lastIndexOf(46);
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1) + " - " + string.substring(0, n);
        }

        public static boolean matchesKey(String string, char c) {
            return c == Character.toUpperCase(string.charAt(TestCellRenderer.typeIndex(string)));
        }

        private static int typeIndex(String string) {
            int n = string.lastIndexOf(46);
            int n2 = 0;
            if (n > 0) {
                n2 = n + 1;
            }
            return n2;
        }
    }
}

