/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.FailureDetailView;
import junit.runner.SimpleTestCollector;
import junit.runner.TestCollector;
import junit.runner.Version;
import junit.swingui.AboutDialog;
import junit.swingui.CounterPanel;
import junit.swingui.DefaultFailureDetailView;
import junit.swingui.FailureRunView;
import junit.swingui.MacProgressBar;
import junit.swingui.ProgressBar;
import junit.swingui.StatusLine;
import junit.swingui.TestHierarchyRunView;
import junit.swingui.TestRunContext;
import junit.swingui.TestRunView;
import junit.swingui.TestSelector;

public class TestRunner
extends BaseTestRunner
implements TestRunContext {
    private static final int GAP = 4;
    private static final int HISTORY_LENGTH = 5;
    protected JFrame fFrame;
    private Thread fRunner;
    private TestResult fTestResult;
    private JComboBox fSuiteCombo;
    private ProgressBar fProgressIndicator;
    private DefaultListModel fFailures;
    private JLabel fLogo;
    private CounterPanel fCounterPanel;
    private JButton fRun;
    private JButton fQuitButton;
    private JButton fRerunButton;
    private StatusLine fStatusLine;
    private FailureDetailView fFailureView;
    private JTabbedPane fTestViewTab;
    private JCheckBox fUseLoadingRunner;
    private Vector fTestRunViews = new Vector();
    private static final String TESTCOLLECTOR_KEY = "TestCollectorClass";
    private static final String FAILUREDETAILVIEW_KEY = "FailureViewClass";

    public static void main(String[] stringArray) {
        new TestRunner().start(stringArray);
    }

    public static void run(Class clazz) {
        String[] stringArray = new String[]{clazz.getName()};
        TestRunner.main(stringArray);
    }

    public void testFailed(final int n, final Test test, final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                switch (n) {
                    case 1: {
                        TestRunner.this.fCounterPanel.setErrorValue(TestRunner.this.fTestResult.errorCount());
                        TestRunner.this.appendFailure(test, throwable);
                        break;
                    }
                    case 2: {
                        TestRunner.this.fCounterPanel.setFailureValue(TestRunner.this.fTestResult.failureCount());
                        TestRunner.this.appendFailure(test, throwable);
                    }
                }
            }
        });
    }

    public void testStarted(String string) {
        this.postInfo("Running: " + string);
    }

    public void testEnded(String string) {
        this.synchUI();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TestRunner.this.fTestResult != null) {
                    TestRunner.this.fCounterPanel.setRunValue(TestRunner.this.fTestResult.runCount());
                    TestRunner.this.fProgressIndicator.step(TestRunner.this.fTestResult.runCount(), TestRunner.this.fTestResult.wasSuccessful());
                }
            }
        });
    }

    public void setSuite(String string) {
        this.fSuiteCombo.getEditor().setItem(string);
    }

    private void addToHistory(String string) {
        for (int i = 0; i < this.fSuiteCombo.getItemCount(); ++i) {
            if (!string.equals(this.fSuiteCombo.getItemAt(i))) continue;
            this.fSuiteCombo.removeItemAt(i);
            this.fSuiteCombo.insertItemAt(string, 0);
            this.fSuiteCombo.setSelectedIndex(0);
            return;
        }
        this.fSuiteCombo.insertItemAt(string, 0);
        this.fSuiteCombo.setSelectedIndex(0);
        this.pruneHistory();
    }

    private void pruneHistory() {
        int n = TestRunner.getPreference("maxhistory", 5);
        if (n < 1) {
            n = 1;
        }
        for (int i = this.fSuiteCombo.getItemCount() - 1; i > n - 1; --i) {
            this.fSuiteCombo.removeItemAt(i);
        }
    }

    private void appendFailure(Test test, Throwable throwable) {
        this.fFailures.addElement(new TestFailure(test, throwable));
        if (this.fFailures.size() == 1) {
            this.revealFailure(test);
        }
    }

    private void revealFailure(Test test) {
        Enumeration enumeration = this.fTestRunViews.elements();
        while (enumeration.hasMoreElements()) {
            TestRunView testRunView = (TestRunView)enumeration.nextElement();
            testRunView.revealFailure(test);
        }
    }

    protected void aboutToStart(Test test) {
        Enumeration enumeration = this.fTestRunViews.elements();
        while (enumeration.hasMoreElements()) {
            TestRunView testRunView = (TestRunView)enumeration.nextElement();
            testRunView.aboutToStart(test, this.fTestResult);
        }
    }

    protected void runFinished(final Test test) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Enumeration enumeration = TestRunner.this.fTestRunViews.elements();
                while (enumeration.hasMoreElements()) {
                    TestRunView testRunView = (TestRunView)enumeration.nextElement();
                    testRunView.runFinished(test, TestRunner.this.fTestResult);
                }
            }
        });
    }

    protected CounterPanel createCounterPanel() {
        return new CounterPanel();
    }

    protected JPanel createFailedPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 2));
        this.fRerunButton = new JButton("Run");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.rerun();
            }
        });
        jPanel.add(this.fRerunButton);
        return jPanel;
    }

    protected FailureDetailView createFailureDetailView() {
        String string = BaseTestRunner.getPreference(FAILUREDETAILVIEW_KEY);
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                return (FailureDetailView)clazz.newInstance();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.fFrame, "Could not create Failure DetailView - using default view");
            }
        }
        return new DefaultFailureDetailView();
    }

    protected JMenu createJUnitMenu() {
        JMenu jMenu = new JMenu("JUnit");
        jMenu.setMnemonic('J');
        JMenuItem jMenuItem = new JMenuItem("About...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.about();
            }
        });
        jMenuItem.setMnemonic('A');
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(" Exit ");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.terminate();
            }
        });
        jMenuItem2.setMnemonic('x');
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected JFrame createFrame() {
        JFrame jFrame = new JFrame("JUnit");
        Image image = this.loadFrameIcon();
        if (image != null) {
            jFrame.setIconImage(image);
        }
        jFrame.getContentPane().setLayout(new BorderLayout(0, 0));
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TestRunner.this.terminate();
            }
        });
        return jFrame;
    }

    protected JLabel createLogo() {
        Icon icon = TestRunner.getIconResource(BaseTestRunner.class, "logo.gif");
        JLabel jLabel = icon != null ? new JLabel(icon) : new JLabel("JV");
        jLabel.setToolTipText("JUnit Version " + Version.id());
        return jLabel;
    }

    protected void createMenus(JMenuBar jMenuBar) {
        jMenuBar.add(this.createJUnitMenu());
    }

    protected JCheckBox createUseLoaderCheckBox() {
        boolean bl = this.useReloadingTestSuiteLoader();
        JCheckBox jCheckBox = new JCheckBox("Reload classes every run", bl);
        jCheckBox.setToolTipText("Use a custom class loader to reload the classes for every run");
        if (TestRunner.inVAJava()) {
            jCheckBox.setVisible(false);
        }
        return jCheckBox;
    }

    protected JButton createQuitButton() {
        JButton jButton = new JButton(" Exit ");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.terminate();
            }
        });
        return jButton;
    }

    protected JButton createRunButton() {
        JButton jButton = new JButton("Run");
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.runSuite();
            }
        });
        return jButton;
    }

    protected Component createBrowseButton() {
        JButton jButton = new JButton("...");
        jButton.setToolTipText("Select a Test class");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestRunner.this.browseTestClasses();
            }
        });
        return jButton;
    }

    protected StatusLine createStatusLine() {
        return new StatusLine(380);
    }

    protected JComboBox createSuiteCombo() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jComboBox.setLightWeightPopupEnabled(false);
        jComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                TestRunner.this.textChanged();
                if (keyEvent.getKeyChar() == '\n') {
                    TestRunner.this.runSuite();
                }
            }
        });
        try {
            this.loadHistory(jComboBox);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TestRunner.this.textChanged();
                }
            }
        });
        return jComboBox;
    }

    protected JTabbedPane createTestRunViews() {
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        FailureRunView failureRunView = new FailureRunView(this);
        this.fTestRunViews.addElement(failureRunView);
        failureRunView.addTab(jTabbedPane);
        TestHierarchyRunView testHierarchyRunView = new TestHierarchyRunView(this);
        this.fTestRunViews.addElement(testHierarchyRunView);
        testHierarchyRunView.addTab(jTabbedPane);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestRunner.this.testViewChanged();
            }
        });
        return jTabbedPane;
    }

    public void testViewChanged() {
        TestRunView testRunView = (TestRunView)this.fTestRunViews.elementAt(this.fTestViewTab.getSelectedIndex());
        testRunView.activate();
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected JFrame createUI(String string) {
        JFrame jFrame = this.createFrame();
        JMenuBar jMenuBar = new JMenuBar();
        this.createMenus(jMenuBar);
        jFrame.setJMenuBar(jMenuBar);
        JLabel jLabel = new JLabel("Test class name:");
        this.fSuiteCombo = this.createSuiteCombo();
        this.fRun = this.createRunButton();
        jFrame.getRootPane().setDefaultButton(this.fRun);
        Component component = this.createBrowseButton();
        this.fUseLoadingRunner = this.createUseLoaderCheckBox();
        this.fStatusLine = this.createStatusLine();
        this.fProgressIndicator = TestRunner.inMac() ? new MacProgressBar(this.fStatusLine) : new ProgressBar();
        this.fCounterPanel = this.createCounterPanel();
        this.fFailures = new DefaultListModel();
        this.fTestViewTab = this.createTestRunViews();
        JPanel jPanel = this.createFailedPanel();
        this.fFailureView = this.createFailureDetailView();
        JScrollPane jScrollPane = new JScrollPane(this.fFailureView.getComponent(), 22, 32);
        this.fQuitButton = this.createQuitButton();
        this.fLogo = this.createLogo();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.addGrid(jPanel2, jLabel, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(jPanel2, this.fSuiteCombo, 0, 1, 1, 2, 1.0, 17);
        this.addGrid(jPanel2, component, 1, 1, 1, 0, 0.0, 17);
        this.addGrid(jPanel2, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(jPanel2, this.fUseLoadingRunner, 0, 2, 3, 0, 1.0, 17);
        this.addGrid(jPanel2, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(jPanel2, this.fLogo, 2, 3, 1, 0, 0.0, 11);
        this.addGrid(jPanel2, this.fCounterPanel, 0, 4, 2, 0, 0.0, 17);
        this.addGrid(jPanel2, new JSeparator(), 0, 5, 2, 2, 1.0, 17);
        this.addGrid(jPanel2, new JLabel("Results:"), 0, 6, 2, 2, 1.0, 17);
        JSplitPane jSplitPane = new JSplitPane(0, this.fTestViewTab, jScrollPane);
        this.addGrid(jPanel2, jSplitPane, 0, 7, 2, 1, 1.0, 17);
        this.addGrid(jPanel2, jPanel, 2, 7, 1, 2, 0.0, 11);
        this.addGrid(jPanel2, this.fStatusLine, 0, 9, 2, 2, 1.0, 10);
        this.addGrid(jPanel2, this.fQuitButton, 2, 9, 1, 2, 0.0, 10);
        jFrame.setContentPane(jPanel2);
        jFrame.pack();
        jFrame.setLocation(200, 200);
        return jFrame;
    }

    private void addGrid(JPanel jPanel, Component component, int n, int n2, int n3, int n4, double d, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = n4;
        if (n4 == 1 || n4 == 3) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.insets = new Insets(n2 == 0 ? 10 : 0, n == 0 ? 10 : 4, 4, 4);
        jPanel.add(component, gridBagConstraints);
    }

    protected String getSuiteText() {
        if (this.fSuiteCombo == null) {
            return "";
        }
        return (String)this.fSuiteCombo.getEditor().getItem();
    }

    public ListModel getFailures() {
        return this.fFailures;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    protected Object instanciateClass(String string, Object object) {
        try {
            Class<?> clazz = Class.forName(string);
            if (object == null) {
                return clazz.newInstance();
            }
            Class[] classArray = new Class[]{object.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{object};
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void browseTestClasses() {
        TestCollector testCollector = this.createTestCollector();
        TestSelector testSelector = new TestSelector((Frame)this.fFrame, testCollector);
        if (testSelector.isEmpty()) {
            JOptionPane.showMessageDialog(this.fFrame, "No Test Cases found.\nCheck that the configured 'TestCollector' is supported on this platform.");
            return;
        }
        testSelector.show();
        String string = testSelector.getSelectedItem();
        if (string != null) {
            this.setSuite(string);
        }
    }

    TestCollector createTestCollector() {
        String string = BaseTestRunner.getPreference(TESTCOLLECTOR_KEY);
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                return (TestCollector)clazz.newInstance();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.fFrame, "Could not create TestCollector - using default collector");
            }
        }
        return new SimpleTestCollector();
    }

    private Image loadFrameIcon() {
        ImageIcon imageIcon = (ImageIcon)TestRunner.getIconResource(BaseTestRunner.class, "smalllogo.gif");
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHistory(JComboBox jComboBox) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getSettingsFile()));
        int n = 0;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                jComboBox.addItem(string);
                ++n;
            }
            if (n > 0) {
                jComboBox.setSelectedIndex(0);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    private File getSettingsFile() {
        String string = System.getProperty("user.home");
        return new File(string, ".junitsession");
    }

    private void postInfo(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestRunner.this.showInfo(string);
            }
        });
    }

    private void postStatus(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestRunner.this.showStatus(string);
            }
        });
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged();
    }

    private void rerun() {
        TestRunView testRunView = (TestRunView)this.fTestRunViews.elementAt(this.fTestViewTab.getSelectedIndex());
        Test test = testRunView.getSelectedTest();
        if (test != null) {
            this.rerunTest(test);
        }
    }

    private void rerunTest(Test test) {
        Object object;
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test test2 = null;
        TestCase testCase = (TestCase)test;
        try {
            object = this.getLoader().reload(test.getClass());
            test2 = TestSuite.createTest((Class)object, testCase.getName());
        }
        catch (Exception exception) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        object = new TestResult();
        test2.run((TestResult)object);
        String string = test2.toString();
        if (((TestResult)object).wasSuccessful()) {
            this.showInfo(string + " was successful");
        } else if (((TestResult)object).errorCount() == 1) {
            this.showStatus(string + " had an error");
        } else {
            this.showStatus(string + " had a failure");
        }
    }

    protected void reset() {
        this.fCounterPanel.reset();
        this.fProgressIndicator.reset();
        this.fRerunButton.setEnabled(false);
        this.fFailureView.clear();
        this.fFailures.clear();
    }

    protected void runFailed(String string) {
        this.showStatus(string);
        this.fRun.setText("Run");
        this.fRunner = null;
    }

    public synchronized void runSuite() {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.setLoading(this.shouldReload());
            this.reset();
            this.showInfo("Load Test Case...");
            String string = this.getSuiteText();
            Test test = this.getTest(string);
            if (test != null) {
                this.addToHistory(string);
                this.doRunTest(test);
            }
        }
    }

    private boolean shouldReload() {
        return !TestRunner.inVAJava() && this.fUseLoadingRunner.isSelected();
    }

    protected synchronized void runTest(Test test) {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.reset();
            if (test != null) {
                this.doRunTest(test);
            }
        }
    }

    private void doRunTest(final Test test) {
        this.setButtonLabel(this.fRun, "Stop");
        this.fRunner = new Thread("TestRunner-Thread"){

            public void run() {
                TestRunner.this.start(test);
                TestRunner.this.postInfo("Running...");
                long l = System.currentTimeMillis();
                test.run(TestRunner.this.fTestResult);
                if (TestRunner.this.fTestResult.shouldStop()) {
                    TestRunner.this.postStatus("Stopped");
                } else {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    TestRunner.this.postInfo("Finished: " + TestRunner.this.elapsedTimeAsString(l3) + " seconds");
                }
                TestRunner.this.runFinished(test);
                TestRunner.this.setButtonLabel(TestRunner.this.fRun, "Run");
                TestRunner.this.fRunner = null;
                System.gc();
            }
        };
        this.fTestResult = this.createTestResult();
        this.fTestResult.addListener(this);
        this.aboutToStart(test);
        this.fRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHistory() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getSettingsFile()));
        try {
            for (int i = 0; i < this.fSuiteCombo.getItemCount(); ++i) {
                String string = this.fSuiteCombo.getItemAt(i).toString();
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    private void setButtonLabel(final JButton jButton, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jButton.setText(string);
            }
        });
    }

    public void handleTestSelected(Test test) {
        this.fRerunButton.setEnabled(test != null && test instanceof TestCase);
        this.showFailureDetail(test);
    }

    private void showFailureDetail(Test test) {
        if (test != null) {
            ListModel listModel = this.getFailures();
            for (int i = 0; i < listModel.getSize(); ++i) {
                TestFailure testFailure = (TestFailure)listModel.getElementAt(i);
                if (testFailure.failedTest() != test) continue;
                this.fFailureView.showFailure(testFailure);
                return;
            }
        }
        this.fFailureView.clear();
    }

    private void showInfo(String string) {
        this.fStatusLine.showInfo(string);
    }

    private void showStatus(String string) {
        this.fStatusLine.showError(string);
    }

    public void start(String[] stringArray) {
        String string = this.processArguments(stringArray);
        this.fFrame = this.createUI(string);
        this.fFrame.pack();
        this.fFrame.setVisible(true);
        if (string != null) {
            this.setSuite(string);
            this.runSuite();
        }
    }

    private void start(final Test test) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = test.countTestCases();
                TestRunner.this.fProgressIndicator.start(n);
                TestRunner.this.fCounterPanel.setTotal(n);
            }
        });
    }

    private void synchUI() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void terminate() {
        this.fFrame.dispose();
        try {
            this.saveHistory();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't save test run history");
        }
        System.exit(0);
    }

    public void textChanged() {
        this.fRun.setEnabled(this.getSuiteText().length() > 0);
        this.clearStatus();
    }

    protected void clearStatus() {
        this.fStatusLine.clear();
    }

    public static Icon getIconResource(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            System.err.println("Warning: could not load \"" + string + "\" icon");
            return null;
        }
        return new ImageIcon(uRL);
    }

    private void about() {
        AboutDialog aboutDialog = new AboutDialog(this.fFrame);
        aboutDialog.show();
    }
}

