/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import junit.swingui.StatusLine;
import junit.swingui.TestRunner;

public class CounterPanel
extends JPanel {
    private JTextField fNumberOfErrors;
    private JTextField fNumberOfFailures;
    private JTextField fNumberOfRuns;
    private Icon fFailureIcon = TestRunner.getIconResource(this.getClass(), "icons/failure.gif");
    private Icon fErrorIcon = TestRunner.getIconResource(this.getClass(), "icons/error.gif");
    private int fTotal;

    public CounterPanel() {
        super(new GridBagLayout());
        this.fNumberOfErrors = this.createOutputField(5);
        this.fNumberOfFailures = this.createOutputField(5);
        this.fNumberOfRuns = this.createOutputField(9);
        this.addToGrid(new JLabel("Runs:", 0), 0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0));
        this.addToGrid(this.fNumberOfRuns, 1, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.addToGrid(new JLabel("Errors:", this.fErrorIcon, 2), 2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.fNumberOfErrors, 3, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.addToGrid(new JLabel("Failures:", this.fFailureIcon, 2), 4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.fNumberOfFailures, 5, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
    }

    private JTextField createOutputField(int n) {
        JTextField jTextField = new JTextField("0", n);
        jTextField.setMinimumSize(jTextField.getPreferredSize());
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jTextField.setHorizontalAlignment(2);
        jTextField.setFont(StatusLine.BOLD_FONT);
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        return jTextField;
    }

    public void addToGrid(Component component, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.insets = insets;
        this.add(component, gridBagConstraints);
    }

    public void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fTotal = 0;
    }

    public void setTotal(int n) {
        this.fTotal = n;
    }

    public void setRunValue(int n) {
        this.fNumberOfRuns.setText(Integer.toString(n) + "/" + this.fTotal);
    }

    public void setErrorValue(int n) {
        this.setLabelValue(this.fNumberOfErrors, n);
    }

    public void setFailureValue(int n) {
        this.setLabelValue(this.fNumberOfFailures, n);
    }

    private void setLabelValue(JTextField jTextField, int n) {
        jTextField.setText(Integer.toString(n));
    }
}

