/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.runner.ClassPathTestCollector;
import junit.runner.TestCaseClassLoader;

public class LoadingTestCollector
extends ClassPathTestCollector {
    TestCaseClassLoader fLoader = new TestCaseClassLoader();

    protected boolean isTestClass(String string) {
        try {
            if (string.endsWith(".class")) {
                Class clazz = this.classFromFile(string);
                return clazz != null && this.isTestClass(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    Class classFromFile(String string) throws ClassNotFoundException {
        String string2 = this.classNameFromFile(string);
        if (!this.fLoader.isExcluded(string2)) {
            return this.fLoader.loadClass(string2, false);
        }
        return null;
    }

    boolean isTestClass(Class clazz) {
        if (this.hasSuiteMethod(clazz)) {
            return true;
        }
        return Test.class.isAssignableFrom(clazz) && Modifier.isPublic(clazz.getModifiers()) && this.hasPublicConstructor(clazz);
    }

    boolean hasSuiteMethod(Class clazz) {
        try {
            clazz.getMethod("suite", new Class[0]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    boolean hasPublicConstructor(Class clazz) {
        try {
            TestSuite.getTestConstructor(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }
}

