/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.runner.TestCollector;

public abstract class ClassPathTestCollector
implements TestCollector {
    static final int SUFFIX_LENGTH = ".class".length();

    public Enumeration collectTests() {
        String string = System.getProperty("java.class.path");
        Hashtable hashtable = this.collectFilesInPath(string);
        return hashtable.elements();
    }

    public Hashtable collectFilesInPath(String string) {
        Hashtable hashtable = this.collectFilesInRoots(this.splitClassPath(string));
        return hashtable;
    }

    Hashtable collectFilesInRoots(Vector vector) {
        Hashtable hashtable = new Hashtable(100);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.gatherFiles(new File((String)enumeration.nextElement()), "", hashtable);
        }
        return hashtable;
    }

    void gatherFiles(File file, String string, Hashtable hashtable) {
        File file2 = new File(file, string);
        if (file2.isFile()) {
            if (this.isTestClass(string)) {
                String string2 = this.classNameFromFile(string);
                hashtable.put(string2, string2);
            }
            return;
        }
        String[] stringArray = file2.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.gatherFiles(file, string + File.separatorChar + stringArray[i], hashtable);
            }
        }
    }

    Vector splitClassPath(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    protected boolean isTestClass(String string) {
        return string.endsWith(".class") && string.indexOf(36) < 0 && string.indexOf("Test") > 0;
    }

    protected String classNameFromFile(String string) {
        String string2 = string.substring(0, string.length() - SUFFIX_LENGTH);
        String string3 = string2.replace(File.separatorChar, '.');
        if (string3.startsWith(".")) {
            return string3.substring(1);
        }
        return string3;
    }
}

