/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.xml;

import com.android.ddmlib.Log;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlParser {
    private static final String LOG_TAG = "XmlDefsParser";

    public void parse(InputStream inputStream) throws ParseException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            DefaultHandler defaultHandler = this.createXmlHandler();
            sAXParser.parse(new InputSource(inputStream), defaultHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.e((String)LOG_TAG, (Throwable)parserConfigurationException);
            throw new ParseException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Log.e((String)LOG_TAG, (Throwable)sAXException);
            throw new ParseException(sAXException);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (Throwable)iOException);
            throw new ParseException(iOException);
        }
    }

    protected abstract DefaultHandler createXmlHandler();

    public static class ParseException
    extends Exception {
        public ParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

