/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.util.ClassPathScanner;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLoader {
    private static final String LOG_TAG = "TestLoader";

    public Test loadTests(File file) {
        ClassPathScanner classPathScanner = new ClassPathScanner();
        try {
            Set<String> set = classPathScanner.getClassNamesFromJar(file);
            URI uRI = file.toURI();
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRI.toURL()});
            return this.loadTests(set, uRLClassLoader);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("IOException when loading test classes from jar %s", file.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)iOException);
            return null;
        }
    }

    private Test loadTests(Set<String> set, ClassLoader classLoader) {
        TestSuite testSuite = new TestSuite();
        for (String string : set) {
            try {
                Class<?> clazz = Class.forName(string, true, classLoader);
                if (!TestCase.class.isAssignableFrom(clazz)) continue;
                testSuite.addTestSuite(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return testSuite;
    }
}

