/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.StreamUtil;
import java.util.Arrays;

public class RunUtil
implements IRunUtil {
    private static final String LOG_TAG = "RunUtil";
    private static final int POLL_TIME_INCREASE_FACTOR = 4;
    private static IRunUtil sInstance = null;

    private RunUtil() {
    }

    public static IRunUtil getInstance() {
        if (sInstance == null) {
            sInstance = new RunUtil();
        }
        return sInstance;
    }

    public CommandResult runTimedCmd(long l, final String ... stringArray) {
        final CommandResult commandResult = new CommandResult();
        IRunUtil.IRunnableResult iRunnableResult = new IRunUtil.IRunnableResult(){

            public boolean run() throws Exception {
                String string = Arrays.toString(stringArray);
                Log.v((String)RunUtil.LOG_TAG, (String)String.format("Running %s", string));
                Process process = Runtime.getRuntime().exec(stringArray);
                int n = process.waitFor();
                commandResult.setStdout(StreamUtil.getStringFromStream(process.getInputStream()));
                commandResult.setStderr(StreamUtil.getStringFromStream(process.getErrorStream()));
                if (n == 0) {
                    return true;
                }
                Log.i((String)RunUtil.LOG_TAG, (String)String.format("%s command failed. return code %d", string, n));
                return false;
            }

            public void cancel() {
            }
        };
        CommandStatus commandStatus = this.runTimed(l, iRunnableResult);
        commandResult.setStatus(commandStatus);
        return commandResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandStatus runTimed(long l, IRunUtil.IRunnableResult iRunnableResult) {
        RunnableNotifier runnableNotifier = new RunnableNotifier(iRunnableResult);
        runnableNotifier.start();
        RunnableNotifier runnableNotifier2 = runnableNotifier;
        synchronized (runnableNotifier2) {
            try {
                if (runnableNotifier.getStatus() == CommandStatus.TIMED_OUT) {
                    runnableNotifier.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                Log.i((String)LOG_TAG, (String)"runnable interrupted");
            }
            if (runnableNotifier.getStatus() == CommandStatus.TIMED_OUT || runnableNotifier.getStatus() == CommandStatus.EXCEPTION) {
                runnableNotifier.interrupt();
            }
        }
        return runnableNotifier.getStatus();
    }

    public boolean runTimedRetry(long l, long l2, int n, IRunUtil.IRunnableResult iRunnableResult) {
        for (int i = 0; i < n; ++i) {
            if (this.runTimed(l, iRunnableResult) == CommandStatus.SUCCESS) {
                return true;
            }
            Log.d((String)LOG_TAG, (String)String.format("operation failed, waiting for %d ms", l2));
            this.sleep(l2);
        }
        return false;
    }

    public boolean runFixedTimedRetry(long l, long l2, long l3, IRunUtil.IRunnableResult iRunnableResult) {
        long l4 = System.currentTimeMillis();
        while (System.currentTimeMillis() < l4 + l3) {
            if (this.runTimed(l, iRunnableResult) == CommandStatus.SUCCESS) {
                return true;
            }
            Log.d((String)LOG_TAG, (String)String.format("operation failed, waiting for %d ms", l2));
            this.sleep(l2);
        }
        return false;
    }

    public boolean runEscalatingTimedRetry(long l, long l2, long l3, long l4, IRunUtil.IRunnableResult iRunnableResult) {
        long l5 = l2;
        long l6 = System.currentTimeMillis();
        while (System.currentTimeMillis() < l6 + l4) {
            if (this.runTimed(l, iRunnableResult) == CommandStatus.SUCCESS) {
                return true;
            }
            Log.d((String)LOG_TAG, (String)String.format("operation failed, waiting for %d ms", l5));
            this.sleep(l5);
            if ((l5 *= 4L) <= l3) continue;
            l5 = l3;
        }
        return false;
    }

    public void sleep(long l) {
        if (l <= 0L) {
            return;
        }
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Log.d((String)LOG_TAG, (String)"sleep interrupted");
        }
    }

    private static class RunnableNotifier
    extends Thread {
        private final IRunUtil.IRunnableResult mRunnable;
        private CommandStatus mStatus = CommandStatus.TIMED_OUT;

        RunnableNotifier(IRunUtil.IRunnableResult iRunnableResult) {
            this.mRunnable = iRunnableResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CommandStatus commandStatus;
            try {
                commandStatus = this.mRunnable.run() ? CommandStatus.SUCCESS : CommandStatus.FAILED;
            }
            catch (InterruptedException interruptedException) {
                Log.i((String)RunUtil.LOG_TAG, (String)"runutil interrupted");
                commandStatus = CommandStatus.EXCEPTION;
            }
            catch (Exception exception) {
                Log.e((String)RunUtil.LOG_TAG, (Throwable)exception);
                commandStatus = CommandStatus.EXCEPTION;
            }
            RunnableNotifier runnableNotifier = this;
            synchronized (runnableNotifier) {
                this.mStatus = commandStatus;
                this.notify();
            }
        }

        public void interrupt() {
            this.mRunnable.cancel();
            super.interrupt();
        }

        synchronized CommandStatus getStatus() {
            return this.mStatus;
        }
    }
}

