/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexTrie<V> {
    private V mValue = null;
    private Map<CompPattern, RegexTrie<V>> mChildren = new LinkedHashMap<CompPattern, RegexTrie<V>>();

    public void clear() {
        this.mValue = null;
        for (RegexTrie<V> regexTrie : this.mChildren.values()) {
            regexTrie.clear();
        }
        this.mChildren.clear();
    }

    boolean containsKey(String ... stringArray) {
        return this.retrieve(stringArray) != null;
    }

    V recursivePut(V v, List<CompPattern> list) {
        if (list.isEmpty()) {
            V v2 = this.mValue;
            this.mValue = v;
            return v2;
        }
        CompPattern compPattern = list.get(0);
        List<CompPattern> list2 = list.subList(1, list.size());
        RegexTrie<V> regexTrie = this.mChildren.get(compPattern);
        if (regexTrie == null) {
            regexTrie = new RegexTrie<V>();
            this.mChildren.put(compPattern, regexTrie);
        }
        return regexTrie.recursivePut(v, list2);
    }

    private V validateAndPut(V v, List<CompPattern> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("pattern list must be non-empty.");
        }
        return this.recursivePut(v, list);
    }

    public V put(V v, Pattern ... patternArray) {
        ArrayList<CompPattern> arrayList = new ArrayList<CompPattern>(patternArray.length);
        for (Pattern pattern : patternArray) {
            if (pattern == null) {
                arrayList.add(null);
                break;
            }
            arrayList.add(new CompPattern(pattern));
        }
        return this.validateAndPut(v, arrayList);
    }

    public V put(V v, String ... stringArray) {
        ArrayList<CompPattern> arrayList = new ArrayList<CompPattern>(stringArray.length);
        for (String string : stringArray) {
            if (string == null) {
                arrayList.add(null);
                break;
            }
            Pattern pattern = Pattern.compile(string);
            arrayList.add(new CompPattern(pattern));
        }
        return this.validateAndPut(v, arrayList);
    }

    private static List<String> list(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    V recursiveRetrieve(List<List<String>> list, List<String> list2) {
        if (list2.isEmpty()) {
            return this.mValue;
        }
        boolean bl = false;
        V v = null;
        String string = list2.get(0);
        List<String> list3 = list2.subList(1, list2.size());
        for (Map.Entry<CompPattern, RegexTrie<V>> entry : this.mChildren.entrySet()) {
            CompPattern compPattern = entry.getKey();
            if (compPattern == null) {
                bl = true;
                v = super.getValue();
                continue;
            }
            Matcher matcher = compPattern.matcher(string);
            if (!matcher.matches()) continue;
            if (list != null) {
                ArrayList<String> arrayList = new ArrayList<String>(matcher.groupCount());
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    arrayList.add(matcher.group(i + 1));
                }
                list.add(arrayList);
            }
            return entry.getValue().recursiveRetrieve(list, list3);
        }
        if (bl) {
            for (String string2 : list2) {
                list.add(RegexTrie.list(string2));
            }
            return v;
        }
        return null;
    }

    public V retrieve(String ... stringArray) {
        return this.retrieve((List<List<String>>)null, stringArray);
    }

    public V retrieve(List<List<String>> list, String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("string list must be non-empty");
        }
        List<String> list2 = Arrays.asList(stringArray);
        if (list != null) {
            list.clear();
        }
        return this.recursiveRetrieve(list, list2);
    }

    private V getValue() {
        return this.mValue;
    }

    public String toString() {
        return String.format("{V: %s, C: %s}", this.mValue, this.mChildren);
    }

    static class CompPattern {
        protected final Pattern mPattern;

        CompPattern(Pattern pattern) {
            if (pattern == null) {
                throw new NullPointerException();
            }
            this.mPattern = pattern;
        }

        public boolean equals(Object object) {
            Pattern pattern;
            if (object instanceof Pattern) {
                pattern = (Pattern)object;
            } else if (object instanceof CompPattern) {
                CompPattern compPattern = (CompPattern)object;
                pattern = compPattern.mPattern;
            } else {
                return false;
            }
            return this.mPattern.toString().equals(pattern.toString());
        }

        public int hashCode() {
            return this.mPattern.toString().hashCode();
        }

        public String toString() {
            return String.format("CP(%s)", this.mPattern.toString());
        }

        public Matcher matcher(String string) {
            return this.mPattern.matcher(string);
        }
    }
}

