/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<K, V> {
    private Map<K, Collection<V>> mInternalMap = new HashMap<K, Collection<V>>();

    public void clear() {
        this.mInternalMap.clear();
    }

    public boolean containsKey(K k) {
        return this.mInternalMap.containsKey(k);
    }

    public boolean containsValue(V v) {
        for (Collection<V> collection : this.mInternalMap.values()) {
            if (!collection.contains(v)) continue;
            return true;
        }
        return false;
    }

    public Collection<V> get(K k) {
        return this.mInternalMap.get(k);
    }

    public boolean isEmpty() {
        return this.mInternalMap.isEmpty();
    }

    public Set<K> keySet() {
        return this.mInternalMap.keySet();
    }

    public V put(K k, V v) {
        Collection<V> collection = this.mInternalMap.get(k);
        if (collection == null) {
            collection = new LinkedList<V>();
            this.mInternalMap.put(k, collection);
        }
        collection.add(v);
        return v;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(MultiMap<K, ? extends V> multiMap) {
        for (K k : multiMap.keySet()) {
            for (V v : multiMap.get(k)) {
                this.put(k, v);
            }
        }
    }

    public Collection<V> remove(K k) {
        return this.mInternalMap.remove(k);
    }

    public int size() {
        return this.mInternalMap.size();
    }

    public Collection<V> values() {
        LinkedList<V> linkedList = new LinkedList<V>();
        for (Collection<V> collection : this.mInternalMap.values()) {
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    public Map<String, V> getUniqueMap() {
        HashMap hashMap = new HashMap();
        for (Map.Entry<K, Collection<V>> entry : this.mInternalMap.entrySet()) {
            int n = 1;
            for (V v : entry.getValue()) {
                if (n == 1) {
                    this.addUniqueEntry(hashMap, entry.getKey().toString(), v);
                } else {
                    this.addUniqueEntry(hashMap, String.format("%s%d", entry.getKey(), n), v);
                }
                ++n;
            }
        }
        return hashMap;
    }

    private String addUniqueEntry(Map<String, V> map, String string, V v) {
        if (map.containsKey(string)) {
            return this.addUniqueEntry(map, String.format("%s%s", string, "X"), v);
        }
        map.put(string, v);
        return string;
    }
}

