/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    private static final String LOG_TAG = "FileUtil";
    private static final long MIN_DISK_SPACE_MB = 100L;
    private static final long MIN_DISK_SPACE = 0x6400000L;

    public static boolean setGroupReadWritable(File file) {
        Log.d((String)LOG_TAG, (String)String.format("Attempting to make %s group writable", file.getAbsolutePath()));
        CommandResult commandResult = RunUtil.getInstance().runTimedCmd(10000L, "chmod", "ug+rw", file.getAbsolutePath());
        if (commandResult.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            return true;
        }
        return file.setWritable(true, false) && file.setReadable(true, false);
    }

    public static File createTempDir(String string) throws IOException {
        return FileUtil.createTempDir(string, null);
    }

    public static File createTempDir(String string, File file) throws IOException {
        File file2 = File.createTempFile(string, "", file);
        file2.delete();
        if (!file2.mkdirs()) {
            throw new IOException("unable to create directory");
        }
        return file2;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2);
        FileUtil.verifyDiskSpace(file);
        return file;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        FileUtil.verifyDiskSpace(file2);
        return file2;
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtil.writeToFile(new FileInputStream(file), file2);
    }

    public static void recursiveCopy(File file, File file2) throws IOException {
        for (File file3 : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                if (!file4.mkdir()) {
                    throw new IOException(String.format("Could not create directory %s", file4.getAbsolutePath()));
                }
                FileUtil.recursiveCopy(file3, file4);
                continue;
            }
            if (!file3.isFile()) continue;
            FileUtil.copyFile(file3, file4);
        }
    }

    public static void writeToFile(String string, File file) throws IOException {
        FileUtil.writeToFile(new ByteArrayInputStream(string.getBytes()), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream inputStream, File file) throws IOException {
        IOException iOException3;
        OutputStream outputStream;
        block12: {
            BufferedInputStream bufferedInputStream = null;
            outputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(inputStream);
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n = -1;
                while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                    outputStream.write(n);
                }
                Object var6_5 = null;
                if (bufferedInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var6_6 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException3) {}
        }
    }

    private static void verifyDiskSpace(File file) {
        if (file.getUsableSpace() < 0x6400000L) {
            throw new LowDiskSpaceException(String.format("Available space on %s is less than %s MB", file.getAbsolutePath(), 100L));
        }
    }

    public static void recursiveDelete(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                FileUtil.recursiveDelete(file2);
            }
        }
        file.delete();
    }

    public static void extractZip(ZipFile zipFile, File file) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            File file2 = new File(file, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                file2.mkdirs();
                continue;
            }
            FileUtil.writeToFile(zipFile.getInputStream(zipEntry), file2);
        }
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n);
    }

    public static String getBaseName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareFileContents(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2;
        block8: {
            boolean bl;
            block6: {
                block7: {
                    bufferedInputStream2 = null;
                    bufferedInputStream = null;
                    try {
                        bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file));
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                        boolean bl2 = false;
                        while (!bl2) {
                            int n2;
                            n = bufferedInputStream2.read();
                            if (n != (n2 = bufferedInputStream.read())) {
                                bl = false;
                                Object var9_8 = null;
                                if (bufferedInputStream2 == null) break block6;
                                break block7;
                            }
                            bl2 = n == -1;
                        }
                        n = 1;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (bufferedInputStream2 != null) {
                            bufferedInputStream2.close();
                        }
                        if (bufferedInputStream == null) throw throwable;
                        bufferedInputStream.close();
                        throw throwable;
                    }
                }
                bufferedInputStream2.close();
            }
            if (bufferedInputStream == null) return bl;
            bufferedInputStream.close();
            return bl;
        }
        Object var9_9 = null;
        if (bufferedInputStream2 != null) {
            bufferedInputStream2.close();
        }
        if (bufferedInputStream == null) return n != 0;
        bufferedInputStream.close();
        return n != 0;
    }

    public static File createTempFileForRemote(String string, File file) throws IOException {
        String[] stringArray = string.split("/");
        String string2 = stringArray[stringArray.length - 1];
        String string3 = FileUtil.getBaseName(string2);
        if (string3.length() < 3) {
            string3 = string3 + "XXX";
        }
        String string4 = FileUtil.getExtension(string2);
        File file2 = FileUtil.createTempFile(string3 + "_", string4, file);
        return file2;
    }

    public static class LowDiskSpaceException
    extends FatalHostError {
        LowDiskSpaceException(String string, Throwable throwable) {
            super(string, throwable);
        }

        LowDiskSpaceException(String string) {
            super(string);
        }
    }
}

