/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.ddmlib.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email {
    private static final String LOG_TAG = "Email";
    private static final String mailer = "/usr/bin/mailx";
    private String mSender = null;

    public void setSender(String string) {
        this.mSender = string;
    }

    private static String join(Collection<String> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            stringBuilder.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    Process run(String[] stringArray) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.redirectErrorStream(true);
        return processBuilder.start();
    }

    public void send(Message message) throws IllegalArgumentException, IOException {
        int n;
        if (message.getTo() == null || message.getSubject() == null || message.getBody() == null) {
            throw new IllegalArgumentException("Message has no destination or no subject");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(mailer);
        if (message.getBcc() != null) {
            arrayList.add("-b");
            arrayList.add(Email.join(message.getBcc(), ","));
        }
        if (message.getCc() != null) {
            arrayList.add("-c");
            arrayList.add(Email.join(message.getCc(), ","));
        }
        arrayList.add("-s");
        arrayList.add(message.getSubject());
        arrayList.addAll(message.getTo());
        if (this.mSender != null) {
            arrayList.add("-a");
            arrayList.add(String.format("From: %s", this.mSender));
            arrayList.add("--");
            arrayList.add("-f");
            arrayList.add(this.mSender);
        }
        Log.i((String)LOG_TAG, (String)String.format("About to send email with command: %s", arrayList));
        String[] stringArray = new String[arrayList.size()];
        Process process = this.run(arrayList.toArray(stringArray));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
        bufferedOutputStream.write(message.getBody().getBytes("UTF-8"));
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            n = -12345;
        }
        if (n != 0) {
            int n2;
            Log.e((String)LOG_TAG, (String)String.format("Mailer finished with non-zero return value: %d", n));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            StringBuilder stringBuilder = new StringBuilder();
            while ((n2 = bufferedInputStream.read()) != -1) {
                stringBuilder.append((char)n2);
            }
            Log.e((String)LOG_TAG, (String)("Mailer output was: " + stringBuilder.toString()));
        } else {
            Log.v((String)LOG_TAG, (String)"Mailer returned successfully.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Message {
        private Collection<String> mToAddrs = null;
        private Collection<String> mCcAddrs = null;
        private Collection<String> mBccAddrs = null;
        private String mSubject = null;
        private String mBody = null;

        public Message() {
        }

        public Message(String string, String string2, String string3) {
            this.addTo(string);
            this.setSubject(string2);
            this.setBody(string3);
        }

        public void addTo(String string) {
            if (this.mToAddrs == null) {
                this.mToAddrs = new ArrayList<String>();
            }
            this.mToAddrs.add(string);
        }

        public void addCc(String string) {
            if (this.mCcAddrs == null) {
                this.mCcAddrs = new ArrayList<String>();
            }
            this.mCcAddrs.add(string);
        }

        public void addBcc(String string) {
            if (this.mBccAddrs == null) {
                this.mBccAddrs = new ArrayList<String>();
            }
            this.mBccAddrs.add(string);
        }

        public void setSubject(String string) {
            this.mSubject = string;
        }

        public void setBody(String string) {
            this.mBody = string;
        }

        public Collection<String> getTo() {
            return this.mToAddrs;
        }

        public Collection<String> getCc() {
            return this.mCcAddrs;
        }

        public Collection<String> getBcc() {
            return this.mBccAddrs;
        }

        public String getSubject() {
            return this.mSubject;
        }

        public String getBody() {
            return this.mBody;
        }
    }
}

