/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionPriorityBlockingQueue<T>
implements Iterable<T> {
    private final LinkedList<T> mList;
    private final ReentrantLock mLock = new ReentrantLock(true);
    private final List<ConditionMatcherPair<T>> mWaitingMatcherList;
    private final Comparator<T> mComparator;

    public ConditionPriorityBlockingQueue() {
        this(null);
    }

    public ConditionPriorityBlockingQueue(Comparator<T> comparator) {
        this.mComparator = comparator;
        this.mList = new LinkedList();
        this.mWaitingMatcherList = new LinkedList<ConditionMatcherPair<T>>();
    }

    public T poll() {
        return this.poll(new AlwaysMatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(IMatcher<T> iMatcher) {
        Object e;
        this.mLock.lock();
        try {
            T t = null;
            ListIterator listIterator = this.mList.listIterator();
            while (listIterator.hasNext()) {
                e = listIterator.next();
                if (!iMatcher.matches(e) || this.compareObjects(e, t) >= 0) continue;
                t = (T)e;
            }
            if (t != null) {
                this.mList.remove(t);
            }
            e = t;
            Object var6_5 = null;
            this.mLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mLock.unlock();
            throw throwable;
        }
        return (T)e;
    }

    public T poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.poll(l, timeUnit, new AlwaysMatch());
    }

    public T poll(long l, TimeUnit timeUnit, IMatcher<T> iMatcher) throws InterruptedException {
        Long l2 = timeUnit.toNanos(l);
        return this.blockingPoll(l2, iMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T blockingPoll(Long l, IMatcher<T> iMatcher) throws InterruptedException {
        T t;
        this.mLock.lockInterruptibly();
        try {
            T t2 = null;
            Condition condition = this.mLock.newCondition();
            ConditionMatcherPair<T> conditionMatcherPair = new ConditionMatcherPair<T>(iMatcher, condition);
            this.mWaitingMatcherList.add(conditionMatcherPair);
            try {
                while (true) {
                    T t3 = this.poll(iMatcher);
                    t2 = t3;
                    if (t3 != null || l != null && l <= 0L) break;
                    if (l != null) {
                        l = condition.awaitNanos(l);
                        continue;
                    }
                    condition.await();
                }
                Object var8_6 = null;
                this.mWaitingMatcherList.remove(conditionMatcherPair);
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.mWaitingMatcherList.remove(conditionMatcherPair);
                throw throwable;
            }
            assert (t2 != null);
            t = t2;
            Object var10_11 = null;
            this.mLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.mLock.unlock();
            throw throwable;
        }
        return t;
    }

    private int compareObjects(T t, T t2) {
        if (t2 == null) {
            return -1;
        }
        if (this.mComparator == null) {
            return 1;
        }
        return this.mComparator.compare(t, t2);
    }

    public T take() throws InterruptedException {
        return this.take(new AlwaysMatch());
    }

    public T take(IMatcher<T> iMatcher) throws InterruptedException {
        return this.blockingPoll(null, iMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        this.mLock.lock();
        try {
            boolean bl = this.mList.add(t);
            assert (bl);
            for (ConditionMatcherPair<T> conditionMatcherPair : this.mWaitingMatcherList) {
                if (!((ConditionMatcherPair)conditionMatcherPair).mMatcher.matches(t)) continue;
                ((ConditionMatcherPair)conditionMatcherPair).mCondition.signal();
                break;
            }
            boolean bl2 = true;
            Object var6_6 = null;
            this.mLock.unlock();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.mLock.unlock();
            throw throwable;
        }
    }

    public void clear() {
        this.mList.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.mList.iterator();
    }

    public boolean contains(T t) {
        return this.mList.contains(t);
    }

    public int size() {
        return this.mList.size();
    }

    public boolean remove(T t) {
        return this.mList.remove(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConditionMatcherPair<T> {
        private final IMatcher<T> mMatcher;
        private final Condition mCondition;

        ConditionMatcherPair(IMatcher<T> iMatcher, Condition condition) {
            this.mMatcher = iMatcher;
            this.mCondition = condition;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlwaysMatch<T>
    implements IMatcher<T> {
        @Override
        public boolean matches(T t) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IMatcher<T> {
        public boolean matches(T var1);
    }
}

