/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner {
    private static final String DOT_CLASS = ".class";
    private String[] mClassPath = ClassPathScanner.getClassPath();

    ClassPathScanner() {
    }

    public Set<String> getClassNamesFromJar(File file) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string = ((ZipEntry)enumeration.nextElement()).getName();
            if (!string.endsWith(DOT_CLASS)) continue;
            String string2 = string.substring(0, string.length() - DOT_CLASS.length());
            string2 = string2.replace('/', '.');
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static String[] getClassPath() {
        String string = System.getProperty("java.class.path");
        return string.split(Pattern.quote(File.pathSeparator));
    }
}

