/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import java.util.Arrays;

public class ByteArrayList {
    private byte[] mStorage = new byte[this.mMaxBytes];
    private int mMaxBytes = 128;
    private int mCurBytes = 0;
    private float mGrowthFactor = 2.0f;

    public ByteArrayList() {
    }

    public ByteArrayList(int n) {
        this();
        this.setSize(n);
    }

    public ByteArrayList(int n, float f) {
        this(n);
        if (f < 1.1f) {
            throw new IllegalArgumentException("Growth factor must be at least 1.1");
        }
        this.mGrowthFactor = f;
    }

    public void trimToSize() {
        this.setSize(this.size());
    }

    public void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Minimum capacity must be non-negative");
        }
        if (n <= this.mMaxBytes) {
            return;
        }
        int n2 = this.mMaxBytes;
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = (int)Math.ceil((float)n / this.mGrowthFactor / (float)n2);
        float f = (float)n2 * this.mGrowthFactor * (float)n3;
        this.setSize((int)Math.ceil(f));
    }

    void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("New size must be non-negative");
        }
        if (n < this.mCurBytes) {
            this.mCurBytes = n;
        }
        this.mMaxBytes = n;
        byte[] byArray = new byte[n];
        System.arraycopy(this.mStorage, 0, byArray, 0, this.mCurBytes);
        this.mStorage = byArray;
    }

    public byte[] getContents() {
        byte[] byArray = new byte[this.mCurBytes];
        System.arraycopy(this.mStorage, 0, byArray, 0, this.mCurBytes);
        return byArray;
    }

    public boolean add(byte by) {
        this.ensureCapacity(this.mCurBytes + 1);
        this.mStorage[this.mCurBytes] = by;
        ++this.mCurBytes;
        return true;
    }

    public boolean addAll(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        return this.addAll(byArray, 0, byArray.length);
    }

    public boolean addAll(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.mCurBytes + n2);
        System.arraycopy(byArray, n, this.mStorage, this.mCurBytes, n2);
        this.mCurBytes += n2;
        return true;
    }

    public boolean addall(ByteArrayList byteArrayList) {
        if (byteArrayList == null) {
            throw new NullPointerException();
        }
        return this.addAll(byteArrayList.getContents());
    }

    public void clear() {
        this.mCurBytes = 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteArrayList)) {
            return false;
        }
        ByteArrayList byteArrayList = (ByteArrayList)object;
        if (byteArrayList.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (byteArrayList.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mStorage);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public byte get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.mStorage[n];
    }

    public byte set(int n, byte by) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        byte by2 = this.mStorage[n];
        this.mStorage[n] = by;
        return by2;
    }

    public int size() {
        return this.mCurBytes;
    }

    int getMaxSize() {
        return this.mMaxBytes;
    }
}

