/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.testdefs;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.testtype.testdefs.InstrumentationTestDef;
import com.android.tradefed.testtype.testdefs.XmlDefsParser;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDefsTest
implements IDeviceTest,
IResumableTest,
IShardableTest {
    private static final String LOG_TAG = "XmlDefsTest";
    public static final String COVERAGE_TARGET_KEY = "coverage_target";
    private ITestDevice mDevice;
    @Option(name="timeout", description="Fail any test that takes longer than the specified number of milliseconds. Default 10 min.")
    private int mTestTimeout = 600000;
    @Option(name="size", description="Restrict tests to a specific test size")
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete. Default true")
    private boolean mIsRerunMode = true;
    @Option(name="resume", description="Schedule unexecuted tests for resumption on another device if first device becomes unavailable. Default false")
    private boolean mIsResumeMode = false;
    @Option(name="local-file-path", description="local file path to test_defs.xml file to run")
    private Collection<File> mLocalFiles = new ArrayList<File>();
    @Option(name="device-file-path", description="file path on device to test_defs.xml file to run")
    private Collection<String> mRemotePaths = new ArrayList<String>();
    @Option(name="send-coverage", description="Send coverage target info to test listeners. Default true.")
    private boolean mSendCoverage = true;
    @Option(name="num-shards", description="Shard this test into given number of separately runnable chunks")
    private int mNumShards = 0;
    private List<InstrumentationTest> mTests = null;

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    void addRemoteFilePath(String string) {
        this.mRemotePaths.add(string);
    }

    void addLocalFilePath(File file) {
        this.mLocalFiles.add(file);
    }

    void setSendCoverage(boolean bl) {
        this.mSendCoverage = bl;
    }

    void setNumShards(int n) {
        this.mNumShards = n;
    }

    List<InstrumentationTest> getTests() {
        return this.mTests;
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        this.buildTests();
        this.doRun(iTestInvocationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTests() throws DeviceNotAvailableException {
        if (this.mTests == null) {
            if (this.mLocalFiles.isEmpty() && this.mRemotePaths.isEmpty()) {
                throw new IllegalArgumentException("No test definition files (local-file-path or device-file-path) have been provided.");
            }
            XmlDefsParser xmlDefsParser = this.createParser();
            for (File object : this.mLocalFiles) {
                this.parseFile(xmlDefsParser, object);
            }
            for (File file : this.getRemoteFile(this.mRemotePaths)) {
                Object var5_8;
                try {
                    this.parseFile(xmlDefsParser, file);
                    var5_8 = null;
                    file.delete();
                }
                catch (Throwable throwable) {
                    var5_8 = null;
                    file.delete();
                    throw throwable;
                }
                {
                }
            }
            this.mTests = new LinkedList<InstrumentationTest>();
            for (InstrumentationTestDef instrumentationTestDef : xmlDefsParser.getTestDefs()) {
                if (!instrumentationTestDef.isContinuous()) continue;
                InstrumentationTest instrumentationTest = this.createInstrumentationTest();
                instrumentationTest.setDevice(this.getDevice());
                instrumentationTest.setPackageName(instrumentationTestDef.getPackage());
                if (instrumentationTestDef.getRunner() != null) {
                    instrumentationTest.setRunnerName(instrumentationTestDef.getRunner());
                }
                if (instrumentationTestDef.getClassName() != null) {
                    instrumentationTest.setClassName(instrumentationTestDef.getClassName());
                }
                instrumentationTest.setRerunMode(this.mIsRerunMode);
                instrumentationTest.setResumeMode(this.mIsResumeMode);
                instrumentationTest.setTestSize(this.getTestSize());
                instrumentationTest.setTestTimeout(this.getTestTimeout());
                instrumentationTest.setCoverageTarget(instrumentationTestDef.getCoverageTarget());
                this.mTests.add(instrumentationTest);
            }
        }
    }

    private void parseFile(XmlDefsParser xmlDefsParser, File file) {
        try {
            Log.i((String)LOG_TAG, (String)String.format("Parsing test def file %s", file.getAbsolutePath()));
            xmlDefsParser.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find test def file %s", file.getAbsolutePath()));
        }
        catch (AbstractXmlParser.ParseException parseException) {
            Log.e((String)LOG_TAG, (String)String.format("Could not parse test def file %s: %s", file.getAbsolutePath(), parseException.getMessage()));
        }
    }

    private void doRun(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        while (!this.mTests.isEmpty()) {
            InstrumentationTest instrumentationTest = this.mTests.get(0);
            Log.d((String)LOG_TAG, (String)String.format("Running test %s on %s", instrumentationTest.getPackageName(), this.getDevice().getSerialNumber()));
            instrumentationTest.setDevice(this.getDevice());
            instrumentationTest.run(iTestInvocationListener);
            if (this.mSendCoverage && instrumentationTest.getCoverageTarget() != null) {
                this.sendCoverage(instrumentationTest.getPackageName(), instrumentationTest.getCoverageTarget(), iTestInvocationListener);
            }
            this.mTests.remove(0);
        }
    }

    private void sendCoverage(String string, String string2, ITestInvocationListener iTestInvocationListener) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(COVERAGE_TARGET_KEY, string2);
        iTestInvocationListener.testRunStarted(string, 0);
        iTestInvocationListener.testRunEnded(0L, hashMap);
    }

    private Collection<File> getRemoteFile(Collection<String> collection) throws DeviceNotAvailableException {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.getDevice() == null) {
            Log.d((String)LOG_TAG, (String)"Device not set, skipping collection of remote file");
            return arrayList;
        }
        for (String string : collection) {
            try {
                File file = FileUtil.createTempFile("test_defs_", ".xml");
                this.getDevice().pullFile(string, file);
                arrayList.add(file);
            }
            catch (IOException iOException) {
                Log.e((String)LOG_TAG, (String)"Failed to create temp file");
                Log.e((String)LOG_TAG, (Throwable)iOException);
            }
        }
        return arrayList;
    }

    int getTestTimeout() {
        return this.mTestTimeout;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    XmlDefsParser createParser() {
        return new XmlDefsParser();
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }

    @Override
    public boolean isResumable() {
        if (this.mTests == null) {
            return false;
        }
        return this.mIsResumeMode;
    }

    @Override
    public Collection<IRemoteTest> split() {
        XmlDefsTest xmlDefsTest;
        if (this.mLocalFiles.isEmpty()) {
            Log.w((String)LOG_TAG, (String)"sharding is only supported if local xml files have been specified");
            return null;
        }
        if (this.mNumShards <= 1) {
            return null;
        }
        try {
            this.buildTests();
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            // empty catch block
        }
        if (this.mTests.size() <= 1) {
            Log.w((String)LOG_TAG, (String)"no tests to shard!");
            return null;
        }
        LinkedList<IRemoteTest> linkedList = new LinkedList<IRemoteTest>();
        for (int i = 0; i < this.mNumShards && i < this.mTests.size(); ++i) {
            xmlDefsTest = new XmlDefsTest();
            xmlDefsTest.mTests = new LinkedList<InstrumentationTest>();
            linkedList.add(xmlDefsTest);
        }
        while (!this.mTests.isEmpty()) {
            InstrumentationTest instrumentationTest = this.mTests.remove(0);
            xmlDefsTest = (XmlDefsTest)linkedList.poll();
            xmlDefsTest.mTests.add(instrumentationTest);
            linkedList.add(xmlDefsTest);
        }
        return linkedList;
    }
}

