/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OtaStabilityTest
implements IDeviceTest,
IBuildReceiver,
IConfigurationReceiver,
IShardableTest {
    private static final String LOG_TAG = "OtaStabilityTest";
    private IBuildInfo mDeviceBuild;
    private IConfiguration mConfiguration;
    private ITestDevice mDevice;
    @Option(name="run-name", description="The name of the ota stability test run. Used to report metrics")
    private String mRunName = "ota-stability";
    @Option(name="iterations", description="Number of ota stability 'flash + wait for ota' iterations to run")
    private int mIterations = 20;
    @Option(name="wait-recovery-time", description="Number of minutes to wait for device to begin installing ota. Default 15 min")
    private int mWaitRecoveryTime = 15;
    @Option(name="wait-install-time", description="Number of minutes to wait for device to be online after beginning ota installation. Default 10 min")
    private int mWaitInstallTime = 10;
    @Option(name="shards", description="Optional number of shards to split test into. Iterations will be split evenly among shards.")
    private int mShards = 1;

    @Override
    public void setConfiguration(IConfiguration iConfiguration) {
        this.mConfiguration = iConfiguration;
    }

    @Override
    public void setBuild(IBuildInfo iBuildInfo) {
        this.mDeviceBuild = iBuildInfo;
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    void setWaitRecoveryTime(int n) {
        this.mWaitRecoveryTime = n;
    }

    void setWaitInstallTime(int n) {
        this.mWaitInstallTime = n;
    }

    void setRunName(String string) {
        this.mRunName = string;
    }

    public int getIterations() {
        return this.mIterations;
    }

    void setIterations(int n) {
        this.mIterations = n;
    }

    void setShards(int n) {
        this.mShards = n;
    }

    @Override
    public Collection<IRemoteTest> split() {
        if (this.mShards <= 1) {
            return null;
        }
        ArrayList<IRemoteTest> arrayList = new ArrayList<IRemoteTest>(this.mShards);
        int n = this.mIterations;
        for (int i = this.mShards; i > 0; --i) {
            OtaStabilityTest otaStabilityTest = new OtaStabilityTest();
            otaStabilityTest.setRunName(this.mRunName);
            otaStabilityTest.setWaitInstallTime(this.mWaitInstallTime);
            otaStabilityTest.setWaitRecoveryTime(this.mWaitRecoveryTime);
            int n2 = Math.round(n / i);
            if (n2 <= 0) continue;
            otaStabilityTest.setIterations(n2);
            n -= n2;
            arrayList.add(otaStabilityTest);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        HashMap<String, String> hashMap;
        this.checkFields();
        long l = System.currentTimeMillis();
        iTestInvocationListener.testRunStarted(this.mRunName, 0);
        int n = 0;
        try {
            try {
                this.waitForOta(iTestInvocationListener);
                for (n = 1; n < this.mIterations; ++n) {
                    this.flashDevice();
                    int n2 = this.waitForOta(iTestInvocationListener);
                    Log.i((String)LOG_TAG, (String)String.format("Device %s successfully OTA-ed to build %d. Iteration: %d", this.mDevice.getSerialNumber(), n2, n));
                }
                Object var7_9 = null;
                hashMap = new HashMap<String, String>(1);
                hashMap.put("iterations", Integer.toString(n));
            }
            catch (AssertionFailedError assertionFailedError) {
                Log.e((String)LOG_TAG, (Throwable)assertionFailedError);
                Object var7_10 = null;
                HashMap<String, String> hashMap3 = new HashMap<String, String>(1);
                hashMap3.put("iterations", Integer.toString(n));
                long l4 = System.currentTimeMillis() - l;
                iTestInvocationListener.testRunEnded(l4, hashMap3);
                return;
            }
            catch (TargetSetupError targetSetupError) {
                Log.e((String)LOG_TAG, (Throwable)targetSetupError);
                Object var7_11 = null;
                HashMap<String, String> hashMap4 = new HashMap<String, String>(1);
                hashMap4.put("iterations", Integer.toString(n));
                long l5 = System.currentTimeMillis() - l;
                iTestInvocationListener.testRunEnded(l5, hashMap4);
                return;
            }
            catch (BuildError buildError) {
                Log.e((String)LOG_TAG, (Throwable)buildError);
                Object var7_12 = null;
                HashMap<String, String> hashMap5 = new HashMap<String, String>(1);
                hashMap5.put("iterations", Integer.toString(n));
                long l6 = System.currentTimeMillis() - l;
                iTestInvocationListener.testRunEnded(l6, hashMap5);
                return;
            }
            catch (ConfigurationException configurationException) {
                Log.e((String)LOG_TAG, (Throwable)configurationException);
                Object var7_13 = null;
                HashMap<String, String> hashMap6 = new HashMap<String, String>(1);
                hashMap6.put("iterations", Integer.toString(n));
                long l7 = System.currentTimeMillis() - l;
                iTestInvocationListener.testRunEnded(l7, hashMap6);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            HashMap<String, String> hashMap2 = new HashMap<String, String>(1);
            hashMap2.put("iterations", Integer.toString(n));
            long l2 = System.currentTimeMillis() - l;
            iTestInvocationListener.testRunEnded(l2, hashMap2);
            throw throwable;
        }
        long l3 = System.currentTimeMillis() - l;
        iTestInvocationListener.testRunEnded(l3, hashMap);
    }

    private void flashDevice() throws TargetSetupError, BuildError, DeviceNotAvailableException, ConfigurationException {
        for (ITargetPreparer iTargetPreparer : this.mConfiguration.getTargetPreparers()) {
            iTargetPreparer.setUp(this.mDevice, this.mDeviceBuild);
        }
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    private int waitForOta(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException, AssertionFailedError {
        int n = this.mDevice.getBuildId();
        Assert.assertEquals(String.format("device %s does not have expected build id on boot.", this.mDevice.getSerialNumber()), n, this.mDeviceBuild.getBuildId());
        this.getRunUtil().sleep(5000L);
        this.mDevice.executeShellCommand("am broadcast -a android.server.checkin.CHECKIN");
        Assert.assertTrue(String.format("Device %s did not enter recovery after %d min.", this.mDevice.getSerialNumber(), this.mWaitRecoveryTime), this.mDevice.waitForDeviceInRecovery(this.mWaitRecoveryTime * 60 * 1000));
        try {
            this.mDevice.waitForDeviceOnline(this.mWaitInstallTime * 60 * 1000);
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            Log.e((String)LOG_TAG, (String)String.format("Device %s did not come back online after leaving recovery", this.mDevice.getSerialNumber()));
            this.sendRecoveryLog(iTestInvocationListener);
            throw deviceNotAvailableException;
        }
        try {
            this.mDevice.waitForDeviceAvailable();
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            Log.e((String)LOG_TAG, (String)String.format("Device %s did not boot up successfully after leaving recovery/installing OTA", this.mDevice.getSerialNumber()));
            throw deviceNotAvailableException;
        }
        n = this.mDevice.getBuildId();
        Assert.assertTrue(String.format("Device %s build id did not change after leaving recovery", this.mDevice.getSerialNumber()), n != this.mDeviceBuild.getBuildId());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendRecoveryLog(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        InputStreamSource inputStreamSource;
        block8: {
            File file = null;
            inputStreamSource = null;
            try {
                try {
                    file = FileUtil.createTempFile("recovery", "log");
                    boolean bl = this.mDevice.pullFile("/tmp/recovery.log", file);
                    if (bl) {
                        inputStreamSource = new SnapshotInputStreamSource(new FileInputStream(file));
                        iTestInvocationListener.testLog("recovery_log", LogDataType.TEXT, inputStreamSource);
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)String.format("Failed to get recovery log from device %s", this.mDevice.getSerialNumber()));
                    Log.e((String)LOG_TAG, (Throwable)iOException);
                    Object var6_7 = null;
                    if (file != null) {
                        file.delete();
                    }
                    if (inputStreamSource == null) return;
                    inputStreamSource.cancel();
                    return;
                }
                Object var6_6 = null;
                if (file == null) break block8;
                file.delete();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (file != null) {
                    file.delete();
                }
                if (inputStreamSource == null) throw throwable;
                inputStreamSource.cancel();
                throw throwable;
            }
        }
        if (inputStreamSource == null) return;
        inputStreamSource.cancel();
    }

    private void checkFields() {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("missing device");
        }
        if (this.mConfiguration == null) {
            throw new IllegalArgumentException("missing configuration");
        }
        if (this.mDeviceBuild == null) {
            throw new IllegalArgumentException("missing build info");
        }
    }
}

