/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeStressTestParser
extends MultiLineReceiver {
    private static final String LOG_TAG = "NativeStressTestParser";
    private static final Pattern ITERATION_COMPLETE_PATTERN = Pattern.compile("^====\\s*Completed\\s*pass:\\s*(\\d+)");
    private final String mTestRunName;
    private boolean mIsCanceled = false;
    private int mTotalIterations = 0;

    public NativeStressTestParser(String string) {
        this.mTestRunName = string;
    }

    public void processNewLines(String[] stringArray) {
        for (String string : stringArray) {
            this.parseLine(string);
        }
    }

    private void parseLine(String string) {
        Matcher matcher = ITERATION_COMPLETE_PATTERN.matcher(string);
        if (matcher.find()) {
            this.parseIterationValue(string, matcher.group(1));
        }
    }

    private void parseIterationValue(String string, String string2) {
        try {
            int n = Integer.parseInt(string2);
            Log.i((String)LOG_TAG, (String)String.format("%s: pass %d", this.mTestRunName, n));
            ++this.mTotalIterations;
        }
        catch (NumberFormatException numberFormatException) {
            Log.e((String)LOG_TAG, (String)String.format("Unexpected iteration content %s", string));
        }
    }

    public boolean isCancelled() {
        return this.mIsCanceled;
    }

    public String getRunName() {
        return this.mTestRunName;
    }

    public int getIterationsCompleted() {
        return this.mTotalIterations;
    }
}

