/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.NativeStressTestParser;
import java.util.HashMap;

public class NativeStressTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "NativeStressTest";
    static final String DEFAULT_TEST_PATH = "data/nativestresstest";
    static final String AVG_ITERATION_TIME_KEY = "avg-iteration-time";
    static final String ITERATION_KEY = "iterations";
    private ITestDevice mDevice = null;
    @Option(name="native-stress-device-path", description="The path on the device where native stress tests are located.")
    private String mDeviceTestPath = "data/nativestresstest";
    @Option(name="stress-module-name", description="The name of the native test module to run. If not specified all tests in --native-stress-device-path will be run")
    private String mTestModule = null;
    @Option(name="iterations", description="The number of stress test iterations per run.")
    private int mNumIterations = -1;
    @Option(name="runs", description="The number of stress test runs to perform. Default 1.")
    private int mNumRuns = 1;
    @Option(name="max-iteration-time", description="The maximum time to allow for one stress test iteration in ms. Default is 5 min.")
    private int mMaxIterationTime = 300000;

    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String string) {
        this.mTestModule = string;
    }

    public String getModuleName(String string) {
        return this.mTestModule;
    }

    void setNumIterations(int n) {
        this.mNumIterations = n;
    }

    void setNumRuns(int n) {
        this.mNumRuns = n;
    }

    private String getTestPath() {
        StringBuilder stringBuilder = new StringBuilder(this.mDeviceTestPath);
        if (this.mTestModule != null) {
            stringBuilder.append("/");
            stringBuilder.append(this.mTestModule);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAllTestsInSubdirectory(IFileEntry iFileEntry, ITestDevice iTestDevice, ITestRunListener iTestRunListener) throws DeviceNotAvailableException {
        if (iFileEntry.isDirectory()) {
            for (IFileEntry iFileEntry2 : iFileEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(iFileEntry2, iTestDevice, iTestRunListener);
            }
        } else {
            NativeStressTestParser nativeStressTestParser = this.createResultParser(iFileEntry.getName());
            String string = iFileEntry.getFullEscapedPath();
            Log.i((String)LOG_TAG, (String)String.format("Running native stress test %s on %s", string, this.mDevice.getSerialNumber()));
            iTestDevice.executeShellCommand(String.format("chmod 755 %s", string));
            int n = 0;
            int n2 = this.mNumIterations - 1;
            long l = System.currentTimeMillis();
            iTestRunListener.testRunStarted(nativeStressTestParser.getRunName(), 0);
            try {
                for (int i = 0; i < this.mNumRuns; ++i) {
                    Log.i((String)LOG_TAG, (String)String.format("Running %s for %d iterations", iFileEntry.getName(), this.mNumIterations));
                    iTestDevice.executeShellCommand(String.format("%s -s %d -e %d", string, n, n2), (IShellOutputReceiver)nativeStressTestParser, this.mMaxIterationTime, 0);
                    n += this.mNumIterations;
                    n2 += this.mNumIterations;
                }
                Object var12_12 = null;
                this.reportTestCompleted(l, iTestRunListener, nativeStressTestParser);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.reportTestCompleted(l, iTestRunListener, nativeStressTestParser);
                throw throwable;
            }
        }
    }

    private void reportTestCompleted(long l, ITestRunListener iTestRunListener, NativeStressTestParser nativeStressTestParser) {
        long l2 = System.currentTimeMillis() - l;
        int n = nativeStressTestParser.getIterationsCompleted();
        float f = n > 0 ? (float)(l2 / (long)n) : 0.0f;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        Log.i((String)LOG_TAG, (String)String.format("Stress test %s is finished. Num iterations %d, avg time %f ms", nativeStressTestParser.getRunName(), n, Float.valueOf(f)));
        hashMap.put(ITERATION_KEY, Integer.toString(n));
        hashMap.put(AVG_ITERATION_TIME_KEY, Float.toString(f));
        iTestRunListener.testRunEnded(l2, hashMap);
    }

    NativeStressTestParser createResultParser(String string) {
        return new NativeStressTestParser(string);
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mNumIterations <= 0) {
            throw new IllegalArgumentException("number of iterations has not been set");
        }
        String string = this.getTestPath();
        IFileEntry iFileEntry = this.mDevice.getFileEntry(string);
        if (iFileEntry == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find native stress test directory %s in %s!", string, this.mDevice.getSerialNumber()));
            return;
        }
        this.doRunAllTestsInSubdirectory(iFileEntry, this.mDevice, iTestInvocationListener);
    }
}

