/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeBenchmarkTestParser
extends MultiLineReceiver {
    private static final String LOG_TAG = "NativeBenchmarkTestParser";
    private static final String FLOAT_STRING = "\\s*(.*)\\s*";
    private static final String COMPLETE_STRING = String.format("Time per iteration min:%savg:%smax:%s", "\\s*(.*)\\s*", "\\s*(.*)\\s*", "\\s*(.*)\\s*");
    private static final Pattern COMPLETE_PATTERN = Pattern.compile(COMPLETE_STRING);
    private final String mTestRunName;
    private boolean mIsCanceled = false;
    private double mMinOpTime = 0.0;
    private double mAvgOpTime = 0.0;
    private double mMaxOpTime = 0.0;

    public NativeBenchmarkTestParser(String string) {
        this.mTestRunName = string;
    }

    public void processNewLines(String[] stringArray) {
        for (String string : stringArray) {
            this.parseLine(string);
        }
    }

    private void parseLine(String string) {
        Log.d((String)LOG_TAG, (String)string);
        Matcher matcher = COMPLETE_PATTERN.matcher(string);
        if (matcher.find()) {
            Log.i((String)LOG_TAG, (String)String.format("Found result for benchmark %s: %s", this.getRunName(), string));
            this.mMinOpTime = this.parseDoubleValue(string, matcher.group(1));
            this.mAvgOpTime = this.parseDoubleValue(string, matcher.group(2));
            this.mMaxOpTime = this.parseDoubleValue(string, matcher.group(3));
        }
    }

    private double parseDoubleValue(String string, String string2) {
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Log.w((String)LOG_TAG, (String)String.format("Value was not a double (%s), trying for scientfic", string));
            DecimalFormat decimalFormat = new DecimalFormat("0.0E0");
            try {
                Number number = decimalFormat.parse(string2);
                return number.doubleValue();
            }
            catch (ParseException parseException) {
                Log.e((String)LOG_TAG, (String)String.format("Could not parse double value in (%s)", string));
                return 0.0;
            }
        }
    }

    public boolean isCancelled() {
        return this.mIsCanceled;
    }

    public String getRunName() {
        return this.mTestRunName;
    }

    public double getAvgOperationTime() {
        return this.mAvgOpTime;
    }

    public double getMinOperationTime() {
        return this.mMinOpTime;
    }

    public double getMaxOperationTime() {
        return this.mMaxOpTime;
    }
}

