/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.NativeBenchmarkTestParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeBenchmarkTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "NativeStressTest";
    static final String DEFAULT_TEST_PATH = "data/nativebenchmark";
    static final String AVG_OP_TIME_KEY_PREFIX = "avg-operation-time";
    static final String ITERATION_KEY = "iterations";
    private ITestDevice mDevice = null;
    @Option(name="native-benchmark-device-path", description="The path on the device where native stress tests are located.")
    private String mDeviceTestPath = "data/nativebenchmark";
    @Option(name="benchmark-module-name", description="The name of the native benchmark test module to run. If not specified all tests in --native-benchmark-device-path will be run")
    private String mTestModule = null;
    @Option(name="benchmark-run-name", description="Optional name to pass to test reporters. If unspecified, will use--benchmark-module-name")
    private String mReportRunName = null;
    @Option(name="iterations", description="The number of benchmark test iterations per run.")
    private int mNumIterations = 1000;
    @Option(name="delay-per-run", description="The delay between each benchmark iteration, in micro seconds.Multiple values may be given to specify multiple runs with different delay values.")
    private Collection<Integer> mDelays = new ArrayList<Integer>();
    @Option(name="max-run-time", description="The maximum time to allow for one benchmark run in ms. Default is 5 min.")
    private int mMaxRunTime = 300000;
    @Option(name="server-cpu", description="Optionally specify a server cpu. Default 1")
    private int mServerCpu = 1;
    @Option(name="client-cpu", description="Optionally specify a client cpu. Default 1")
    private int mClientCpu = 1;
    @Option(name="max-cpu-freq", description="Flag to force device cpu to run at maximum frequency. Default false")
    private boolean mMaxCpuFreq = false;

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String string) {
        this.mTestModule = string;
    }

    public String getModuleName(String string) {
        return this.mTestModule;
    }

    void setNumIterations(int n) {
        this.mNumIterations = n;
    }

    void addDelaysPerRun(Collection<Integer> collection) {
        this.mDelays.addAll(collection);
    }

    private String getTestPath() {
        StringBuilder stringBuilder = new StringBuilder(this.mDeviceTestPath);
        if (this.mTestModule != null) {
            stringBuilder.append("/");
            stringBuilder.append(this.mTestModule);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAllTestsInSubdirectory(IFileEntry iFileEntry, ITestDevice iTestDevice, ITestRunListener iTestRunListener) throws DeviceNotAvailableException {
        if (iFileEntry.isDirectory()) {
            for (IFileEntry iFileEntry2 : iFileEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(iFileEntry2, iTestDevice, iTestRunListener);
            }
        } else {
            String string = this.mReportRunName == null ? iFileEntry.getName() : this.mReportRunName;
            String string2 = iFileEntry.getFullEscapedPath();
            if (this.mDelays.size() == 0) {
                this.mDelays.add(0);
            }
            iTestDevice.executeShellCommand(String.format("chmod 755 %s", string2));
            long l = System.currentTimeMillis();
            iTestRunListener.testRunStarted(string, 0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(ITERATION_KEY, Integer.toString(this.mNumIterations));
            try {
                for (Integer n : this.mDelays) {
                    NativeBenchmarkTestParser nativeBenchmarkTestParser = this.createResultParser(string);
                    double d = (double)n.intValue() / 1000000.0;
                    Log.i((String)LOG_TAG, (String)String.format("Running %s for %d iterations with delay %f", iFileEntry.getName(), this.mNumIterations, d));
                    String string3 = String.format("%s -n %d -d %f -c %d -s %d", string2, this.mNumIterations, d, this.mClientCpu, this.mServerCpu);
                    Log.i((String)LOG_TAG, (String)String.format("Running native benchmark test on %s: %s", this.mDevice.getSerialNumber(), string3));
                    iTestDevice.executeShellCommand(string3, (IShellOutputReceiver)nativeBenchmarkTestParser, this.mMaxRunTime, 0);
                    this.addMetric(hashMap, nativeBenchmarkTestParser, n);
                }
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                long l2 = System.currentTimeMillis() - l;
                iTestRunListener.testRunEnded(l2, hashMap);
                throw throwable;
            }
            long l3 = System.currentTimeMillis() - l;
            iTestRunListener.testRunEnded(l3, hashMap);
            {
            }
        }
    }

    private void addMetric(Map<String, String> map, NativeBenchmarkTestParser nativeBenchmarkTestParser, Integer n) {
        String string = String.format("%s-delay%d", AVG_OP_TIME_KEY_PREFIX, n);
        map.put(string, Double.toString(nativeBenchmarkTestParser.getAvgOperationTime() * 1000000.0));
    }

    NativeBenchmarkTestParser createResultParser(String string) {
        return new NativeBenchmarkTestParser(string);
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String string = this.getTestPath();
        IFileEntry iFileEntry = this.mDevice.getFileEntry(string);
        if (iFileEntry == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find native benchmark test directory %s in %s!", string, this.mDevice.getSerialNumber()));
            return;
        }
        if (this.mMaxCpuFreq) {
            this.mDevice.executeShellCommand("cat /sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq");
        }
        this.doRunAllTestsInSubdirectory(iFileEntry, this.mDevice, iTestInvocationListener);
        if (this.mMaxCpuFreq) {
            this.mDevice.executeShellCommand("cat /sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq");
        }
    }
}

