/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IResumableTest;
import com.android.tradefed.testtype.InstrumentationListTest;
import java.io.File;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationTest
implements IDeviceTest,
IResumableTest {
    private static final String LOG_TAG = "InstrumentationTest";
    private static final int COLLECT_TESTS_ATTEMPTS = 3;
    static final String DELAY_MSEC_ARG = "delay_msec";
    @Option(name="package", shortName=112, description="The manifest package name of the Android test application to run")
    private String mPackageName = null;
    @Option(name="runner", description="The instrumentation test runner class name to use")
    private String mRunnerName = "android.test.InstrumentationTestRunner";
    @Option(name="class", shortName=99, description="The test class name to run")
    private String mTestClassName = null;
    @Option(name="method", shortName=109, description="The test method name to run.")
    private String mTestMethodName = null;
    @Option(name="timeout", description="Aborts the test run if any test takes longer than the specified number of milliseconds. Default 10 minutes. For no timeout, set to 0")
    private int mTestTimeout = 600000;
    @Option(name="size", description="Restrict test to a specific test size")
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete. Default true")
    private boolean mIsRerunMode = true;
    @Option(name="resume", description="Schedule unexecuted tests for resumption on another device if first device becomes unavailable. Default false")
    private boolean mIsResumeMode = false;
    @Option(name="log-delay", description="Delay in msec between each test when collecting test information")
    private int mTestDelay = 15;
    @Option(name="install-file", description="Optional file path to apk file that contains the tests.")
    private File mInstallFile = null;
    private ITestDevice mDevice = null;
    private IRemoteAndroidTestRunner mRunner;
    private Collection<TestIdentifier> mRemainingTests = null;
    private String mCoverageTarget = null;
    private int mCollectTestsShellTimeout = 30000;

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    public void setPackageName(String string) {
        this.mPackageName = string;
    }

    public void setRunnerName(String string) {
        this.mRunnerName = string;
    }

    public void setClassName(String string) {
        this.mTestClassName = string;
    }

    public void setMethodName(String string) {
        this.mTestMethodName = string;
    }

    public void setTestSize(String string) {
        this.mTestSize = string;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    String getClassName() {
        return this.mTestClassName;
    }

    String getMethodName() {
        return this.mTestMethodName;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    public void setTestTimeout(int n) {
        this.mTestTimeout = n;
    }

    public void setCoverageTarget(String string) {
        this.mCoverageTarget = string;
    }

    public String getCoverageTarget() {
        return this.mCoverageTarget;
    }

    boolean isRerunMode() {
        return this.mIsRerunMode;
    }

    @Override
    public boolean isResumable() {
        if (this.mRemainingTests == null) {
            return false;
        }
        return this.mIsResumeMode;
    }

    public void setRerunMode(boolean bl) {
        this.mIsRerunMode = bl;
    }

    public void setResumeMode(boolean bl) {
        this.mIsResumeMode = bl;
    }

    int getTestTimeout() {
        return this.mTestTimeout;
    }

    long getTestDelay() {
        return this.mTestDelay;
    }

    public void setInstallFile(File file) {
        this.mInstallFile = file;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setCollectsTestsShellTimeout(int n) {
        this.mCollectTestsShellTimeout = n;
    }

    IRemoteAndroidTestRunner createRemoteAndroidTestRunner(String string, String string2, IDevice iDevice) {
        return new RemoteAndroidTestRunner(string, string2, iDevice);
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.mPackageName == null) {
            throw new IllegalArgumentException("package name has not been set");
        }
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        this.mRunner = this.createRemoteAndroidTestRunner(this.mPackageName, this.mRunnerName, this.mDevice.getIDevice());
        if (this.mTestClassName != null) {
            if (this.mTestMethodName != null) {
                this.mRunner.setMethodName(this.mTestClassName, this.mTestMethodName);
            } else {
                this.mRunner.setClassName(this.mTestClassName);
            }
        }
        if (this.mTestSize != null) {
            this.mRunner.setTestSize(IRemoteAndroidTestRunner.TestSize.getTestSize((String)this.mTestSize));
        }
        this.mRunner.setMaxtimeToOutputResponse(this.mTestTimeout);
        if (this.mInstallFile != null) {
            this.mDevice.installPackage(this.mInstallFile, true);
            this.doTestRun(iTestInvocationListener);
            this.mDevice.uninstallPackage(this.mPackageName);
        } else {
            this.doTestRun(iTestInvocationListener);
        }
    }

    private void doTestRun(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.mRemainingTests != null) {
            this.rerunTests(iTestInvocationListener);
            return;
        }
        this.mRemainingTests = this.collectTestsToRun(this.mRunner);
        if (this.mRemainingTests == null) {
            this.mDevice.runInstrumentationTests(this.mRunner, iTestInvocationListener);
        } else if (this.mRemainingTests.size() != 0) {
            this.runWithRerun(iTestInvocationListener, this.mRemainingTests);
        } else {
            Log.i((String)LOG_TAG, (String)String.format("No tests expected for %s, skipping", this.mPackageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithRerun(ITestInvocationListener iTestInvocationListener, Collection<TestIdentifier> collection) throws DeviceNotAvailableException {
        CollectingTestListener collectingTestListener = new CollectingTestListener();
        this.mRemainingTests = collection;
        try {
            this.mDevice.runInstrumentationTests(this.mRunner, new ResultForwarder(iTestInvocationListener, collectingTestListener));
            Object var5_4 = null;
            this.calculateRemainingTests(this.mRemainingTests, collectingTestListener);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.calculateRemainingTests(this.mRemainingTests, collectingTestListener);
            throw throwable;
        }
        this.rerunTests(iTestInvocationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rerunTests(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.mRemainingTests.size() > 0) {
            InstrumentationListTest instrumentationListTest = new InstrumentationListTest(this.mPackageName, this.mRunnerName, this.mRemainingTests);
            instrumentationListTest.setDevice(this.getDevice());
            instrumentationListTest.setTestTimeout(this.getTestTimeout());
            CollectingTestListener collectingTestListener = new CollectingTestListener();
            try {
                instrumentationListTest.run(new ResultForwarder(iTestInvocationListener, collectingTestListener));
                Object var5_4 = null;
                this.calculateRemainingTests(this.mRemainingTests, collectingTestListener);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.calculateRemainingTests(this.mRemainingTests, collectingTestListener);
                throw throwable;
            }
        }
    }

    private void calculateRemainingTests(Collection<TestIdentifier> collection, CollectingTestListener collectingTestListener) {
        collection.removeAll(collectingTestListener.getCurrentRunResults().getTests());
    }

    private Collection<TestIdentifier> collectTestsToRun(IRemoteAndroidTestRunner iRemoteAndroidTestRunner) throws DeviceNotAvailableException {
        if (this.isRerunMode()) {
            Log.d((String)LOG_TAG, (String)String.format("Collecting test info for %s on device %s", this.mPackageName, this.mDevice.getSerialNumber()));
            iRemoteAndroidTestRunner.setLogOnly(true);
            if (this.mTestDelay > 0) {
                iRemoteAndroidTestRunner.addInstrumentationArg(DELAY_MSEC_ARG, Integer.toString(this.mTestDelay));
            }
            iRemoteAndroidTestRunner.setMaxtimeToOutputResponse(this.mCollectTestsShellTimeout);
            Collection<TestIdentifier> collection = this.collectTestsAndRetry(iRemoteAndroidTestRunner);
            iRemoteAndroidTestRunner.setLogOnly(false);
            iRemoteAndroidTestRunner.setMaxtimeToOutputResponse(this.mTestTimeout);
            iRemoteAndroidTestRunner.removeInstrumentationArg(DELAY_MSEC_ARG);
            return collection;
        }
        return null;
    }

    private Collection<TestIdentifier> collectTestsAndRetry(IRemoteAndroidTestRunner iRemoteAndroidTestRunner) throws DeviceNotAvailableException {
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            CollectingTestListener collectingTestListener = new CollectingTestListener();
            boolean bl2 = this.mDevice.runInstrumentationTests(iRemoteAndroidTestRunner, collectingTestListener);
            TestRunResult testRunResult = collectingTestListener.getCurrentRunResults();
            if (!bl2 || !testRunResult.isRunComplete()) {
                Log.w((String)LOG_TAG, (String)String.format("No results when collecting tests to run for %s on device %s. Retrying", this.mPackageName, this.mDevice.getSerialNumber()));
                bl = true;
                continue;
            }
            if (testRunResult.isRunFailure()) {
                Log.w((String)LOG_TAG, (String)String.format("Run failure %s when collecting tests to run for %s on device %s.", testRunResult.getRunFailureMessage(), this.mPackageName, this.mDevice.getSerialNumber()));
                continue;
            }
            return testRunResult.getTests();
        }
        if (bl) {
            throw new DeviceUnresponsiveException(String.format("Communication failure when attempting to collect tests %s on device %s", this.mPackageName, this.mDevice.getSerialNumber()));
        }
        Log.e((String)LOG_TAG, (String)String.format("Failed to collect tests to run to run for %s on device %s.", this.mPackageName, this.mDevice.getSerialNumber()));
        return null;
    }
}

