/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstrumentationListTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "InstrumentationListTest";
    private final String mPackageName;
    private final String mRunnerName;
    private final Collection<TestIdentifier> mTests;
    private int mTestTimeout = 600000;
    private ITestDevice mDevice = null;

    InstrumentationListTest(String string, String string2, Collection<TestIdentifier> collection) {
        this.mPackageName = string;
        this.mRunnerName = string2;
        this.mTests = collection;
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    void setTestTimeout(int n) {
        this.mTestTimeout = n;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        for (TestIdentifier testIdentifier : this.mTests) {
            InstrumentationTest instrumentationTest = this.createInstrumentationTest();
            instrumentationTest.setDevice(this.mDevice);
            instrumentationTest.setPackageName(this.mPackageName);
            instrumentationTest.setRunnerName(this.mRunnerName);
            instrumentationTest.setClassName(testIdentifier.getClassName());
            instrumentationTest.setMethodName(testIdentifier.getTestName());
            instrumentationTest.setTestTimeout(this.mTestTimeout);
            instrumentationTest.setRerunMode(false);
            TestTrackingListener testTrackingListener = new TestTrackingListener(iTestInvocationListener, testIdentifier);
            instrumentationTest.run(testTrackingListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestTrackingListener
    extends ResultForwarder {
        private String mRunErrorMsg = null;
        private final TestIdentifier mExpectedTest;
        private boolean mDidTestRun = false;

        public TestTrackingListener(ITestInvocationListener iTestInvocationListener, TestIdentifier testIdentifier) {
            super(iTestInvocationListener);
            this.mExpectedTest = testIdentifier;
        }

        @Override
        public void testRunFailed(String string) {
            super.testRunFailed(string);
            this.mRunErrorMsg = string;
        }

        @Override
        public void testEnded(TestIdentifier testIdentifier, Map<String, String> map) {
            super.testEnded(testIdentifier, map);
            if (this.mExpectedTest.equals((Object)testIdentifier)) {
                this.mDidTestRun = true;
            } else {
                Log.w((String)InstrumentationListTest.LOG_TAG, (String)String.format("Expected test %s, but got test %s", this.mExpectedTest, testIdentifier));
            }
        }

        @Override
        public void testRunEnded(long l, Map<String, String> map) {
            if (this.mRunErrorMsg != null && !this.mDidTestRun) {
                Log.d((String)InstrumentationListTest.LOG_TAG, (String)String.format("Test %s was not executed, but run failed. Reporting as a test failure", this.mExpectedTest));
                super.testStarted(this.mExpectedTest);
                super.testFailed(ITestRunListener.TestFailure.ERROR, this.mExpectedTest, String.format("Test run failed: %s", this.mRunErrorMsg));
                super.testEnded(this.mExpectedTest, Collections.EMPTY_MAP);
            }
            super.testRunEnded(l, map);
        }
    }
}

