/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.DeviceTestCase;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.JUnitRunUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostTest
implements IDeviceTest,
IRemoteTest {
    @Option(name="class", description="The JUnit Test to run")
    private String mClassName;
    @Option(name="method", description="The JUnit TestCase method to run")
    private String mMethodName;
    private ITestDevice mDevice = null;

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    public int countTestCases() {
        return 1;
    }

    void setClassName(String string) {
        this.mClassName = string;
    }

    void setMethodName(String string) {
        this.mMethodName = string;
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) {
        if (this.mClassName == null) {
            throw new IllegalArgumentException("Missing Test class name");
        }
        Class<?> clazz = this.loadTestClass(this.mClassName);
        Test test = this.loadTest(clazz);
        if (test instanceof IDeviceTest) {
            if (this.mDevice == null) {
                throw new IllegalArgumentException("Missing device");
            }
            ((IDeviceTest)((Object)test)).setDevice(this.mDevice);
        }
        if (test instanceof TestCase) {
            TestCase testCase = (TestCase)test;
            if (this.mMethodName != null) {
                testCase.setName(this.mMethodName);
            } else if (!(test instanceof DeviceTestCase)) {
                TestSuite testSuite = new TestSuite(clazz);
                test = testSuite;
            }
        }
        JUnitRunUtil.runTest(iTestInvocationListener, test);
    }

    private Class<?> loadTestClass(String string) throws IllegalArgumentException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", string), classNotFoundException);
        }
    }

    private Test loadTest(Class<?> clazz) throws IllegalArgumentException {
        String string = clazz.getName();
        try {
            Object obj = clazz.newInstance();
            if (!(obj instanceof Test)) {
                throw new IllegalArgumentException(String.format("%s is not a Test", string));
            }
            return (Test)obj;
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", string), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(String.format("Could not load Test class %s", string), illegalAccessException);
        }
    }
}

