/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.GTestResultParser;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;

public class GTest
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "GTest";
    static final String DEFAULT_NATIVETEST_PATH = "/data/nativetest";
    private ITestDevice mDevice = null;
    private boolean mRunDisabledTests = false;
    @Option(name="native-test-device-path", description="The path on the device where native tests are located.")
    private String mNativeTestDevicePath = "/data/nativetest";
    @Option(name="module-name", description="The name of the native test module to run.")
    private String mTestModule = null;
    @Option(name="positive-testname-filter", description="The GTest-based positive filter of the test name to run.")
    private String mTestNamePositiveFilter = null;
    @Option(name="negative-testname-filter", description="The GTest-based negative filter of the test name to run.")
    private String mTestNameNegativeFilter = null;
    @Option(name="native-test-timeout", description="The max time in ms for a gtest to run (default 1 min). Test run will be aborted if any test takes longer")
    private int mMaxTestTimeMs = 60000;
    @Option(name="send-coverage", description="Send coverage target info to test listeners. Default true.")
    private boolean mSendCoverage = true;
    private static final String COVERAGE_TARGET = "Native";
    private static final String GTEST_FLAG_PRINT_TIME = "--gtest_print_time";
    private static final String GTEST_FLAG_FILTER = "--gtest_filter";
    private static final String GTEST_FLAG_RUN_DISABLED_TESTS = "--gtest_also_run_disabled_tests";

    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String string) {
        this.mTestModule = string;
    }

    public String getModuleName(String string) {
        return this.mTestModule;
    }

    public void setRunDisabled(boolean bl) {
        this.mRunDisabledTests = bl;
    }

    public boolean getRunDisabledTests() {
        return this.mRunDisabledTests;
    }

    void setMaxTestTimeMs(int n) {
        this.mMaxTestTimeMs = n;
    }

    public void setTestNamePositiveFilter(String string) {
        this.mTestNamePositiveFilter = string;
    }

    public String getTestNamePositiveFilter() {
        return this.mTestNamePositiveFilter;
    }

    public void setTestNameNegativeFilter(String string) {
        this.mTestNameNegativeFilter = string;
    }

    public String getTestNameNegativeFilter() {
        return this.mTestNameNegativeFilter;
    }

    private String getGTestFilters() {
        String string = "";
        if (this.mTestNamePositiveFilter != null || this.mTestNameNegativeFilter != null) {
            string = "--gtest_filter=";
            if (this.mTestNamePositiveFilter != null) {
                string = String.format("%s*.%s", string, this.mTestNamePositiveFilter);
            }
            if (this.mTestNameNegativeFilter != null) {
                string = String.format("%s-*.%s", string, this.mTestNameNegativeFilter);
            }
        }
        return string;
    }

    private String getAllGTestFlags() {
        String string = String.format("%s %s", GTEST_FLAG_PRINT_TIME, this.getGTestFilters());
        if (this.mRunDisabledTests) {
            string = String.format("%s %s", string, GTEST_FLAG_RUN_DISABLED_TESTS);
        }
        return string;
    }

    private String getTestPath() {
        StringBuilder stringBuilder = new StringBuilder(this.mNativeTestDevicePath);
        if (this.mTestModule != null) {
            stringBuilder.append("/");
            stringBuilder.append(this.mTestModule);
        }
        return stringBuilder.toString();
    }

    void doRunAllTestsInSubdirectory(IFileEntry iFileEntry, ITestDevice iTestDevice, ITestRunListener iTestRunListener) throws DeviceNotAvailableException {
        if (iFileEntry.isDirectory()) {
            for (IFileEntry iFileEntry2 : iFileEntry.getChildren(true)) {
                this.doRunAllTestsInSubdirectory(iFileEntry2, iTestDevice, iTestRunListener);
            }
        } else {
            IShellOutputReceiver iShellOutputReceiver = this.createResultParser(iFileEntry.getName(), iTestRunListener);
            String string = iFileEntry.getFullEscapedPath();
            String string2 = this.getAllGTestFlags();
            Log.i((String)LOG_TAG, (String)String.format("Running gtest %s %s on %s", string, string2, this.mDevice.getSerialNumber()));
            iTestDevice.executeShellCommand(String.format("chmod 755 %s", string));
            this.runTest(iTestDevice, iShellOutputReceiver, string, string2);
        }
    }

    private void runTest(ITestDevice iTestDevice, IShellOutputReceiver iShellOutputReceiver, String string, String string2) throws DeviceNotAvailableException {
        try {
            iTestDevice.executeShellCommand(String.format("%s %s", string, string2), iShellOutputReceiver, this.mMaxTestTimeMs, 0);
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            iShellOutputReceiver.flush();
            throw deviceNotAvailableException;
        }
        catch (RuntimeException runtimeException) {
            iShellOutputReceiver.flush();
            throw runtimeException;
        }
    }

    IShellOutputReceiver createResultParser(String string, ITestRunListener iTestRunListener) {
        GTestResultParser gTestResultParser = new GTestResultParser(string, iTestRunListener);
        if (this.mSendCoverage) {
            gTestResultParser.setCoverageTarget(COVERAGE_TARGET);
        }
        return gTestResultParser;
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String string = this.getTestPath();
        IFileEntry iFileEntry = this.mDevice.getFileEntry(string);
        if (iFileEntry == null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not find native test directory %s in %s!", string, this.mDevice.getSerialNumber()));
            return;
        }
        this.doRunAllTestsInSubdirectory(iFileEntry, this.mDevice, iTestInvocationListener);
    }
}

