/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.JUnitRunUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTestCase
extends TestCase
implements IDeviceTest,
IRemoteTest {
    private static final String LOG_TAG = "DeviceTestCase";
    private ITestDevice mDevice;
    @Option(name="method", description="run a specific test method")
    private String mMethodName = null;

    public DeviceTestCase() {
    }

    public DeviceTestCase(String string) {
        super(string);
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    @Override
    public void run(ITestInvocationListener iTestInvocationListener) {
        if (this.getName() == null && this.mMethodName != null) {
            this.setName(this.mMethodName);
        }
        JUnitRunUtil.runTest(iTestInvocationListener, this);
    }

    @Override
    public void run(TestResult testResult) {
        if (this.getName() == null) {
            Collection<String> collection = this.getTestMethodNames(this.getClass());
            for (String string : collection) {
                this.setName(string);
                super.run(testResult);
            }
        } else {
            super.run(testResult);
        }
    }

    private Collection<String> getTestMethodNames(Class<? extends TestCase> clazz) {
        Class<? extends TestCase> clazz2 = clazz;
        Vector<String> vector = new Vector<String>();
        while (Test.class.isAssignableFrom(clazz2)) {
            Method[] methodArray = clazz2.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                this.addTestMethod(methodArray[i], vector, clazz);
            }
            clazz2 = clazz2.getSuperclass();
        }
        if (vector.size() == 0) {
            Log.w((String)LOG_TAG, (String)String.format("No tests found in %s", clazz.getName()));
        }
        return vector;
    }

    private void addTestMethod(Method method, Vector<String> vector, Class<?> clazz) {
        String string = method.getName();
        if (vector.contains(string)) {
            return;
        }
        if (!this.isPublicTestMethod(method)) {
            if (this.isTestMethod(method)) {
                Log.w((String)LOG_TAG, (String)String.format("Test method isn't public: %s", method.getName()));
            }
            return;
        }
        vector.addElement(string);
    }

    private boolean isPublicTestMethod(Method method) {
        return this.isTestMethod(method) && Modifier.isPublic(method.getModifiers());
    }

    private boolean isTestMethod(Method method) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        return classArray.length == 0 && string.startsWith("test") && clazz.equals(Void.TYPE);
    }
}

