/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipFile;

public class TestAppInstallSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "TestAppInstallSetup";
    @Option(name="test-file-name", description="the name of a test zip file to install on device. Can be repeated")
    private Collection<String> mTestFileNames = new ArrayList<String>();

    public void addTestFileName(String string) {
        this.mTestFileNames.add(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUp(ITestDevice iTestDevice, IBuildInfo iBuildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!(iBuildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException(String.format("Provided buildInfo is not a %s", IDeviceBuildInfo.class.getCanonicalName()));
        }
        if (this.mTestFileNames.size() == 0) {
            Log.i((String)LOG_TAG, (String)"No test apps to install, skipping");
            return;
        }
        File file = ((IDeviceBuildInfo)iBuildInfo).getTestsZipFile();
        if (file == null || !file.exists()) {
            throw new TargetSetupError("Provided buildInfo does not contain a valid tests.zip");
        }
        File file2 = null;
        try {
            try {
                file2 = FileUtil.createTempDir("testszip");
                FileUtil.extractZip(new ZipFile(file), file2);
                File file3 = new File(new File(file2, "DATA"), "app");
                if (!file3.exists()) {
                    throw new TargetSetupError("Could not find DATA/app directory in extracted tests.zip");
                }
                for (String string : this.mTestFileNames) {
                    File file4 = new File(file3, string);
                    if (!file4.exists()) {
                        throw new TargetSetupError(String.format("Could not find test app %s directory in extracted tests.zip", file4));
                    }
                    iTestDevice.installPackage(file4, true);
                }
                Object var10_10 = null;
                if (file2 == null) return;
            }
            catch (IOException iOException) {
                throw new TargetSetupError("failed to install test zip apps", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (file2 == null) throw throwable;
            FileUtil.recursiveDelete(file2);
            throw throwable;
        }
        FileUtil.recursiveDelete(file2);
    }
}

