/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.targetprep.IFlashingResourcesParser;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashingResourcesParser
implements IFlashingResourcesParser {
    private static final String ANDROID_INFO_FILE_NAME = "android-info.txt";
    private static final Pattern KEY_PATTERN = Pattern.compile("(?:require\\s)?(.*)=(.*)");
    static final String PRODUCT_KEY = "product";
    static final String BOARD_KEY = "board";
    static final String BOOTLOADER_VERSION_KEY = "version-bootloader";
    static final String BASEBAND_VERSION_KEY = "version-baseband";
    private Map<String, List<String>> mReqs;

    public FlashingResourcesParser(File file) throws TargetSetupError {
        this.mReqs = FlashingResourcesParser.getBuildRequirements(file);
    }

    public FlashingResourcesParser(BufferedReader bufferedReader) throws TargetSetupError, IOException {
        this.mReqs = FlashingResourcesParser.parseAndroidInfo(bufferedReader);
    }

    @Override
    public String getRequiredBootloaderVersion() {
        return this.getRequiredImageVersion(BOOTLOADER_VERSION_KEY);
    }

    @Override
    public String getRequiredBasebandVersion() {
        return this.getRequiredImageVersion(BASEBAND_VERSION_KEY);
    }

    @Override
    public String getRequiredImageVersion(String string) {
        return this.getFirst(this.mReqs.get(string));
    }

    @Override
    public Collection<String> getRequiredBoards() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = this.mReqs.get(BOARD_KEY);
        Collection collection2 = this.mReqs.get(PRODUCT_KEY);
        if (collection != null) {
            arrayList.addAll(collection);
        } else if (collection2 != null) {
            arrayList.addAll(collection2);
        } else {
            return null;
        }
        return arrayList;
    }

    private String getFirst(List<String> list) {
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map<String, List<String>> getBuildRequirements(File var0) throws TargetSetupError {
        block14: {
            var1_1 = null;
            var2_2 = null;
            try {
                try {
                    var1_1 = new ZipFile(var0);
                    var3_3 = var1_1.getEntry("android-info.txt");
                    if (var3_3 == null) {
                        throw new TargetSetupError(String.format("Could not find %s in device image zip %s", new Object[]{"android-info.txt", var0.getName()}));
                    }
                    var2_2 = new BufferedReader(new InputStreamReader(var1_1.getInputStream(var3_3)));
                    var4_6 = FlashingResourcesParser.parseAndroidInfo(var2_2);
                    var6_7 = null;
                    if (var1_1 == null) break block14;
                }
                catch (ZipException var3_4) {
                    throw new TargetSetupError(String.format("Could not read device image zip %s", new Object[]{var0.getName()}), var3_4);
                }
                catch (IOException var3_5) {
                    throw new TargetSetupError(String.format("Could not read device image zip %s", new Object[]{var0.getName()}), var3_5);
                }
            }
            catch (Throwable var5_11) {
                var6_8 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var7_10) {
                        // empty catch block
                    }
                }
                if (var2_2 == null) throw var5_11;
                try {
                    var2_2.close();
                    throw var5_11;
                }
                catch (IOException var7_10) {
                    throw var5_11;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 151->158)] { 
lbl37:
            // 1 sources

            var1_1.close();
            break block14;
lbl39:
            // 1 sources

            catch (IOException var7_9) {
                // empty catch block
            }
        }
        if (var2_2 == null) return var4_6;
        try {}
        catch (IOException var7_9) {
            // empty catch block
            return var4_6;
        }
        var2_2.close();
        return var4_6;
    }

    static Map<String, List<String>> parseAndroidInfo(BufferedReader bufferedReader) throws IOException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        boolean bl = false;
        while (!bl) {
            String string = bufferedReader.readLine();
            if (string != null) {
                Matcher matcher = KEY_PATTERN.matcher(string);
                if (!matcher.matches()) continue;
                String string2 = matcher.group(2);
                hashMap.put(matcher.group(1), Arrays.asList(string2.split("\\|")));
                continue;
            }
            bl = true;
        }
        return hashMap;
    }
}

