/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class DeviceSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "DeviceSetup";
    @Option(name="wifi-network", description="the name of wifi network to connect to")
    private String mWifiNetwork = null;
    @Option(name="wifi-psk", description="WPA-PSK passphrase of wifi network to connect to")
    private String mWifiPsk = null;
    @Option(name="min-external-store-space", description="the minimum amount of free space in KBthat must be present on device's external storage")
    private long mMinExternalStoreSpace = 500L;
    @Option(name="local-data-path", description="optional local file path of test data to sync to device's external storage. Use --remote-data-path to set remote location")
    private File mLocalDataFile = null;
    @Option(name="remote-data-path", description="optional file path on device's external storage to sync test data. Must be used with --local-data-path")
    private String mRemoteDataPath = null;
    @Option(name="disable-dialing", description="set disable dialing property on boot")
    private boolean mDisableDialing = true;
    @Option(name="set-test-harness", description="set the read-only test harness flag on boot. Requires adb root. Default true.")
    private boolean mSetTestHarness = true;
    @Option(name="audio-silent", description="set ro.audio.silent on boot")
    private boolean mSetAudioSilent = true;
    @Option(name="disable-dalvik-verifier", description="disable the dalvik verifier on device. Allows package-private framework tests to run.")
    private boolean mDisableDalvikVerifier = false;
    @Option(name="setprop", description="set the specified property on boot.  Format: --setprop key=value.  May be repeated.")
    private Collection<String> mSetProps = new ArrayList<String>();

    void setLocalDataPath(File file) {
        this.mLocalDataFile = file;
    }

    void setRemoteDataPath(String string) {
        this.mRemoteDataPath = string;
    }

    void setWifiNetwork(String string) {
        this.mWifiNetwork = string;
    }

    void setMinExternalStoreSpace(int n) {
        this.mMinExternalStoreSpace = n;
    }

    void addSetProperty(String string) {
        this.mSetProps.add(string);
    }

    public void setUp(ITestDevice iTestDevice, IBuildInfo iBuildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", iTestDevice.getSerialNumber()));
        iTestDevice.enableAdbRoot();
        this.configureSystemProperties(iTestDevice);
        this.keepScreenOn(iTestDevice);
        this.connectToWifi(iTestDevice);
        this.syncTestData(iTestDevice);
        this.checkExternalStoreSpace(iTestDevice);
        iTestDevice.postBootSetup();
        iTestDevice.clearErrorDialogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSystemProperties(ITestDevice iTestDevice) throws TargetSetupError, DeviceNotAvailableException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mDisableDialing) {
            stringBuilder.append("ro.telephony.disable-call=true\n");
        }
        if (this.mSetTestHarness) {
            stringBuilder.append("ro.monkey=1\n");
            stringBuilder.append("ro.test_harness=1\n");
        }
        if (this.mSetAudioSilent) {
            stringBuilder.append("ro.audio.silent=1\n");
        }
        if (this.mDisableDalvikVerifier) {
            stringBuilder.append("dalvik.vm.dexopt-flags = v=n\n");
        }
        for (String string : this.mSetProps) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        if (stringBuilder.length() > 0) {
            File file = this.createTempFile("local.prop", stringBuilder.toString());
            try {
                boolean bl = iTestDevice.pushFile(file, "/data/local.prop");
                if (!bl) {
                    throw new TargetSetupError(String.format("Failed to push file to %s", iTestDevice.getSerialNumber()));
                }
                Object var6_6 = null;
                file.delete();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                file.delete();
                throw throwable;
            }
            Log.i((String)LOG_TAG, (String)String.format("Setup requires system property change. Reboot of %s required", iTestDevice.getSerialNumber()));
            iTestDevice.reboot();
        }
    }

    private void keepScreenOn(ITestDevice iTestDevice) throws DeviceNotAvailableException {
        iTestDevice.executeShellCommand("svc power stayon true");
    }

    private void checkExternalStoreSpace(ITestDevice iTestDevice) throws DeviceNotAvailableException {
        long l;
        if (this.mMinExternalStoreSpace > 0L && (l = iTestDevice.getExternalStoreFreeSpace()) < this.mMinExternalStoreSpace) {
            throw new DeviceNotAvailableException(String.format("External store free space %dK is less than required %dK for device %s", l, this.mMinExternalStoreSpace, iTestDevice.getSerialNumber()));
        }
    }

    private void connectToWifi(ITestDevice iTestDevice) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mWifiNetwork != null) {
            if (iTestDevice.connectToWifiNetwork(this.mWifiNetwork, this.mWifiPsk)) {
                Log.i((String)LOG_TAG, (String)String.format("Connected to wifi network %s", this.mWifiNetwork));
            } else {
                throw new TargetSetupError(String.format("Failed to connect to wifi network %s on %s", this.mWifiNetwork, iTestDevice.getSerialNumber()));
            }
        }
    }

    void syncTestData(ITestDevice iTestDevice) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mLocalDataFile != null) {
            boolean bl;
            if (!this.mLocalDataFile.exists() || !this.mLocalDataFile.isDirectory()) {
                throw new TargetSetupError(String.format("local-data-path %s is not a directory", this.mLocalDataFile.getAbsolutePath()));
            }
            String string = iTestDevice.getIDevice().getMountPoint("EXTERNAL_STORAGE");
            if (this.mRemoteDataPath != null) {
                string = String.format("%s/%s", string, this.mRemoteDataPath);
            }
            if (!(bl = iTestDevice.syncFiles(this.mLocalDataFile, string))) {
                throw new DeviceNotAvailableException(String.format("failed to sync test data from local-data-path %s to %s on device %s", this.mLocalDataFile.getAbsolutePath(), string, iTestDevice.getSerialNumber()));
            }
        }
    }

    private File createTempFile(String string, String string2) throws TargetSetupError {
        File file = null;
        try {
            file = FileUtil.createTempFile(string, ".txt");
            FileUtil.writeToFile(string2, file);
            return file;
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (Throwable)iOException);
            if (file != null) {
                file.delete();
            }
            throw new TargetSetupError("Failed to create local temp file", iOException);
        }
    }
}

