/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.FlashingResourcesParser;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.IFlashingResourcesParser;
import com.android.tradefed.targetprep.IFlashingResourcesRetriever;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class DeviceFlasher
implements IDeviceFlasher {
    private static final String LOG_TAG = "DeviceFlasher";
    public static final String BASEBAND_IMAGE_NAME = "radio";
    private IDeviceFlasher.UserDataFlashOption mUserDataFlashOption = IDeviceFlasher.UserDataFlashOption.FLASH;
    private Set<String> mDataWipeSkipList = new HashSet<String>();
    private final IFlashingResourcesRetriever mResourceRetriever;

    public DeviceFlasher(IFlashingResourcesRetriever iFlashingResourcesRetriever) {
        this.mResourceRetriever = iFlashingResourcesRetriever;
        this.mDataWipeSkipList.add("media");
    }

    public void setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption userDataFlashOption) {
        this.mUserDataFlashOption = userDataFlashOption;
    }

    protected IDeviceFlasher.UserDataFlashOption getUserDataFlashOption() {
        return this.mUserDataFlashOption;
    }

    public void flash(ITestDevice iTestDevice, IDeviceBuildInfo iDeviceBuildInfo) throws TargetSetupError, DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Flashing device %s with build %d", iTestDevice.getSerialNumber(), iDeviceBuildInfo.getBuildId()));
        int n = iTestDevice.getBuildId();
        iTestDevice.rebootIntoBootloader();
        this.downloadFlashingResources(iTestDevice, iDeviceBuildInfo);
        this.checkAndFlashBootloader(iTestDevice, iDeviceBuildInfo);
        this.checkAndFlashBaseband(iTestDevice, iDeviceBuildInfo);
        this.flashUserData(iTestDevice, iDeviceBuildInfo);
        this.eraseCache(iTestDevice);
        this.checkAndFlashSystem(iTestDevice, n, iDeviceBuildInfo);
    }

    private void downloadFlashingResources(ITestDevice iTestDevice, IDeviceBuildInfo iDeviceBuildInfo) throws TargetSetupError, DeviceNotAvailableException {
        String string;
        IFlashingResourcesParser iFlashingResourcesParser = this.createFlashingResourcesParser(iDeviceBuildInfo);
        if (iFlashingResourcesParser.getRequiredBoards() == null) {
            throw new TargetSetupError(String.format("Build %s is missing required board info.", iDeviceBuildInfo.getBuildId()));
        }
        String string2 = iTestDevice.getProductType();
        if (string2 == null) {
            throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s", iTestDevice.getSerialNumber()));
        }
        this.verifyRequiredBoards(iTestDevice, iFlashingResourcesParser, string2);
        String string3 = iFlashingResourcesParser.getRequiredBootloaderVersion();
        if (string3 != null) {
            iDeviceBuildInfo.setBootloaderImageFile(this.mResourceRetriever.retrieveFile(this.getBootloaderFilePrefix(iTestDevice), string3), string3);
        }
        if ((string = iFlashingResourcesParser.getRequiredBasebandVersion()) != null) {
            iDeviceBuildInfo.setBasebandImage(this.mResourceRetriever.retrieveFile(BASEBAND_IMAGE_NAME, string), string);
        }
        this.downloadExtraImageFiles(iFlashingResourcesParser, this.mResourceRetriever, iDeviceBuildInfo);
    }

    protected void verifyRequiredBoards(ITestDevice iTestDevice, IFlashingResourcesParser iFlashingResourcesParser, String string) throws TargetSetupError {
        if (!iFlashingResourcesParser.getRequiredBoards().contains(string)) {
            throw new TargetSetupError(String.format("Device %s is %s. Expected %s", iTestDevice.getSerialNumber(), string, iFlashingResourcesParser.getRequiredBoards()));
        }
    }

    protected void downloadExtraImageFiles(IFlashingResourcesParser iFlashingResourcesParser, IFlashingResourcesRetriever iFlashingResourcesRetriever, IDeviceBuildInfo iDeviceBuildInfo) throws TargetSetupError {
    }

    protected IFlashingResourcesParser createFlashingResourcesParser(IDeviceBuildInfo iDeviceBuildInfo) throws TargetSetupError {
        return new FlashingResourcesParser(iDeviceBuildInfo.getDeviceImageFile());
    }

    protected boolean checkAndFlashBootloader(ITestDevice iTestDevice, IDeviceBuildInfo iDeviceBuildInfo) throws DeviceNotAvailableException, TargetSetupError {
        String string = this.getImageVersion(iTestDevice, "bootloader");
        if (iDeviceBuildInfo.getBootloaderVersion() != null && !iDeviceBuildInfo.getBootloaderVersion().equals(string)) {
            Log.i((String)LOG_TAG, (String)String.format("Flashing bootloader %s", iDeviceBuildInfo.getBootloaderVersion()));
            this.flashBootloader(iTestDevice, iDeviceBuildInfo.getBootloaderImageFile());
            return true;
        }
        Log.i((String)LOG_TAG, (String)String.format("Bootloader is already version %s, skipping flashing", string));
        return false;
    }

    protected void flashBootloader(ITestDevice iTestDevice, File file) throws DeviceNotAvailableException, TargetSetupError {
        this.executeFastbootCmd(iTestDevice, "flash", this.getBootPartitionName(), file.getAbsolutePath());
        iTestDevice.rebootIntoBootloader();
    }

    protected String getBootPartitionName() {
        return "hboot";
    }

    protected String getBootloaderFilePrefix(ITestDevice iTestDevice) throws TargetSetupError, DeviceNotAvailableException {
        return this.getBootPartitionName();
    }

    protected void checkAndFlashBaseband(ITestDevice iTestDevice, IDeviceBuildInfo iDeviceBuildInfo) throws DeviceNotAvailableException, TargetSetupError {
        String string = this.getImageVersion(iTestDevice, "baseband");
        if (iDeviceBuildInfo.getBasebandVersion() != null && !iDeviceBuildInfo.getBasebandVersion().equals(string)) {
            Log.i((String)LOG_TAG, (String)String.format("Flashing baseband %s", iDeviceBuildInfo.getBasebandVersion()));
            this.flashBaseband(iTestDevice, iDeviceBuildInfo.getBasebandImageFile());
        } else {
            Log.i((String)LOG_TAG, (String)String.format("Baseband is already version %s, skipping flashing", string));
        }
    }

    protected void flashBaseband(ITestDevice iTestDevice, File file) throws DeviceNotAvailableException, TargetSetupError {
        this.executeLongFastbootCmd(iTestDevice, "flash", BASEBAND_IMAGE_NAME, file.getAbsolutePath());
        iTestDevice.rebootIntoBootloader();
    }

    protected void eraseCache(ITestDevice iTestDevice) throws DeviceNotAvailableException, TargetSetupError {
        if (!this.mUserDataFlashOption.equals((Object)IDeviceFlasher.UserDataFlashOption.RETAIN)) {
            Log.i((String)LOG_TAG, (String)String.format("Erasing cache on %s", iTestDevice.getSerialNumber()));
            this.executeFastbootCmd(iTestDevice, "erase", "cache");
        } else {
            Log.d((String)LOG_TAG, (String)String.format("Skipping cache erase on %s", iTestDevice.getSerialNumber()));
        }
    }

    protected void flashUserData(ITestDevice iTestDevice, IDeviceBuildInfo iDeviceBuildInfo) throws DeviceNotAvailableException, TargetSetupError {
        switch (this.mUserDataFlashOption) {
            case FLASH: {
                Log.i((String)LOG_TAG, (String)String.format("Flashing %s with userdata %s", iTestDevice.getSerialNumber(), iDeviceBuildInfo.getUserDataImageFile().getAbsolutePath()));
                this.executeLongFastbootCmd(iTestDevice, "flash", "userdata", iDeviceBuildInfo.getUserDataImageFile().getAbsolutePath());
                break;
            }
            case WIPE: {
                Log.i((String)LOG_TAG, (String)String.format("Wiping userdata %s", iTestDevice.getSerialNumber()));
                this.executeLongFastbootCmd(iTestDevice, "erase", "userdata");
                break;
            }
            case TESTS_ZIP: {
                this.pushTestsZipOntoData(iTestDevice, iDeviceBuildInfo);
                break;
            }
            default: {
                Log.d((String)LOG_TAG, (String)String.format("Skipping userdata flash for %s", iTestDevice.getSerialNumber()));
            }
        }
    }

    protected void pushTestsZipOntoData(ITestDevice iTestDevice, IDeviceBuildInfo iDeviceBuildInfo) throws DeviceNotAvailableException, TargetSetupError {
        Log.i((String)LOG_TAG, (String)String.format("Pushing test zips content onto userdata on %s", iTestDevice.getSerialNumber()));
        iTestDevice.rebootUntilOnline();
        Log.d((String)LOG_TAG, (String)"Stopping runtime");
        iTestDevice.executeShellCommand("stop");
        Log.d((String)LOG_TAG, (String)String.format("Cleaning %s", "data"));
        IFileEntry iFileEntry = iTestDevice.getFileEntry("data");
        if (iFileEntry == null) {
            throw new TargetSetupError(String.format("Could not find %s folder on %s", "data", iTestDevice.getSerialNumber()));
        }
        for (IFileEntry object2 : iFileEntry.getChildren(false)) {
            if (this.mDataWipeSkipList.contains(object2.getName())) continue;
            iTestDevice.executeShellCommand(String.format("rm -r %s", object2.getFullEscapedPath()));
        }
        Object object = null;
        try {
            try {
                object = FileUtil.createTempDir("tests-zip_");
                this.extractZip(iDeviceBuildInfo, (File)object);
                Log.d((String)LOG_TAG, (String)"Syncing test files/apks");
                File iOException = new File((File)object, "DATA");
                File[] fileArray = this.getTestsZipDataFiles(iOException);
                for (File file : fileArray) {
                    iTestDevice.syncFiles(file, "data");
                }
                for (IFileEntry iFileEntry2 : iFileEntry.getChildren(false)) {
                    if (this.mDataWipeSkipList.contains(iFileEntry2.getName())) continue;
                    iTestDevice.executeShellCommand(String.format("chown system.system %s %s/*", iFileEntry2.getFullEscapedPath(), iFileEntry2.getFullEscapedPath()));
                }
                iTestDevice.rebootIntoBootloader();
            }
            catch (IOException iOException) {
                throw new TargetSetupError(iOException.getMessage());
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            FileUtil.recursiveDelete((File)object);
            throw throwable;
        }
        FileUtil.recursiveDelete((File)object);
    }

    File[] getTestsZipDataFiles(File file) throws TargetSetupError {
        if (!file.isDirectory()) {
            throw new TargetSetupError("Unrecognized tests.zip content: missing DATA folder");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length <= 0) {
            throw new TargetSetupError("Unrecognized tests.zip content: DATA folder has no content");
        }
        return fileArray;
    }

    void extractZip(IDeviceBuildInfo iDeviceBuildInfo, File file) throws IOException, ZipException, TargetSetupError {
        if (iDeviceBuildInfo.getTestsZipFile() == null) {
            throw new TargetSetupError("Missing tests.zip file");
        }
        FileUtil.extractZip(new ZipFile(iDeviceBuildInfo.getTestsZipFile()), file);
    }

    protected boolean checkAndFlashSystem(ITestDevice iTestDevice, int n, IDeviceBuildInfo iDeviceBuildInfo) throws DeviceNotAvailableException, TargetSetupError {
        if (n != iDeviceBuildInfo.getBuildId()) {
            Log.i((String)LOG_TAG, (String)String.format("Flashing system %d", iDeviceBuildInfo.getBuildId()));
            this.flashSystem(iTestDevice, iDeviceBuildInfo);
            return true;
        }
        Log.i((String)LOG_TAG, (String)String.format("System is already version %d, skipping flashing", n));
        iTestDevice.rebootUntilOnline();
        return false;
    }

    protected void flashSystem(ITestDevice iTestDevice, IDeviceBuildInfo iDeviceBuildInfo) throws DeviceNotAvailableException, TargetSetupError {
        Log.i((String)LOG_TAG, (String)String.format("Flashing %s with update %s", iTestDevice.getSerialNumber(), iDeviceBuildInfo.getDeviceImageFile().getAbsolutePath()));
        this.executeLongFastbootCmd(iTestDevice, "update", iDeviceBuildInfo.getDeviceImageFile().getAbsolutePath());
    }

    protected String getImageVersion(ITestDevice iTestDevice, String string) throws DeviceNotAvailableException, TargetSetupError {
        String string2 = String.format("version-%s", string);
        String string3 = this.executeFastbootCmd(iTestDevice, "getvar", string2);
        String string4 = String.format("%s:\\s(.*)\\s", string2);
        Pattern pattern = Pattern.compile(string4);
        Matcher matcher = pattern.matcher(string3);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new TargetSetupError(String.format("Could not find version for '%s'. Output '%s'", string, string3));
    }

    protected String executeFastbootCmd(ITestDevice iTestDevice, String ... stringArray) throws DeviceNotAvailableException, TargetSetupError {
        CommandResult commandResult = iTestDevice.executeFastbootCommand(stringArray);
        return this.handleFastbootResult(iTestDevice, commandResult, stringArray);
    }

    protected String executeLongFastbootCmd(ITestDevice iTestDevice, String ... stringArray) throws DeviceNotAvailableException, TargetSetupError {
        CommandResult commandResult = iTestDevice.executeLongFastbootCommand(stringArray);
        return this.handleFastbootResult(iTestDevice, commandResult, stringArray);
    }

    private String handleFastbootResult(ITestDevice iTestDevice, CommandResult commandResult, String ... stringArray) throws TargetSetupError {
        if (commandResult.getStatus() != CommandStatus.SUCCESS || commandResult.getStderr().contains("FAILED")) {
            throw new TargetSetupError(String.format("fastboot command %s failed in device %s. stdout: %s, stderr: %s", stringArray[0], iTestDevice.getSerialNumber(), commandResult.getStdout(), commandResult.getStderr()));
        }
        if (commandResult.getStderr().length() > 0) {
            return commandResult.getStderr();
        }
        return commandResult.getStdout();
    }
}

