/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;

public abstract class DeviceFlashPreparer
implements ITargetPreparer {
    private static final String LOG_TAG = "DeviceFlashPreparer";
    private static final int BOOT_POLL_TIME_MS = 5000;
    @Option(name="device-boot-time", description="max time in ms to wait for device to boot. Default 5 minutes.")
    private long mDeviceBootTime = 300000L;
    @Option(name="userdata-flash", description="specify handling of userdata partition. One of FLASH (default), TESTS_ZIP, WIPE, SKIP")
    private String mUserDataFlashString = IDeviceFlasher.UserDataFlashOption.FLASH.toString();

    void setDeviceBootTime(long l) {
        this.mDeviceBootTime = l;
    }

    int getDeviceBootPollTimeMs() {
        return 5000;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    public void setUserDataFlashOption(String string) {
        this.mUserDataFlashString = string;
    }

    public void setUp(ITestDevice iTestDevice, IBuildInfo iBuildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", iTestDevice.getSerialNumber()));
        if (!(iBuildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a IDeviceBuildInfo");
        }
        IDeviceBuildInfo iDeviceBuildInfo = (IDeviceBuildInfo)iBuildInfo;
        IDeviceFlasher iDeviceFlasher = this.createFlasher(iTestDevice);
        iDeviceFlasher.setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption.valueOf(this.mUserDataFlashString));
        iDeviceFlasher.flash(iTestDevice, iDeviceBuildInfo);
        iTestDevice.waitForDeviceOnline();
        this.waitForBootComplete(iTestDevice, iBuildInfo.getBuildId());
        iTestDevice.waitForDeviceAvailable();
    }

    protected abstract IDeviceFlasher createFlasher(ITestDevice var1) throws DeviceNotAvailableException;

    private void waitForBootComplete(ITestDevice iTestDevice, int n) throws DeviceNotAvailableException, BuildError {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < this.mDeviceBootTime) {
            String string = iTestDevice.executeShellCommand("getprop dev.bootcomplete");
            if ((string = string.replace('#', ' ').trim()).equals("1")) {
                return;
            }
            this.getRunUtil().sleep(this.getDeviceBootPollTimeMs());
        }
        throw new BuildError(String.format("Device %s running build %d did not boot after %d ms", iTestDevice.getSerialNumber(), n, this.mDeviceBootTime));
    }
}

