/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IAppBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class AppSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "AppSetup";
    @Option(name="app-package-name", description="the package name(s) of app and tests. Used for device cleanup of old packages before starting tests.")
    private Collection<String> mAppPackageNames = new ArrayList<String>();
    @Option(name="reboot", description="reboot device during setup")
    private boolean mReboot = true;

    public void setUp(ITestDevice iTestDevice, IBuildInfo iBuildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!(iBuildInfo instanceof IAppBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a AppBuildInfo");
        }
        IAppBuildInfo iAppBuildInfo = (IAppBuildInfo)iBuildInfo;
        Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", iTestDevice.getSerialNumber()));
        for (String object : this.mAppPackageNames) {
            iTestDevice.uninstallPackage(object);
        }
        if (this.mReboot) {
            iTestDevice.reboot();
        }
        for (File file : iAppBuildInfo.getAppPackageFiles()) {
            iTestDevice.installPackage(file, true);
        }
    }
}

