/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.kxml2.io.KXmlSerializer;

public class XmlResultReporter
extends CollectingTestListener {
    private static final String LOG_TAG = "XmlResultReporter";
    private static final String TEST_RESULT_FILE_SUFFIX = ".xml";
    private static final String TEST_RESULT_FILE_PREFIX = "test_result_";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String PROPERTIES = "properties";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private static final String ns = null;
    private static final String REPORT_DIR_NAME = "output-file-path";
    @Option(name="output-file-path", description="root file system path to directory to store xml test results and associated logs")
    private File mReportDir = new File(System.getProperty("java.io.tmpdir"));
    private ILogFileSaver mLogFileSaver;
    private IBuildInfo mBuildInfo;
    private String mReportPath = "";

    public void invocationEnded(long l) {
        super.invocationEnded(l);
        if (this.mReportDir != null) {
            this.generateSummary(this.mLogFileSaver.getFileDir(), l);
        }
    }

    public void invocationStarted(IBuildInfo iBuildInfo) {
        super.invocationStarted(iBuildInfo);
        if (this.mReportDir == null) {
            throw new IllegalArgumentException(String.format("missing %s", REPORT_DIR_NAME));
        }
        this.mLogFileSaver = new LogFileSaver(iBuildInfo, this.mReportDir);
        this.mBuildInfo = iBuildInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateSummary(File file, long l) {
        String string = this.getTimestamp();
        OutputStream outputStream = null;
        outputStream = this.createOutputResultStream(file);
        KXmlSerializer kXmlSerializer = new KXmlSerializer();
        kXmlSerializer.setOutput(outputStream, "UTF-8");
        kXmlSerializer.startDocument("UTF-8", null);
        kXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        this.printTestResults(kXmlSerializer, string, l);
        kXmlSerializer.endDocument();
        String string2 = String.format("XML test result file generated at %s. Total tests %d, Failed %d, Error %d", this.getAbsoluteReportPath(), this.getNumTotalTests(), this.getNumFailedTests(), this.getNumErrorTests());
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)string2);
        Object var9_8 = null;
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Log.e((String)LOG_TAG, (String)"Failed to generate report data");
                Object var9_9 = null;
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getAbsoluteReportPath() {
        return this.mReportPath;
    }

    String getTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        simpleDateFormat.setTimeZone(timeZone);
        simpleDateFormat.setLenient(true);
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    OutputStream createOutputResultStream(File file) throws IOException {
        File file2 = FileUtil.createTempFile(TEST_RESULT_FILE_PREFIX, TEST_RESULT_FILE_SUFFIX, file);
        Log.i((String)LOG_TAG, (String)String.format("Created xml report file at %s", file2.getAbsolutePath()));
        this.mReportPath = file2.getAbsolutePath();
        return new FileOutputStream(file2);
    }

    void printTestResults(KXmlSerializer kXmlSerializer, String string, long l) throws IOException {
        kXmlSerializer.startTag(ns, TESTSUITE);
        kXmlSerializer.attribute(ns, ATTR_NAME, this.mBuildInfo.getTestTarget());
        kXmlSerializer.attribute(ns, ATTR_TESTS, Integer.toString(this.getNumTotalTests()));
        kXmlSerializer.attribute(ns, ATTR_FAILURES, Integer.toString(this.getNumFailedTests()));
        kXmlSerializer.attribute(ns, ATTR_ERRORS, Integer.toString(this.getNumErrorTests()));
        kXmlSerializer.attribute(ns, ATTR_TIME, Long.toString(l));
        kXmlSerializer.attribute(ns, TIMESTAMP, string);
        kXmlSerializer.attribute(ns, HOSTNAME, "localhost");
        kXmlSerializer.startTag(ns, PROPERTIES);
        kXmlSerializer.endTag(ns, PROPERTIES);
        for (TestRunResult testRunResult : this.getRunResults()) {
            Map<TestIdentifier, TestResult> map = testRunResult.getTestResults();
            for (Map.Entry<TestIdentifier, TestResult> entry : map.entrySet()) {
                this.print(kXmlSerializer, entry.getKey(), entry.getValue());
            }
        }
        kXmlSerializer.endTag(ns, TESTSUITE);
    }

    void print(KXmlSerializer kXmlSerializer, TestIdentifier testIdentifier, TestResult testResult) throws IOException {
        kXmlSerializer.startTag(ns, TESTCASE);
        kXmlSerializer.attribute(ns, ATTR_NAME, testIdentifier.getTestName());
        kXmlSerializer.attribute(ns, ATTR_CLASSNAME, testIdentifier.getClassName());
        kXmlSerializer.attribute(ns, ATTR_TIME, "0");
        if (!TestResult.TestStatus.PASSED.equals((Object)testResult.getStatus())) {
            String string = testResult.getStatus().equals((Object)TestResult.TestStatus.FAILURE) ? FAILURE : ERROR;
            kXmlSerializer.startTag(ns, string);
            String string2 = this.sanitize(testResult.getStackTrace());
            kXmlSerializer.text(string2);
            kXmlSerializer.endTag(ns, string);
        }
        kXmlSerializer.endTag(ns, TESTCASE);
    }

    private String sanitize(String string) {
        return string.replace("\u0000", "<\\0>");
    }

    void setReportDir(File file) {
        this.mReportDir = file;
    }

    public void testLog(String string, LogDataType logDataType, InputStreamSource inputStreamSource) {
        try {
            File file = this.mLogFileSaver.saveLogData(string, logDataType, inputStreamSource.createInputStream());
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)String.format("Saved %s log to %s", string, file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Failed to save log data");
            Log.e((String)LOG_TAG, (Throwable)iOException);
        }
    }
}

