/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.result.TestResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunResult {
    private final String mTestRunName;
    private Map<TestIdentifier, TestResult> mTestResults = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, String> mRunMetrics = new HashMap<String, String>();
    private boolean mIsRunComplete = false;
    private long mElapsedTime = 0L;
    private int mNumFailedTests = 0;
    private int mNumErrorTests = 0;
    private int mNumPassedTests = 0;
    private String mRunFailureError = null;

    public TestRunResult(String string) {
        this.mTestRunName = string;
    }

    public TestRunResult() {
        this("not started");
    }

    public String getName() {
        return this.mTestRunName;
    }

    public Map<TestIdentifier, TestResult> getTestResults() {
        return this.mTestResults;
    }

    public void addMetrics(Map<String, String> map, boolean bl) {
        if (bl) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = this.mRunMetrics.get(entry.getKey());
                String string2 = this.combineValues(string, entry.getValue());
                this.mRunMetrics.put(entry.getKey(), string2);
            }
        } else {
            this.mRunMetrics.putAll(map);
        }
    }

    private String combineValues(String string, String string2) {
        if (string != null) {
            try {
                Long l = Long.parseLong(string);
                Long l2 = Long.parseLong(string2);
                return Long.toString(l + l2);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double d = Double.parseDouble(string);
                    Double d2 = Double.parseDouble(string2);
                    return Double.toString(d + d2);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return string2;
    }

    public Map<String, String> getRunMetrics() {
        return this.mRunMetrics;
    }

    public Set<TestIdentifier> getTests() {
        return this.mTestResults.keySet();
    }

    public boolean isRunFailure() {
        return this.mRunFailureError != null;
    }

    public boolean isRunComplete() {
        return this.mIsRunComplete;
    }

    void setRunComplete(boolean bl) {
        this.mIsRunComplete = bl;
    }

    void addElapsedTime(long l) {
        this.mElapsedTime += l;
    }

    void setRunFailureError(String string) {
        this.mRunFailureError = string;
    }

    public int getNumPassedTests() {
        return this.mNumPassedTests;
    }

    public int getNumTests() {
        return this.mTestResults.size();
    }

    public int getNumFailedTests() {
        return this.mNumFailedTests;
    }

    public int getNumErrorTests() {
        return this.mNumErrorTests;
    }

    public boolean hasFailedTests() {
        return this.getNumErrorTests() > 0 || this.getNumFailedTests() > 0;
    }

    public long getElapsedTime() {
        return this.mElapsedTime;
    }

    public String getRunFailureMessage() {
        return this.mRunFailureError;
    }

    public boolean addResult(TestIdentifier testIdentifier, TestResult testResult) {
        if (!this.mTestResults.containsKey(testIdentifier)) {
            this.mTestResults.put(testIdentifier, testResult);
            switch (testResult.getStatus()) {
                case ERROR: {
                    ++this.mNumErrorTests;
                    break;
                }
                case FAILURE: {
                    ++this.mNumFailedTests;
                    break;
                }
                case PASSED: {
                    ++this.mNumPassedTests;
                }
            }
            return true;
        }
        return false;
    }
}

