/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SnapshotInputStreamSource
implements InputStreamSource {
    private static final String LOG_TAG = "SnapshotInputStreamSource";
    private File mBackingFile;
    private boolean mIsCancelled = false;

    public SnapshotInputStreamSource(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            this.mBackingFile = this.createBackingFile(inputStream);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("Received IOException while trying to wrap a stream: %s", iOException));
            this.cancel();
        }
    }

    File createBackingFile(InputStream inputStream) throws IOException {
        File file = FileUtil.createTempFile("SnapshotInputStreamSource_", ".txt");
        FileUtil.writeToFile(inputStream, file);
        return file;
    }

    public synchronized InputStream createInputStream() {
        if (this.mIsCancelled) {
            return null;
        }
        try {
            return new FileInputStream(this.mBackingFile);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized void cancel() {
        this.mIsCancelled = true;
        if (this.mBackingFile != null) {
            this.mBackingFile.delete();
            this.mBackingFile = null;
        }
    }
}

