/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationSummaryHelper;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestSummary;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultForwarder
implements ITestInvocationListener {
    private final List<ITestInvocationListener> mListeners;

    public ResultForwarder(List<ITestInvocationListener> list) {
        this.mListeners = list;
    }

    public ResultForwarder(ITestInvocationListener ... iTestInvocationListenerArray) {
        this.mListeners = Arrays.asList(iTestInvocationListenerArray);
    }

    @Override
    public void invocationStarted(IBuildInfo iBuildInfo) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.invocationStarted(iBuildInfo);
        }
    }

    @Override
    public void invocationFailed(Throwable throwable) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.invocationFailed(throwable);
        }
    }

    @Override
    public void invocationEnded(long l) {
        InvocationSummaryHelper.reportInvocationEnded(this.mListeners, l);
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void testLog(String string, LogDataType logDataType, InputStreamSource inputStreamSource) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testLog(string, logDataType, inputStreamSource);
        }
    }

    public void testRunStarted(String string, int n) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testRunStarted(string, n);
        }
    }

    public void testRunFailed(String string) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testRunFailed(string);
        }
    }

    public void testRunStopped(long l) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testRunStopped(l);
        }
    }

    public void testRunEnded(long l, Map<String, String> map) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testRunEnded(l, map);
        }
    }

    public void testStarted(TestIdentifier testIdentifier) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testStarted(testIdentifier);
        }
    }

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testFailed(testFailure, testIdentifier, string);
        }
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> map) {
        for (ITestInvocationListener iTestInvocationListener : this.mListeners) {
            iTestInvocationListener.testEnded(testIdentifier, map);
        }
    }
}

