/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogFileSaver
implements ILogFileSaver {
    private static final String LOG_TAG = "LogFileSaver";
    private File mRootDir;

    public LogFileSaver(IBuildInfo iBuildInfo, File file) {
        File file2 = this.createBuildDir(iBuildInfo, file);
        try {
            this.mRootDir = FileUtil.createTempDir("inv_", file2);
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)String.format("Unable to create unique directory in %s", file2.getAbsolutePath()));
            Log.e((String)LOG_TAG, (Throwable)iOException);
            this.mRootDir = file2;
        }
        Log.i((String)LOG_TAG, (String)String.format("Using log file directory %s", this.mRootDir.getAbsolutePath()));
    }

    public File getFileDir() {
        return this.mRootDir;
    }

    private File createBuildDir(IBuildInfo iBuildInfo, File file) {
        File file2 = new File(file, Integer.toString(iBuildInfo.getBuildId()));
        if (file2.exists()) {
            if (file2.isDirectory()) {
                return file2;
            }
            Log.w((String)LOG_TAG, (String)String.format("Cannot create build-specific output dir %s. File already exists.", file2.getAbsolutePath()));
        } else {
            if (file2.mkdirs()) {
                if (!FileUtil.setGroupReadWritable(file2)) {
                    Log.w((String)LOG_TAG, (String)String.format("Failed to make  build-specific output dir %s group writable.", file2.getAbsolutePath()));
                }
                return file2;
            }
            Log.w((String)LOG_TAG, (String)String.format("Cannot create build-specific output dir %s. Failed to create directory.", file2.getAbsolutePath()));
        }
        return file;
    }

    public File saveLogData(String string, LogDataType logDataType, InputStream inputStream) throws IOException {
        File file = FileUtil.createTempFile(string + "_", "." + logDataType.getFileExt(), this.mRootDir);
        FileUtil.writeToFile(inputStream, file);
        Log.i((String)LOG_TAG, (String)String.format("Saved log file %s", file.getAbsolutePath()));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAndZipLogData(String string, LogDataType logDataType, InputStream inputStream) throws IOException {
        IOException iOException3;
        File file;
        ZipOutputStream zipOutputStream;
        block11: {
            BufferedInputStream bufferedInputStream = null;
            zipOutputStream = null;
            try {
                File file2 = FileUtil.createTempFile(string + "_", "." + LogDataType.ZIP.getFileExt(), this.mRootDir);
                bufferedInputStream = new BufferedInputStream(inputStream);
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                zipOutputStream.putNextEntry(new ZipEntry(string + "." + logDataType.getFileExt()));
                int n = -1;
                while ((n = bufferedInputStream.read()) != -1) {
                    zipOutputStream.write(n);
                }
                Log.i((String)LOG_TAG, (String)String.format("Saved log file %s", file2.getAbsolutePath()));
                file = file2;
                Object var10_9 = null;
                if (bufferedInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    IOException iOException22;
                    Object var10_10 = null;
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                    }
                    if (zipOutputStream == null) break block13;
                    try {
                        zipOutputStream.closeEntry();
                        zipOutputStream.close();
                    }
                    catch (IOException iOException22) {}
                }
                throw throwable;
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (zipOutputStream != null) {
            try {
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        return file;
    }
}

