/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.result.ITestInvocationListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitToInvocationResultForwarder
implements TestListener {
    private final List<ITestInvocationListener> mInvocationListeners;

    public JUnitToInvocationResultForwarder(ITestInvocationListener iTestInvocationListener) {
        this.mInvocationListeners = new ArrayList<ITestInvocationListener>(1);
        this.mInvocationListeners.add(iTestInvocationListener);
    }

    public JUnitToInvocationResultForwarder(List<ITestInvocationListener> list) {
        this.mInvocationListeners = new ArrayList<ITestInvocationListener>(list.size());
        this.mInvocationListeners.addAll(list);
    }

    @Override
    public void addError(Test test, Throwable throwable) {
        for (ITestInvocationListener iTestInvocationListener : this.mInvocationListeners) {
            iTestInvocationListener.testFailed(ITestRunListener.TestFailure.ERROR, this.getTestId(test), this.getStackTrace(throwable));
        }
    }

    @Override
    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        for (ITestInvocationListener iTestInvocationListener : this.mInvocationListeners) {
            iTestInvocationListener.testFailed(ITestRunListener.TestFailure.FAILURE, this.getTestId(test), this.getStackTrace(assertionFailedError));
        }
    }

    @Override
    public void endTest(Test test) {
        Map map = Collections.emptyMap();
        for (ITestInvocationListener iTestInvocationListener : this.mInvocationListeners) {
            iTestInvocationListener.testEnded(this.getTestId(test), map);
        }
    }

    @Override
    public void startTest(Test test) {
        for (ITestInvocationListener iTestInvocationListener : this.mInvocationListeners) {
            iTestInvocationListener.testStarted(this.getTestId(test));
        }
    }

    private TestIdentifier getTestId(Test test) {
        String string = test.getClass().getName();
        String string2 = "";
        if (test instanceof TestCase) {
            string2 = ((TestCase)test).getName();
        }
        return new TestIdentifier(string, string2);
    }

    private String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toString();
    }
}

