/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestSummary;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationToJUnitResultForwarder
implements ITestInvocationListener {
    private static final String LOG_TAG = "InvocationToJUnitResultForwarder";
    private TestListener mJUnitListener;

    public InvocationToJUnitResultForwarder(TestListener testListener) {
        this.mJUnitListener = testListener;
    }

    protected TestListener getJUnitListener() {
        return this.mJUnitListener;
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> map) {
        this.mJUnitListener.endTest(new TestIdentifierResult(testIdentifier));
    }

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
        TestIdentifierResult testIdentifierResult = new TestIdentifierResult(testIdentifier);
        if (ITestRunListener.TestFailure.ERROR.equals((Object)testFailure)) {
            RemoteException remoteException = new RemoteException(string);
            this.mJUnitListener.addError(testIdentifierResult, remoteException);
        } else {
            this.mJUnitListener.addFailure(testIdentifierResult, new AssertionFailedError(string));
        }
    }

    public void testRunEnded(long l, Map<String, String> map) {
        Log.i((String)LOG_TAG, (String)String.format("run ended %d ms", l));
    }

    public void testRunFailed(String string) {
        Log.e((String)LOG_TAG, (String)String.format("run failed: %s", string));
    }

    public void testRunStarted(String string, int n) {
        Log.i((String)LOG_TAG, (String)String.format("run %s started: %d tests", string, n));
    }

    public void testRunStopped(long l) {
        Log.i((String)LOG_TAG, (String)String.format("run stopped: %d ms", l));
    }

    public void testStarted(TestIdentifier testIdentifier) {
        Log.d((String)LOG_TAG, (String)testIdentifier.toString());
        this.mJUnitListener.startTest(new TestIdentifierResult(testIdentifier));
    }

    @Override
    public void invocationEnded(long l) {
    }

    @Override
    public void invocationFailed(Throwable throwable) {
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void invocationStarted(IBuildInfo iBuildInfo) {
    }

    @Override
    public void testLog(String string, LogDataType logDataType, InputStreamSource inputStreamSource) {
    }

    private static class RemoteException
    extends Throwable {
        private static final long serialVersionUID = 8510440697482917390L;
        private final String mStackTrace;

        RemoteException(String string) {
            this.mStackTrace = string;
        }

        public void printStackTrace() {
            System.err.print(this.mStackTrace);
        }

        public void printStackTrace(PrintStream printStream) {
            printStream.print(this.mStackTrace);
        }

        public void printStackTrace(PrintWriter printWriter) {
            printWriter.print(this.mStackTrace);
        }

        public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.mStackTrace;
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static class TestIdentifierResult
    implements Test {
        private final TestIdentifier mTestId;

        private TestIdentifierResult(TestIdentifier testIdentifier) {
            this.mTestId = testIdentifier;
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult testResult) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return this.mTestId.equals(object);
        }

        public int hashCode() {
            return this.mTestId.hashCode();
        }

        public String toString() {
            return String.format("%s:%s", this.mTestId.getClassName(), this.mTestId.getTestName());
        }
    }
}

