/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.util.Email;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailResultReporter
extends CollectingTestListener
implements ITestSummaryListener {
    private static final String LOG_TAG = "EmailResultReporter";
    @Option(name="sender", description="The envelope-sender address to use for the messages")
    private String mSender = null;
    @Option(name="destination", description="One or more destination addresses")
    private Collection<String> mDestinations = new HashSet<String>();
    private List<TestSummary> mSummaries = null;

    @Override
    public void putSummary(List<TestSummary> list) {
        this.mSummaries = list;
    }

    protected boolean shouldSendMessage() {
        return true;
    }

    protected String generateEmailSubject() {
        return String.format("Tradefed: %d passed, %d failed, %d error", this.getNumPassedTests(), this.getNumFailedTests(), this.getNumErrorTests());
    }

    protected String generateEmailBody() {
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator<TestSummary> listIterator = this.mSummaries.listIterator();
        while (listIterator.hasNext()) {
            TestSummary testSummary = listIterator.next();
            stringBuilder.append("Source ");
            stringBuilder.append(testSummary.getSource());
            stringBuilder.append(" provided summary \"");
            stringBuilder.append(testSummary.getSummary().getString());
            stringBuilder.append("\".\nIts key-value dump was:\n");
            stringBuilder.append(testSummary.getKvEntries().toString());
            stringBuilder.append("\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void invocationEnded(long l) {
        if (this.mDestinations.isEmpty()) {
            Log.e((String)LOG_TAG, (String)"Failed to send email because no destination addresses were set.");
            return;
        }
        Email email = new Email();
        email.setSender(this.mSender);
        Email.Message message = new Email.Message();
        message.setSubject(this.generateEmailSubject());
        message.setBody(this.generateEmailBody());
        Iterator<String> iterator = this.mDestinations.iterator();
        while (iterator.hasNext()) {
            message.addTo(iterator.next());
        }
        try {
            email.send(message);
        }
        catch (Throwable throwable) {
            System.err.println("Caught a throwable: " + throwable.toString());
        }
    }
}

