/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectingTestListener
implements ITestInvocationListener {
    private Map<String, TestRunResult> mRunResultsMap = Collections.synchronizedMap(new LinkedHashMap());
    private TestRunResult mCurrentResults = new TestRunResult();
    @Option(name="aggregate-metrics", description="attempt to add test metrics values for test runs with the same name")
    private boolean mIsAggregateMetrics = false;
    private int mNumPassedTests = 0;
    private int mNumFailedTests = 0;
    private int mNumErrorTests = 0;

    void setIsAggregrateMetrics(boolean bl) {
        this.mIsAggregateMetrics = bl;
    }

    @Override
    public void invocationStarted(IBuildInfo iBuildInfo) {
    }

    public void testRunStarted(String string, int n) {
        if (this.mRunResultsMap.containsKey(string)) {
            this.mCurrentResults = this.mRunResultsMap.get(string);
        } else {
            this.mCurrentResults = new TestRunResult(string);
            this.mRunResultsMap.put(string, this.mCurrentResults);
        }
        this.mCurrentResults.setRunComplete(false);
        this.mCurrentResults.setRunFailureError(null);
    }

    public void testStarted(TestIdentifier testIdentifier) {
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> map) {
        if (this.mCurrentResults.addResult(testIdentifier, new TestResult(TestResult.TestStatus.PASSED))) {
            ++this.mNumPassedTests;
        }
        this.mCurrentResults.getTestResults().get(testIdentifier).setMetrics(map);
    }

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
        if (testFailure.equals((Object)ITestRunListener.TestFailure.ERROR)) {
            if (this.mCurrentResults.addResult(testIdentifier, new TestResult(TestResult.TestStatus.ERROR, string))) {
                ++this.mNumErrorTests;
            }
        } else if (this.mCurrentResults.addResult(testIdentifier, new TestResult(TestResult.TestStatus.FAILURE, string))) {
            ++this.mNumFailedTests;
        }
    }

    public void testRunEnded(long l, Map<String, String> map) {
        this.mCurrentResults.setRunComplete(true);
        this.mCurrentResults.addMetrics(map, this.mIsAggregateMetrics);
        this.mCurrentResults.addElapsedTime(l);
    }

    public void testRunFailed(String string) {
        this.mCurrentResults.setRunFailureError(string);
    }

    public void testRunStopped(long l) {
        this.mCurrentResults.setRunComplete(true);
        this.mCurrentResults.addElapsedTime(l);
    }

    public TestRunResult getCurrentRunResults() {
        return this.mCurrentResults;
    }

    public Collection<TestRunResult> getRunResults() {
        return this.mRunResultsMap.values();
    }

    public int getNumTotalTests() {
        return this.getNumFailedTests() + this.getNumErrorTests() + this.getNumPassedTests();
    }

    public int getNumFailedTests() {
        return this.mNumFailedTests;
    }

    public int getNumErrorTests() {
        return this.mNumErrorTests;
    }

    public int getNumPassedTests() {
        return this.mNumPassedTests;
    }

    public boolean hasFailedTests() {
        return this.getNumErrorTests() > 0 || this.getNumFailedTests() > 0;
    }

    @Override
    public void invocationEnded(long l) {
    }

    @Override
    public void invocationFailed(Throwable throwable) {
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void testLog(String string, LogDataType logDataType, InputStreamSource inputStreamSource) {
    }
}

