/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.log.FileLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRegistry
implements Log.ILogOutput {
    private static final String LOG_TAG = "LogRegistry";
    private static LogRegistry mLogRegistry = null;
    private Map<ThreadGroup, ILeveledLogOutput> mLogTable = new Hashtable<ThreadGroup, ILeveledLogOutput>();
    private FileLogger mGlobalLogger;

    LogRegistry() {
        try {
            this.mGlobalLogger = new FileLogger();
            this.mGlobalLogger.init();
        }
        catch (IOException iOException) {
            System.err.println("Failed to create global logger");
            throw new IllegalStateException(iOException);
        }
    }

    public static LogRegistry getLogRegistry() {
        if (mLogRegistry == null) {
            mLogRegistry = new LogRegistry();
        }
        return mLogRegistry;
    }

    public void setGlobalLogDisplayLevel(String string) {
        this.mGlobalLogger.setLogLevelDisplay(string);
    }

    public void setGlobalLogTagDisplay(Collection<String> collection) {
        this.mGlobalLogger.addLogTagsDisplay(collection);
    }

    public String getGlobalLogDisplayLevel() {
        return this.mGlobalLogger.getLogLevelDisplay();
    }

    public void registerLogger(ILeveledLogOutput iLeveledLogOutput) {
        ILeveledLogOutput iLeveledLogOutput2 = this.mLogTable.put(this.getCurrentThreadGroup(), iLeveledLogOutput);
        if (iLeveledLogOutput2 != null) {
            Log.e((String)LOG_TAG, (String)"Registering a new logger when one already exists for this thread!");
            iLeveledLogOutput2.closeLog();
        }
    }

    public void unregisterLogger() {
        ThreadGroup threadGroup = this.getCurrentThreadGroup();
        if (threadGroup != null) {
            this.mLogTable.remove(threadGroup);
        } else {
            this.printLog(Log.LogLevel.ERROR, LOG_TAG, "Unregistering when thread has no logger registered.");
        }
    }

    ThreadGroup getCurrentThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public void printLog(Log.LogLevel logLevel, String string, String string2) {
        ILeveledLogOutput iLeveledLogOutput = this.getLogger();
        Log.LogLevel logLevel2 = Log.LogLevel.getByString((String)iLeveledLogOutput.getLogLevel());
        if (logLevel.getPriority() >= logLevel2.getPriority()) {
            iLeveledLogOutput.printLog(logLevel, string, string2);
        }
    }

    public void printAndPromptLog(Log.LogLevel logLevel, String string, String string2) {
        this.getLogger().printAndPromptLog(logLevel, string, string2);
    }

    ILeveledLogOutput getLogger() {
        ILeveledLogOutput iLeveledLogOutput = this.mLogTable.get(this.getCurrentThreadGroup());
        if (iLeveledLogOutput == null) {
            iLeveledLogOutput = this.mGlobalLogger;
        }
        return iLeveledLogOutput;
    }

    public void closeAndRemoveAllLogs() {
        Collection<ILeveledLogOutput> collection = this.mLogTable.values();
        Iterator<ILeveledLogOutput> iterator = collection.iterator();
        while (iterator.hasNext()) {
            ILeveledLogOutput iLeveledLogOutput = iterator.next();
            iLeveledLogOutput.closeLog();
            iterator.remove();
        }
        this.saveGlobalLog();
        this.mGlobalLogger.closeLog();
    }

    public void saveGlobalLog() {
        InputStreamSource inputStreamSource = this.mGlobalLogger.getLog();
        this.saveLog("tradefed_global_log_", inputStreamSource);
        inputStreamSource.cancel();
    }

    private void saveLog(String string, InputStreamSource inputStreamSource) {
        try {
            File file = FileUtil.createTempFile(string, ".txt");
            FileUtil.writeToFile(inputStreamSource.createInputStream(), file);
            System.out.println(String.format("Saved log to %s", file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dumpLogs() {
        for (Map.Entry<ThreadGroup, ILeveledLogOutput> entry : this.mLogTable.entrySet()) {
            String string = String.format("%s_log_", entry.getKey().getName());
            InputStreamSource inputStreamSource = entry.getValue().getLog();
            this.saveLog(string, inputStreamSource);
            inputStreamSource.cancel();
        }
        this.saveGlobalLog();
    }
}

