/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.log;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLogger
implements ILeveledLogOutput {
    private static final String TEMP_FILE_PREFIX = "tradefed_log_";
    private static final String TEMP_FILE_SUFFIX = ".txt";
    private File mTempLogFile = null;
    private BufferedWriter mLogWriter = null;
    @Option(name="log-level", description="minimum log level to log")
    private String mLogLevel = Log.LogLevel.DEBUG.getStringValue();
    @Option(name="log-level-display", description="minimum log level to display on stdout")
    private String mLogLevelStringDisplay = Log.LogLevel.ERROR.getStringValue();
    @Option(name="log-tag-display", description="Always display given tags logs on stdout")
    private Collection<String> mLogTagsDisplay = new HashSet<String>();

    void setLogLevelDisplay(String string) {
        this.mLogLevelStringDisplay = string;
    }

    String getLogLevelDisplay() {
        return this.mLogLevelStringDisplay;
    }

    void addLogTagsDisplay(Collection<String> collection) {
        this.mLogTagsDisplay.addAll(collection);
    }

    @Override
    public void init() throws IOException {
        try {
            this.mTempLogFile = FileUtil.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.mLogWriter = new BufferedWriter(new FileWriter(this.mTempLogFile));
        }
        catch (IOException iOException) {
            if (this.mTempLogFile != null) {
                this.mTempLogFile.delete();
            }
            throw iOException;
        }
    }

    @Override
    public ILeveledLogOutput clone() {
        FileLogger fileLogger = new FileLogger();
        fileLogger.setLogLevelDisplay(this.mLogLevelStringDisplay);
        fileLogger.setLogLevel(this.mLogLevel);
        fileLogger.addLogTagsDisplay(this.mLogTagsDisplay);
        return fileLogger;
    }

    public void printAndPromptLog(Log.LogLevel logLevel, String string, String string2) {
        this.internalPrintLog(logLevel, string, string2, true);
    }

    public void printLog(Log.LogLevel logLevel, String string, String string2) {
        this.internalPrintLog(logLevel, string, string2, false);
    }

    private void internalPrintLog(Log.LogLevel logLevel, String string, String string2, boolean bl) {
        String string3 = LogUtil.getLogFormatString(logLevel, string, string2);
        Log.LogLevel logLevel2 = Log.LogLevel.getByString((String)this.mLogLevelStringDisplay);
        if (bl || logLevel.getPriority() >= logLevel2.getPriority() || this.mLogTagsDisplay.contains(string)) {
            System.out.print(string3);
        }
        try {
            this.writeToLog(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void writeToLog(String string) throws IOException {
        if (this.mLogWriter != null) {
            this.mLogWriter.write(string);
        }
    }

    @Override
    public String getLogLevel() {
        return this.mLogLevel;
    }

    @Override
    public void setLogLevel(String string) {
        this.mLogLevel = string;
    }

    String getFilename() throws SecurityException {
        if (this.mTempLogFile == null) {
            throw new IllegalStateException("logger has already been closed or has not been initialized");
        }
        return this.mTempLogFile.getAbsolutePath();
    }

    @Override
    public InputStreamSource getLog() {
        if (this.mLogWriter == null) {
            System.err.println(String.format("logger has already been closed or has not been initialized, Thread %s", Thread.currentThread().getName()));
        } else {
            try {
                this.mLogWriter.flush();
                return new SnapshotInputStreamSource(new FileInputStream(this.mTempLogFile));
            }
            catch (IOException iOException) {
                System.err.println("Failed to get log");
                iOException.printStackTrace();
            }
        }
        return new ByteArrayInputStreamSource(new byte[0]);
    }

    @Override
    public void closeLog() {
        try {
            this.doCloseLog();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCloseLog() throws IOException {
        block4: {
            try {
                if (this.mLogWriter != null) {
                    BufferedWriter bufferedWriter = this.mLogWriter;
                    this.mLogWriter = null;
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                Object var3_2 = null;
                if (this.mTempLogFile == null) break block4;
                this.mTempLogFile.delete();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.mTempLogFile != null) {
                    this.mTempLogFile.delete();
                    this.mTempLogFile = null;
                }
                throw throwable;
            }
            this.mTempLogFile = null;
            {
            }
        }
    }
}

